/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.ars.service.task.impl;

import com.abcxin.smart.validator.annotation.DataSyncAnnotation;
import com.bcxin.ars.dao.SecurityPersonDao;
import com.bcxin.ars.dao.task.TaskTrackDao;
import com.bcxin.ars.dto.DataSynchronizationSearchDto;
import com.bcxin.ars.enums.ImportType;
import com.bcxin.ars.model.SecurityPerson;
import com.bcxin.ars.model.task.TaskTrack;
import com.bcxin.ars.service.task.TaskTrackService;
import com.bcxin.ars.service.util.ArsUtil;
import com.bcxin.ars.service.util.ConfigUtils;
import com.bcxin.ars.util.DateUtil;
import java.util.Date;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
@DataSyncAnnotation(getClazz=TaskTrack.class, getImportType=ImportType.BATCH, getMethodName="importBatch")
public class TaskTrackServiceImpl
implements TaskTrackService {
    @Autowired
    private TaskTrackDao taskTrackDao;
    @Autowired
    private SecurityPersonDao personDao;
    @Autowired
    private ArsUtil arsUtil;
    @Autowired
    private ConfigUtils configUtils;

    public Long save(TaskTrack track) {
        SecurityPerson person = this.personDao.findById(track.getPersonId());
        if (person != null) {
            person.setLatitude(track.getLatitude());
            person.setLongitude(track.getLongitude());
            person.setUpdateTime(new Date());
            this.personDao.updateSelective(person);
        }
        track.setNativeCode(this.arsUtil.getCurrentNatvie());
        track.setUpdateTime(new Date());
        return this.taskTrackDao.save(track);
    }

    public Long saveForSaaS(TaskTrack track) {
        track.setNativeCode(this.arsUtil.getCurrentNatvie());
        track.setUpdateTime(new Date());
        return this.taskTrackDao.save(track);
    }

    public List<TaskTrack> findByFeedbackId(Long feedbackId) {
        return this.taskTrackDao.findByFeedbackId(feedbackId);
    }

    public List<TaskTrack> searchForDataSynchronization(DataSynchronizationSearchDto searchDto) {
        return this.taskTrackDao.searchForDataSynchronization(searchDto);
    }

    public void importBatch(List<TaskTrack> list) {
        List dbList = this.taskTrackDao.findByBatchId(list);
        list.removeAll(dbList);
        if (list.size() > 0) {
            for (TaskTrack taskTrack : list) {
                taskTrack.setUpdateflag(Boolean.valueOf(false));
                try {
                    if (this.configUtils.isIntranet()) continue;
                    taskTrack.setUpdateTime(DateUtil.dateAdd((int)6, (Date)taskTrack.getUpdateTime(), (int)1));
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            this.taskTrackDao.saveBatch(list);
        }
    }
}

