/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.ars.service.task.impl;

import com.abcxin.smart.validator.annotation.DataSyncAnnotation;
import com.bcxin.ars.dao.task.ComShiftRuleDao;
import com.bcxin.ars.dto.DataSynchronizationSearchDto;
import com.bcxin.ars.dto.SearchDto;
import com.bcxin.ars.dto.page.task.ComShiftRulePageSearchDto;
import com.bcxin.ars.enums.ImportType;
import com.bcxin.ars.model.User;
import com.bcxin.ars.model.task.ComShiftRule;
import com.bcxin.ars.service.task.ComShiftRuleService;
import com.bcxin.ars.service.util.ArsUtil;
import com.bcxin.ars.service.util.ConfigUtils;
import com.bcxin.ars.util.BeanUtils;
import com.bcxin.ars.util.DateUtil;
import com.com.bcxin.ars.com.abcxin.smart.core.web.validate.AjaxPageResponse;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
@DataSyncAnnotation(getClazz=ComShiftRule.class, getMethodName="importBatch", getImportType=ImportType.BATCH)
public class ComShiftRuleServiceImpl
implements ComShiftRuleService {
    Logger logger = LoggerFactory.getLogger(ComShiftRuleServiceImpl.class);
    @Autowired
    private ComShiftRuleDao comShiftRuleDao;
    @Autowired
    private ConfigUtils configUtils;
    @Autowired
    private ArsUtil arsUtil;

    public int delete(ComShiftRule comShiftRule) {
        User currentUser = this.arsUtil.getCurrentUser();
        comShiftRule.setUpdateTime(new Date());
        comShiftRule.setUpdateBy(currentUser.getUsername());
        return this.comShiftRuleDao.delete(comShiftRule);
    }

    public int save(ComShiftRule comShiftRule) {
        ComShiftRule dbComShiftRule = this.comShiftRuleDao.findById(comShiftRule.getShiftRuleId());
        User currentUser = this.arsUtil.getCurrentUser();
        if (dbComShiftRule == null) {
            comShiftRule.setCreateTime(new Date());
        } else {
            BeanUtils.copyPropertiesIgnore((Object)comShiftRule, (Object)dbComShiftRule, (Boolean)true);
            BeanUtils.copyPropertiesIgnore((Object)dbComShiftRule, (Object)comShiftRule, (Boolean)false);
        }
        comShiftRule.setUpdateBy(currentUser.getUsername());
        comShiftRule.setUpdateTime(new Date());
        return this.comShiftRuleDao.save(comShiftRule);
    }

    public ComShiftRule findById(Long id) {
        return this.comShiftRuleDao.findById(id);
    }

    public void searchForPage(ComShiftRulePageSearchDto dto, AjaxPageResponse page) {
        this.arsUtil.setPoliceSearch((SearchDto)dto);
        this.comShiftRuleDao.searchForPage(dto, page);
    }

    public void importBatch(List<ComShiftRule> list) {
        List dbList = this.comShiftRuleDao.findByBatchId(list);
        list.removeAll(dbList);
        if (list.size() > 0) {
            for (ComShiftRule comShiftRule : list) {
                try {
                    if (this.configUtils.isIntranet()) continue;
                    comShiftRule.setUpdateTime(DateUtil.dateAdd((int)6, (Date)comShiftRule.getUpdateTime(), (int)1));
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            this.comShiftRuleDao.saveBatch(list);
        }
    }

    public List<ComShiftRule> searchForDataSynchronization(DataSynchronizationSearchDto dto) {
        return this.comShiftRuleDao.searchForDataSynchronization(dto);
    }

    public List<ComShiftRule> findDSOutList(String startDate) {
        return this.comShiftRuleDao.findDSOutList(startDate);
    }

    public List<ComShiftRule> findByBatchId(List<ComShiftRule> list) {
        return this.comShiftRuleDao.findByBatchId(list);
    }

    public void updateSelective(ComShiftRule comShiftRule) {
        User currentUser = this.arsUtil.getCurrentUser();
        comShiftRule.setUpdateTime(new Date());
        comShiftRule.setUpdateBy(currentUser.getUsername());
        this.comShiftRuleDao.updateSelective(comShiftRule);
    }
}

