/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.ars.service.sys.impl;

import com.bcxin.ars.dao.sys.DataChangeDao;
import com.bcxin.ars.dto.DataSynchronizationSearchDto;
import com.bcxin.ars.model.User;
import com.bcxin.ars.model.sys.DataChange;
import com.bcxin.ars.service.sys.DataChangeService;
import com.bcxin.ars.service.util.ArsUtil;
import com.bcxin.ars.service.util.ConfigUtils;
import com.bcxin.ars.service.util.IdWorker;
import com.bcxin.ars.util.BeanUtils;
import com.bcxin.ars.util.DateUtil;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class DataChangeServiceImpl
implements DataChangeService {
    Logger logger = LoggerFactory.getLogger(DataChangeServiceImpl.class);
    @Autowired
    private DataChangeDao dataChangeDao;
    @Autowired
    private ConfigUtils configUtils;
    @Autowired
    private ArsUtil arsUtil;
    @Autowired
    private IdWorker idWorker;

    public int delete(DataChange dataChange) {
        User currentUser = this.arsUtil.getCurrentUser();
        dataChange.setUpdateTime(new Date());
        dataChange.setUpdateBy(currentUser.getUsername());
        return this.dataChangeDao.delete(dataChange);
    }

    public int save(DataChange dataChange) {
        User currentUser = this.arsUtil.getCurrentUser();
        if (dataChange.getId() == null) {
            dataChange.setId(Long.valueOf(this.idWorker.nextId()));
            dataChange.setCreateTime(new Date());
        } else {
            DataChange dbDataChange = this.dataChangeDao.findById(dataChange.getId());
            BeanUtils.copyPropertiesIgnore((Object)dataChange, (Object)dbDataChange, (Boolean)true);
            BeanUtils.copyPropertiesIgnore((Object)dbDataChange, (Object)dataChange, (Boolean)false);
        }
        dataChange.setActive(Boolean.valueOf(true));
        dataChange.setUpdateTime(new Date());
        dataChange.setUpdateflag(Boolean.valueOf(true));
        if (currentUser != null) {
            dataChange.setUpdateBy(currentUser.getUsername());
        } else {
            dataChange.setUpdateBy("system");
        }
        return this.dataChangeDao.save(dataChange);
    }

    public DataChange findById(Long id) {
        return this.dataChangeDao.findById(id);
    }

    public void importBatch(List<DataChange> list) {
        List dbList = this.dataChangeDao.findByBatchId(list);
        list.removeAll(dbList);
        if (list.size() > 0) {
            for (DataChange dataChange : list) {
                dataChange.setUpdateflag(Boolean.valueOf(false));
                try {
                    if (this.configUtils.isIntranet()) continue;
                    dataChange.setUpdateTime(DateUtil.dateAdd((int)6, (Date)dataChange.getUpdateTime(), (int)1));
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            this.dataChangeDao.saveBatch(list);
        }
    }

    public List<DataChange> searchForDataSynchronization(DataSynchronizationSearchDto dto) {
        return this.dataChangeDao.searchForDataSynchronization(dto);
    }

    public List<DataChange> findDSOutList(String startDate) {
        return this.dataChangeDao.findDSOutList(startDate);
    }

    public List<DataChange> findByBatchId(List<DataChange> list) {
        return this.dataChangeDao.findByBatchId(list);
    }

    public void updateSelective(DataChange dataChange) {
        User currentUser = this.arsUtil.getCurrentUser();
        dataChange.setUpdateTime(new Date());
        dataChange.setUpdateBy(currentUser.getUsername());
        this.dataChangeDao.updateSelective(dataChange);
    }
}

