/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.ars.service.statistics;

import cn.hutool.core.collection.CollUtil;
import com.bcxin.ars.dao.statistics.SecurityStatisticsDao;
import com.bcxin.ars.dto.TreeView;
import com.bcxin.ars.dto.statistics.EchartMapData;
import com.bcxin.ars.dto.statistics.PageResultDTO;
import com.bcxin.ars.dto.statistics.ParamDTO;
import com.bcxin.ars.model.PageResult;
import com.bcxin.ars.service.statistics.SecurityStatisticsService;
import com.bcxin.ars.service.util.SysAreaUtil;
import com.bcxin.ars.util.StringUtil;
import com.beust.jcommander.internal.Lists;
import com.beust.jcommander.internal.Maps;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class SecurityStatisticsServiceImpl
implements SecurityStatisticsService {
    @Autowired
    private SecurityStatisticsDao securityStatisticsDao;
    @Autowired
    private SysAreaUtil sysAreaUtil;

    public Map securityCompanySummary(ParamDTO paramDTO) {
        if (StringUtil.isEmpty((String)paramDTO.getAreaCode())) {
            return Maps.newHashMap();
        }
        paramDTO.setAreaCode(this.subAreaCode(paramDTO.getAreaCode()));
        return this.securityStatisticsDao.getCompanyGeneral(paramDTO);
    }

    public PageResultDTO securityCompanyDetail(ParamDTO paramDTO) {
        PageResultDTO resultDTO = new PageResultDTO();
        this.paramAreaCode(paramDTO);
        List list = this.securityStatisticsDao.getCompanyNew(paramDTO);
        resultDTO.setAllData(list);
        List pageList = CollUtil.split((Collection)list, (int)paramDTO.getNumPerPage());
        resultDTO.setPageData((List)pageList.get(paramDTO.getPageNum()));
        resultDTO.setTotalCount(Integer.valueOf(list.size()));
        return resultDTO;
    }

    public List<Map> securityCompanyArea(ParamDTO paramDTO) {
        if (StringUtil.isEmpty((String)paramDTO.getAreaCode())) {
            return Lists.newArrayList();
        }
        paramDTO.setAreaCode(this.subAreaCode(paramDTO.getAreaCode()));
        List mapList = this.securityStatisticsDao.getCompanyArea(paramDTO);
        return mapList;
    }

    public Map securityPersonSummary(ParamDTO paramDTO) {
        if (StringUtil.isEmpty((String)paramDTO.getAreaCode())) {
            return Maps.newHashMap();
        }
        paramDTO.setAreaCode(this.subAreaCode(paramDTO.getAreaCode()));
        return this.securityStatisticsDao.getPersonDetail(paramDTO);
    }

    public PageResultDTO securityPersonDetail(ParamDTO paramDTO) {
        PageResultDTO resultDTO = new PageResultDTO();
        this.paramAreaCode(paramDTO);
        List list = this.securityStatisticsDao.getPersonZjAnalyse(paramDTO);
        resultDTO.setAllData(list);
        List pageList = CollUtil.split((Collection)list, (int)paramDTO.getNumPerPage());
        resultDTO.setPageData((List)pageList.get(paramDTO.getPageNum()));
        resultDTO.setTotalCount(Integer.valueOf(list.size()));
        return resultDTO;
    }

    public List<EchartMapData> holdCerAnalyse(ParamDTO paramDTO) {
        this.paramAreaCode(paramDTO);
        List list = Lists.newArrayList();
        Map resultMap = this.securityStatisticsDao.getHoldCerAnalyse(paramDTO);
        for (Object key : resultMap.keySet()) {
            EchartMapData data = new EchartMapData();
            if ("bayzgzs".equals(key)) {
                data.setName("\u4fdd\u5b89\u5458\u8d44\u683c\u8bc1");
            } else if ("cjbays".equals(key)) {
                data.setName("\u521d\u7ea7\u4fdd\u5b89\u5458");
            } else if ("zjbays".equals(key)) {
                data.setName("\u4e2d\u7ea7\u4fdd\u5b89\u5458");
            } else if ("gjbays".equals(key)) {
                data.setName("\u9ad8\u7ea7\u4fdd\u5b89\u5458");
            } else if ("bass".equals(key)) {
                data.setName("\u4fdd\u5b89\u5e08");
            } else if ("gjbass".equals(key)) {
                data.setName("\u9ad8\u7ea7\u4fdd\u5b89\u5e08");
            } else if ("wzrys".equals(key)) {
                data.setName("\u65e0\u8bc1\u4eba\u5458");
            }
            data.setValue(Integer.valueOf(Integer.parseInt(resultMap.get(key).toString())));
            list.add(data);
        }
        return list;
    }

    public PageResultDTO authAnalyse(ParamDTO paramDTO) {
        PageResultDTO resultDTO = new PageResultDTO();
        this.paramAreaCode(paramDTO);
        List list = this.securityStatisticsDao.getAuthAnalyse(paramDTO);
        resultDTO.setAllData(list);
        List pageList = CollUtil.split((Collection)list, (int)paramDTO.getNumPerPage());
        resultDTO.setPageData((List)pageList.get(paramDTO.getPageNum()));
        resultDTO.setTotalCount(Integer.valueOf(list.size()));
        return resultDTO;
    }

    public Map companySummary(ParamDTO paramDTO) {
        if (StringUtil.isEmpty((String)paramDTO.getAreaCode())) {
            return Maps.newHashMap();
        }
        paramDTO.setAreaCode(this.subAreaCode(paramDTO.getAreaCode()));
        return this.securityStatisticsDao.getCompanyStatistics(paramDTO);
    }

    public PageResult companyDetail(ParamDTO paramDTO) {
        paramDTO.setAreaCode(this.subAreaCode(paramDTO.getAreaCode()));
        List list = this.securityStatisticsDao.getCompanyList(paramDTO);
        List pageList = CollUtil.split((Collection)list, (int)paramDTO.getLimit());
        return new PageResult(Integer.valueOf(list.size()), pageList.get(paramDTO.getOffset() / paramDTO.getLimit()));
    }

    private void paramAreaCode(ParamDTO paramDTO) {
        if (StringUtil.isNotEmpty((String)paramDTO.getArea())) {
            paramDTO.setAreaCode(paramDTO.getArea());
            return;
        }
        if (StringUtil.isNotEmpty((String)paramDTO.getCity())) {
            paramDTO.setAreaCode(paramDTO.getCity().substring(0, 4));
            return;
        }
        if (StringUtil.isNotEmpty((String)paramDTO.getProvince())) {
            paramDTO.setAreaCode(paramDTO.getProvince().substring(0, 2));
            return;
        }
    }

    private String subAreaCode(String areaCode) {
        TreeView treeView = this.sysAreaUtil.getRegionByCode(areaCode);
        if ("1".equals(treeView.getLevel())) {
            return areaCode.substring(0, 2);
        }
        if ("2".equals(treeView.getLevel())) {
            return areaCode.substring(0, 4);
        }
        return areaCode;
    }
}

