/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.ars.service.sb.impl;

import com.abcxin.smart.validator.annotation.DataSyncAnnotation;
import com.bcxin.ars.dao.sb.ShareholderDao;
import com.bcxin.ars.dao.sb.ShareholderDaoAop;
import com.bcxin.ars.dto.DataSynchronizationSearchDto;
import com.bcxin.ars.dto.sb.ShareholderSearchDto;
import com.bcxin.ars.model.User;
import com.bcxin.ars.model.sb.Shareholder;
import com.bcxin.ars.service.sb.ShareholderService;
import com.bcxin.ars.service.util.ArsUtil;
import java.util.Date;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
@DataSyncAnnotation(getClazz=Shareholder.class)
public class ShareholderServiceImpl
implements ShareholderService {
    @Autowired
    private ShareholderDao shareholderDao;
    @Autowired
    private ShareholderDaoAop shareholderDaoAop;
    @Autowired
    private ArsUtil arsUtil;

    public Shareholder findById(long id) {
        return this.shareholderDao.findById(Long.valueOf(id));
    }

    public Shareholder findByName(String name) {
        return this.shareholderDao.findByName(name);
    }

    public void saveOrUpdate(Shareholder shareholder) {
        User currentUser = this.arsUtil.getCurrentUser();
        if (shareholder.getId() == null) {
            shareholder.setActive(Boolean.valueOf(true));
            shareholder.setCreateTime(new Date());
            shareholder.setUpdateTime(new Date());
            shareholder.setUpdateBy(currentUser.getUsername());
            this.shareholderDao.save(shareholder);
        } else {
            Shareholder dbShareholder = this.shareholderDao.findById(shareholder.getId());
            dbShareholder.setUpdateTime(new Date());
            dbShareholder.setUpdateBy(currentUser.getUsername());
            dbShareholder.setUpdateTime(new Date());
            dbShareholder.setName(shareholder.getName());
            dbShareholder.setPercentage(shareholder.getPercentage());
            dbShareholder.setCensorstatus(shareholder.getCensorstatus());
            dbShareholder.setIdnumber(shareholder.getIdnumber());
            dbShareholder.setType(shareholder.getType());
            this.shareholderDao.update(dbShareholder);
        }
    }

    public void saveOrUpdateForDS(Shareholder shareholder) {
        Shareholder dbShareholder;
        if (shareholder.getActive() == null) {
            shareholder.setActive(Boolean.valueOf(true));
        }
        if ((dbShareholder = this.shareholderDao.findById(shareholder.getId())) != null) {
            if (shareholder.getUpdateTime().getTime() > dbShareholder.getUpdateTime().getTime()) {
                shareholder.setCensorstatus(dbShareholder.getCensorstatus());
                this.shareholderDao.update(shareholder);
            }
        } else {
            this.shareholderDao.saveForDS(shareholder);
        }
    }

    public ShareholderSearchDto search(ShareholderSearchDto dto) {
        ShareholderSearchDto resultDto = new ShareholderSearchDto();
        List list = this.shareholderDao.search(dto);
        resultDto.setData(list);
        if (dto.isPaging()) {
            resultDto.setTotalCount(this.shareholderDao.searchCount(dto));
        }
        return resultDto;
    }

    public List<Shareholder> searchForDataSynchronization(DataSynchronizationSearchDto searchDto) {
        return this.shareholderDao.searchForDataSynchronization(searchDto);
    }

    public void deleteBySid(String sponsorlicenseid) {
        this.shareholderDao.deleteBySid(sponsorlicenseid);
    }

    public void updateCensorStatus(Shareholder shareholder) {
        this.shareholderDaoAop.updateCensorStatus(shareholder);
    }
}

