/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.ars.service.sb.impl;

import cn.hutool.core.util.ObjectUtil;
import com.abcxin.smart.validator.annotation.DataSyncAnnotation;
import com.bcxin.ars.dao.PoliceDao;
import com.bcxin.ars.dao.SecurityCompanyDao;
import com.bcxin.ars.dao.SecurityPersonDao;
import com.bcxin.ars.dao.SecurityScopeDao;
import com.bcxin.ars.dao.UserDao;
import com.bcxin.ars.dao.sb.LegalchangeDao;
import com.bcxin.ars.dao.sb.LegalchangeDaoAop;
import com.bcxin.ars.dao.sys.ApprovalDAO;
import com.bcxin.ars.dto.DataSynchronizationSearchDto;
import com.bcxin.ars.dto.SearchDto;
import com.bcxin.ars.dto.sb.LegalchangeSearchDto;
import com.bcxin.ars.exception.ArsException;
import com.bcxin.ars.model.PageResult;
import com.bcxin.ars.model.Police;
import com.bcxin.ars.model.SecurityCompany;
import com.bcxin.ars.model.User;
import com.bcxin.ars.model.sb.Legalchange;
import com.bcxin.ars.model.sb.Legalchangeworkexperience;
import com.bcxin.ars.model.sys.Approval;
import com.bcxin.ars.service.sb.LegalchangeService;
import com.bcxin.ars.service.sb.LegalchangeworkexperienceService;
import com.bcxin.ars.service.util.ApprovalUtil;
import com.bcxin.ars.service.util.ArsUtil;
import com.bcxin.ars.service.util.IdGeneratorUtil;
import com.bcxin.ars.util.BeanUtils;
import com.bcxin.ars.util.StringUtil;
import com.com.bcxin.ars.com.abcxin.smart.core.web.validate.AjaxPageResponse;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
@DataSyncAnnotation(getClazz=Legalchange.class)
public class LegalchangeServiceImpl
implements LegalchangeService {
    @Autowired
    private LegalchangeDao legalchangeDao;
    @Autowired
    private LegalchangeDaoAop legalchangeDaoAop;
    @Autowired
    private LegalchangeworkexperienceService workexperienceService;
    @Autowired
    private UserDao userDao;
    @Autowired
    private PoliceDao policeDao;
    @Autowired
    private ArsUtil arsUtil;
    @Autowired
    private ApprovalDAO approvalDAO;
    @Autowired
    private ApprovalUtil approvalUtil;
    @Autowired
    private SecurityPersonDao securityPersonDao;
    @Autowired
    private SecurityCompanyDao securityCompanyDao;
    @Autowired
    private SecurityScopeDao securityScopeDao;
    @Autowired
    private IdGeneratorUtil idGeneratorUtil;

    public Legalchange findById(long id) {
        Legalchange result = this.legalchangeDao.findById(Long.valueOf(id));
        if (result != null) {
            result.setApproval(this.approvalDAO.findBybusinessidAndType(Long.valueOf(id), "007"));
            if (StringUtil.isNotEmpty((String)result.getSecurityScopes())) {
                List securityScope = this.securityScopeDao.findByIds(result.getSecurityScopes().split(","));
                result.setSecurityScope(securityScope);
            }
            Police police = this.policeDao.findById(result.getOrgid());
            result.setPolice(police);
        }
        return result;
    }

    public List<Legalchange> findByBatchId(List<Approval> approvalList) {
        return this.legalchangeDao.findByBatchId(approvalList);
    }

    public Map searchForPrintf(long id) {
        return this.legalchangeDao.searchForPrintf(id);
    }

    public void updateBatch(List<Legalchange> list) {
        this.legalchangeDaoAop.updateBatch(list);
    }

    public void saveOrUpdate(Legalchange legalchange) {
        User currentUser = this.arsUtil.getCurrentUser();
        if (legalchange.getOrgid() == null) {
            if (legalchange.getDistrictOrgId() != null) {
                legalchange.setOrgid(Long.valueOf(Long.parseLong(legalchange.getDistrictOrgId())));
            } else if (legalchange.getCityOrgId() != null) {
                legalchange.setOrgid(Long.valueOf(Long.parseLong(legalchange.getCityOrgId())));
            }
        }
        Long userId = currentUser.getId();
        SecurityCompany company = this.securityCompanyDao.findByUserid(userId);
        if (!legalchange.getApprovalstate().equals("001") && company != null) {
            if (StringUtil.isNotEmpty((String)legalchange.getSecurityScopes())) {
                String oldSecurityScope = company.getSecurityScopeType();
                if (StringUtil.isEmpty((String)oldSecurityScope) && (StringUtil.isEmpty((String)company.getInstitutionType()) || company.getInstitutionType().equals("0102") || company.getInstitutionType().equals("0105"))) {
                    throw new ArsException("\u516c\u53f8\u539f\u670d\u52a1\u8303\u56f4\u672a\u7ef4\u62a4\uff0c\u8bf7\u8054\u7cfb\u7cfb\u7edf\u7ba1\u7406\u5458\u7ef4\u62a4\uff01");
                }
                if (ObjectUtil.equal((Object)oldSecurityScope, (Object)legalchange.getSecurityScopes())) {
                    throw new ArsException("\u670d\u52a1\u8303\u56f4\u4e0e\u539f\u672c\u7684\u4e00\u81f4\uff0c\u6ca1\u6709\u53d8\u66f4\u65e0\u9700\u586b\u5199\uff01");
                }
            }
            if (StringUtil.isNotEmpty((String)legalchange.getCompanyname()) && company.getName().equals(legalchange.getCompanyname())) {
                throw new ArsException("\u516c\u53f8\u540d\u79f0\u4e0e\u539f\u672c\u7684\u4e00\u81f4\uff0c\u6ca1\u6709\u53d8\u66f4\u65e0\u9700\u586b\u5199\uff01");
            }
            if (StringUtil.isNotEmpty((String)legalchange.getAddress()) && company.getLocation() != null && company.getLocation().equals(legalchange.getAddress())) {
                throw new ArsException("\u516c\u53f8\u5730\u5740\u4e0e\u539f\u672c\u7684\u4e00\u81f4\uff0c\u6ca1\u6709\u53d8\u66f4\u65e0\u9700\u586b\u5199\uff01");
            }
            if (legalchange.getBgregisteredMoney() != null && company.getRegisteredMoney() != null && legalchange.getBgregisteredMoney().toString().equals(company.getRegisteredMoney().toString())) {
                throw new ArsException("\u6ce8\u518c\u8d44\u672c\u4e0e\u539f\u672c\u7684\u4e00\u81f4\uff0c\u6ca1\u6709\u53d8\u66f4\u65e0\u9700\u586b\u5199\uff01");
            }
            List checkLegalchanges = this.legalchangeDao.findApproveByUserId(userId);
            if (checkLegalchanges != null && checkLegalchanges.size() > 0) {
                String checkMsg = "";
                for (Legalchange checkLegalchange : checkLegalchanges) {
                    if (StringUtil.isNotEmpty((String)legalchange.getNdlegalname()) && StringUtil.isNotEmpty((String)checkLegalchange.getNdlegalname())) {
                        checkMsg = checkMsg + "\u6cd5\u5b9a\u4ee3\u8868\u4eba\u3001";
                    }
                    if (StringUtil.isNotEmpty((String)legalchange.getAddress()) && StringUtil.isNotEmpty((String)checkLegalchange.getAddress())) {
                        checkMsg = checkMsg + "\u529e\u516c\u5730\u5740\u3001";
                    }
                    if (StringUtil.isNotEmpty((String)legalchange.getCompanyname()) && StringUtil.isNotEmpty((String)checkLegalchange.getCompanyname())) {
                        checkMsg = checkMsg + "\u516c\u53f8\u540d\u79f0\u3001";
                    }
                    if (legalchange.getBgregisteredMoney() != null && checkLegalchange.getBgregisteredMoney() != null) {
                        checkMsg = checkMsg + "\u6ce8\u518c\u8d44\u672c\u3001";
                    }
                    if (!StringUtil.isNotEmpty((String)legalchange.getSecurityScopes()) || !StringUtil.isNotEmpty((String)checkLegalchange.getSecurityScopes())) continue;
                    checkMsg = checkMsg + "\u670d\u52a1\u8303\u56f4\u3001";
                }
                if (StringUtil.isNotEmpty((String)checkMsg)) {
                    checkMsg = checkMsg.substring(0, checkMsg.length() - 1) + "\u5df2\u63d0\u4ea4\u6b63\u5728\u5ba1\u6279\uff0c\u8bf7\u4e0d\u8981\u91cd\u590d\u63d0\u4ea4\uff01";
                    throw new ArsException(checkMsg);
                }
            }
        }
        if (null != legalchange.getSecurityScopes() && !legalchange.getSecurityScopes().contains("20") || null == legalchange.getSecurityScopes()) {
            legalchange.setOtherSecScopeType(null);
        }
        legalchange.setActive(Boolean.valueOf(true));
        legalchange.setUpdateTime(new Date());
        legalchange.setUpdateBy(currentUser.getUsername());
        legalchange.setUserid(userId);
        legalchange.setOldaddress(company.getLocation());
        legalchange.setOldcompanyname(company.getName());
        if (company.getRegisteredMoney() != null) {
            legalchange.setOldregisteredMoney(company.getRegisteredMoney().toString());
        }
        legalchange.setOldsecurityScopes(company.getSecurityScopeType());
        if (legalchange.getId() == null) {
            legalchange.setId(Long.valueOf(this.idGeneratorUtil.createID()));
            legalchange.setCreateTime(new Date());
            this.legalchangeDao.save(legalchange);
            if (legalchange.getApprovalstate().equals("002")) {
                this.approvalUtil.saveApproval("007", legalchange.getId(), "activitilegalchangeapprovalProcess");
            }
        } else {
            Legalchange dbLegalchange = this.legalchangeDao.findById(legalchange.getId());
            boolean activity = true;
            if (StringUtil.isNotEmpty((String)dbLegalchange.getApprovalstate()) && dbLegalchange.getApprovalstate().equals("002") && dbLegalchange.getOrgid().toString().equals(legalchange.getOrgid().toString())) {
                activity = false;
                if (!StringUtil.isEmpty((String)legalchange.getCompanyname()) || !StringUtil.isEmpty((String)legalchange.getOldcompanyname())) {
                    Approval approval;
                    String oldCompanyName;
                    String companyName = StringUtil.isEmpty((String)legalchange.getCompanyname()) ? legalchange.getOldcompanyname() : legalchange.getCompanyname();
                    String string = oldCompanyName = StringUtil.isEmpty((String)dbLegalchange.getCompanyname()) ? dbLegalchange.getOldcompanyname() : dbLegalchange.getCompanyname();
                    if (!companyName.equals(oldCompanyName) && (approval = this.approvalDAO.findBybusinessidAndType(legalchange.getId(), "007")) != null) {
                        this.approvalUtil.updateContent(approval, StringUtil.isEmpty((String)legalchange.getCompanyname()) ? legalchange.getOldcompanyname() : legalchange.getCompanyname());
                    }
                }
            }
            BeanUtils.copyPropertiesIgnore((Object)legalchange, (Object)dbLegalchange, (String)"active,createTime,userid", (Boolean)true);
            dbLegalchange.setUpdateBy(currentUser.getUsername());
            dbLegalchange.setUpdateTime(new Date());
            dbLegalchange.setOtherSecScopeType(legalchange.getOtherSecScopeType());
            if (legalchange.getApprovalstate() == null || "".equals(legalchange.getApprovalstate()) || legalchange.getApprovalstate().equals("002")) {
                dbLegalchange.setApprovalstate("002");
                dbLegalchange.setChargecensorstatus("");
                dbLegalchange.setLegalcensorstatus("");
            }
            this.legalchangeDaoAop.update(dbLegalchange);
            if (activity && "002".equals(dbLegalchange.getApprovalstate())) {
                this.approvalUtil.saveApproval("007", dbLegalchange.getId(), "activitilegalchangeapprovalProcess");
            }
        }
    }

    public void saveOrUpdateForIntegrate(Legalchange legalchange, User currentUser) {
        Long userId = currentUser.getId();
        SecurityCompany company = this.securityCompanyDao.findByUserid(userId);
        if (!legalchange.getApprovalstate().equals("001") && company != null) {
            String oldSecurityScope;
            if (StringUtil.isNotEmpty((String)legalchange.getSecurityScopes()) && (oldSecurityScope = company.getSecurityScopeType()).equals(legalchange.getSecurityScopes())) {
                throw new ArsException("\u670d\u52a1\u8303\u56f4\u4e0e\u539f\u672c\u7684\u4e00\u81f4\uff0c\u6ca1\u6709\u53d8\u66f4\u65e0\u9700\u586b\u5199\uff01");
            }
            if (StringUtil.isNotEmpty((String)legalchange.getCompanyname()) && company.getName().equals(legalchange.getCompanyname())) {
                throw new ArsException("\u516c\u53f8\u540d\u79f0\u4e0e\u539f\u672c\u7684\u4e00\u81f4\uff0c\u6ca1\u6709\u53d8\u66f4\u65e0\u9700\u586b\u5199\uff01");
            }
            if (StringUtil.isNotEmpty((String)legalchange.getAddress()) && company.getLocation() != null && company.getLocation().equals(legalchange.getAddress())) {
                throw new ArsException("\u516c\u53f8\u5730\u5740\u4e0e\u539f\u672c\u7684\u4e00\u81f4\uff0c\u6ca1\u6709\u53d8\u66f4\u65e0\u9700\u586b\u5199\uff01");
            }
            if (legalchange.getBgregisteredMoney() != null && company.getRegisteredMoney() != null && legalchange.getBgregisteredMoney().toString().equals(company.getRegisteredMoney().toString())) {
                throw new ArsException("\u6ce8\u518c\u8d44\u672c\u4e0e\u539f\u672c\u7684\u4e00\u81f4\uff0c\u6ca1\u6709\u53d8\u66f4\u65e0\u9700\u586b\u5199\uff01");
            }
            List checkLegalchanges = this.legalchangeDao.findApproveByUserId(userId);
            if (checkLegalchanges != null && checkLegalchanges.size() > 0) {
                String checkMsg = "";
                for (Legalchange checkLegalchange : checkLegalchanges) {
                    if (StringUtil.isNotEmpty((String)legalchange.getNdlegalname()) && StringUtil.isNotEmpty((String)checkLegalchange.getNdlegalname())) {
                        checkMsg = checkMsg + "\u6cd5\u5b9a\u4ee3\u8868\u4eba\u3001";
                    }
                    if (StringUtil.isNotEmpty((String)legalchange.getAddress()) && StringUtil.isNotEmpty((String)checkLegalchange.getAddress())) {
                        checkMsg = checkMsg + "\u529e\u516c\u5730\u5740\u3001";
                    }
                    if (StringUtil.isNotEmpty((String)legalchange.getCompanyname()) && StringUtil.isNotEmpty((String)checkLegalchange.getCompanyname())) {
                        checkMsg = checkMsg + "\u516c\u53f8\u540d\u79f0\u3001";
                    }
                    if (legalchange.getBgregisteredMoney() != null && checkLegalchange.getBgregisteredMoney() != null) {
                        checkMsg = checkMsg + "\u6ce8\u518c\u8d44\u672c\u3001";
                    }
                    if (!StringUtil.isNotEmpty((String)legalchange.getSecurityScopes()) || !StringUtil.isNotEmpty((String)checkLegalchange.getSecurityScopes())) continue;
                    checkMsg = checkMsg + "\u670d\u52a1\u8303\u56f4\u3001";
                }
            }
        }
        if (null != legalchange.getSecurityScopes() && !legalchange.getSecurityScopes().contains("20") || null == legalchange.getSecurityScopes()) {
            legalchange.setOtherSecScopeType(null);
        }
        if (legalchange.getId() == null) {
            legalchange.setId(Long.valueOf(this.idGeneratorUtil.createID()));
            legalchange.setActive(Boolean.valueOf(true));
            legalchange.setCreateTime(new Date());
            legalchange.setUpdateTime(new Date());
            legalchange.setUpdateBy(currentUser.getUsername());
            legalchange.setUserid(userId);
            legalchange.setOldaddress(company.getLocation());
            legalchange.setOldcompanyname(company.getName());
            if (company.getRegisteredMoney() != null) {
                legalchange.setOldregisteredMoney(company.getRegisteredMoney().toString());
            }
            String securityScopes = company.getSecurityScopeType();
            legalchange.setOldsecurityScopes(securityScopes);
            this.legalchangeDao.save(legalchange);
            this.approvalUtil.saveApprovalForIntegrate("007", legalchange.getId(), "activitilegalchangeapprovalProcess", currentUser);
        }
    }

    public void saveOrUpdateForDS(Legalchange legalchange) {
        Legalchange dbLegalchange = this.legalchangeDao.findById(legalchange.getId());
        if (legalchange.getActive() == null) {
            legalchange.setActive(Boolean.valueOf(true));
        }
        if (dbLegalchange != null) {
            if (legalchange.getUpdateTime().getTime() > dbLegalchange.getUpdateTime().getTime()) {
                legalchange.setNdlegalcensorstatus(dbLegalchange.getNdlegalcensorstatus());
                legalchange.setLegalcensorstatus(dbLegalchange.getLegalcensorstatus());
                legalchange.setChargecensorstatus(dbLegalchange.getChargecensorstatus());
                this.legalchangeDaoAop.update(legalchange);
            }
        } else {
            List checkLegalchanges;
            if (legalchange.getApprovalstate().equals("002") && (checkLegalchanges = this.legalchangeDao.findApproveByUserId(legalchange.getUserid())) != null && checkLegalchanges.size() > 0) {
                String checkMsg = "";
                for (Legalchange checkLegalchange : checkLegalchanges) {
                    if (StringUtil.isNotEmpty((String)legalchange.getNdlegalname()) && StringUtil.isNotEmpty((String)checkLegalchange.getNdlegalname())) {
                        checkMsg = checkMsg + "\u6cd5\u5b9a\u4ee3\u8868\u4eba\u3001";
                    }
                    if (StringUtil.isNotEmpty((String)legalchange.getAddress()) && StringUtil.isNotEmpty((String)checkLegalchange.getAddress())) {
                        checkMsg = checkMsg + "\u529e\u516c\u5730\u5740\u3001";
                    }
                    if (StringUtil.isNotEmpty((String)legalchange.getCompanyname()) && StringUtil.isNotEmpty((String)checkLegalchange.getCompanyname())) {
                        checkMsg = checkMsg + "\u516c\u53f8\u540d\u79f0\u3001";
                    }
                    if (legalchange.getBgregisteredMoney() != null && checkLegalchange.getBgregisteredMoney() != null) {
                        checkMsg = checkMsg + "\u6ce8\u518c\u8d44\u672c\u3001";
                    }
                    if (!StringUtil.isNotEmpty((String)legalchange.getSecurityScopes()) || !StringUtil.isNotEmpty((String)checkLegalchange.getSecurityScopes())) continue;
                    checkMsg = checkMsg + "\u670d\u52a1\u8303\u56f4\u3001";
                }
                if (StringUtil.isNotEmpty((String)checkMsg)) {
                    legalchange.setApprovalstate("004");
                    new Thread(() -> {
                        try {
                            Thread.sleep(100000L);
                        }
                        catch (InterruptedException e) {
                            e.printStackTrace();
                        }
                        Approval approval = this.approvalDAO.findBybusinessidAndType(legalchange.getId(), "007");
                        approval.setApprovalstate("004");
                        approval.setApprovalreason("\u91cd\u590d\u63d0\u4ea4");
                        approval.setUpdateflag(Boolean.valueOf(true));
                        approval.setUpdateTime(new Date());
                        this.approvalDAO.update(approval);
                    }).start();
                }
            }
            this.legalchangeDao.save(legalchange);
        }
    }

    public void updatePoliceId(Legalchange legalchange) {
        Approval approval = this.approvalDAO.getById(legalchange.getApprovalId());
        Legalchange dbLegalchange = this.legalchangeDao.findById(legalchange.getId());
        dbLegalchange.setPoliceid(legalchange.getPoliceid());
        dbLegalchange.setUpdateTime(new Date());
        this.legalchangeDaoAop.update(dbLegalchange);
        approval.setPoliceid(legalchange.getPoliceid());
        approval.setRoleid(null);
        approval.setUpdateTime(new Date());
        this.approvalDAO.update(approval);
    }

    public LegalchangeSearchDto search(LegalchangeSearchDto dto) {
        LegalchangeSearchDto resultDto = new LegalchangeSearchDto();
        User currentUser = this.arsUtil.getCurrentUser();
        Police police = this.policeDao.findById(currentUser.getOrgid());
        if (police != null) {
            String areacode = police.getAreacode();
            if (areacode.endsWith("0000")) {
                dto.setDistrict(areacode.substring(0, 2) + "____");
            } else if (areacode.endsWith("00")) {
                dto.setDistrict(areacode.substring(0, 4) + "__");
            } else {
                dto.setDistrict(areacode);
            }
        }
        List list = this.legalchangeDao.search(dto);
        resultDto.setData(list);
        resultDto.setTotalCount(this.legalchangeDao.searchCount(dto));
        return resultDto;
    }

    public LegalchangeSearchDto searchCompanyCertificate(LegalchangeSearchDto dto) {
        this.arsUtil.setPoliceSearch((SearchDto)dto);
        LegalchangeSearchDto resultDto = new LegalchangeSearchDto();
        List list = this.legalchangeDao.searchCompanyCertificate(dto);
        resultDto.setData(list);
        resultDto.setTotalCount(this.legalchangeDao.searchCompanyCertificateCount(dto));
        return resultDto;
    }

    public void delete(Legalchange legalchange) {
        User currentUser = this.arsUtil.getCurrentUser();
        legalchange.setUpdateBy(currentUser.getUsername());
        legalchange.setUpdateTime(new Date());
        this.legalchangeDaoAop.delete(legalchange);
    }

    public Legalchange findByUser(Long userid) {
        return this.legalchangeDao.findByUser(userid);
    }

    public void updateAndSaveWorkExperience(Legalchange legalchange, Date[] startdate, Date[] enddate, String[] workCompanyname, String[] post) {
        this.saveOrUpdate(legalchange);
        User currentUser = this.arsUtil.getCurrentUser();
        this.workexperienceService.deleteByLegalchangeId(legalchange.getId());
        Legalchangeworkexperience legalchangeworkexperience = null;
        if (startdate != null) {
            for (int i = 0; i < startdate.length; ++i) {
                legalchangeworkexperience = new Legalchangeworkexperience();
                legalchangeworkexperience.setActive(Boolean.valueOf(true));
                if (workCompanyname.length > i) {
                    legalchangeworkexperience.setCompanyname(workCompanyname[i]);
                }
                legalchangeworkexperience.setCreateTime(new Date());
                if (enddate.length > i) {
                    legalchangeworkexperience.setEnddate(enddate[i]);
                }
                legalchangeworkexperience.setLegalchangeId(legalchange.getId());
                if (post.length > i) {
                    legalchangeworkexperience.setPost(post[i]);
                }
                legalchangeworkexperience.setStartdate(startdate[i]);
                legalchangeworkexperience.setUpdateBy(currentUser.getUsername());
                legalchangeworkexperience.setUpdateTime(new Date());
                this.workexperienceService.saveOrUpdate(legalchangeworkexperience);
            }
        }
    }

    public List<Legalchange> searchForDataSynchronization(DataSynchronizationSearchDto searchDto) {
        return this.legalchangeDao.searchForDataSynchronization(searchDto);
    }

    public List<Legalchange> findAll() {
        return this.legalchangeDao.findAll();
    }

    public PageResult searchLegalchangeList_table(Map<Object, Object> p) {
        User currentUser = this.arsUtil.getCurrentUser();
        Police police = currentUser.getPolice();
        String areacode = "";
        if (p.get("areaCode") != null) {
            areacode = p.get("areaCode").toString();
        } else if (police != null) {
            areacode = police.getAreacode();
        }
        if (StringUtil.isNotEmpty((String)areacode)) {
            if (areacode.endsWith("0000")) {
                p.put("district", areacode.substring(0, 2) + "____");
            } else if (areacode.endsWith("00")) {
                p.put("district", areacode.substring(0, 4) + "__");
            } else {
                p.put("district", areacode);
            }
        }
        if (police != null && police.getOrgtype().equals("4")) {
            p.put("orgid", police.getId());
        }
        if (p.get("checkType") != null && currentUser != null) {
            p.put("userid", currentUser.getId());
        }
        return new PageResult(Integer.valueOf(this.legalchangeDao.countLegalchangeList(p)), (Object)this.legalchangeDao.searchLegalchangeList(p));
    }

    public void saveOrUpdateForApproval(Legalchange legalchange) {
        legalchange.setUpdateTime(new Date());
        this.legalchangeDaoAop.update(legalchange);
    }

    public void updateCensorStatus(Legalchange legalchange) {
        this.legalchangeDaoAop.update(legalchange);
    }

    public List<Legalchange> findApprovePassByCompanyId(Long companyId) {
        return this.legalchangeDao.findApprovePassByCompanyId(companyId);
    }

    public void saveOrUpdateForApprovalImport(Legalchange legalchange) {
        this.legalchangeDaoAop.update(legalchange);
    }

    public void searchForPage(LegalchangeSearchDto dto, AjaxPageResponse<Legalchange> page) {
        this.arsUtil.setPoliceSearch((SearchDto)dto);
        this.legalchangeDao.searchForPage(dto, page);
    }
}

