/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.ars.service.sb.impl;

import com.bcxin.ars.dao.sb.ChargeworkDao;
import com.bcxin.ars.dto.sb.ChargeworkSearchDto;
import com.bcxin.ars.model.User;
import com.bcxin.ars.model.sb.Chargework;
import com.bcxin.ars.service.sb.ChargeworkService;
import com.bcxin.ars.service.util.ArsUtil;
import java.util.Date;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class ChargeworkServiceImpl
implements ChargeworkService {
    @Autowired
    private ChargeworkDao chargeworkDao;
    @Autowired
    private ArsUtil arsUtil;

    public Chargework findById(long id) {
        return this.chargeworkDao.findById(id);
    }

    public void saveOrUpdate(Chargework chargework) {
        User currentUser = this.arsUtil.getCurrentUser();
        if (chargework.getId() == null) {
            chargework.setActive(Boolean.valueOf(true));
            chargework.setCreateTime(new Date());
            chargework.setUpdateTime(new Date());
            chargework.setUpdateBy(currentUser.getUsername());
            this.chargeworkDao.save(chargework);
        } else {
            Chargework dbChargework = this.chargeworkDao.findById(chargework.getId().longValue());
            dbChargework.setUpdateTime(new Date());
            dbChargework.setUpdateTime(new Date());
            dbChargework.setUpdateBy(currentUser.getUsername());
            dbChargework.setCompanyname(chargework.getCompanyname());
            dbChargework.setEnddate(chargework.getEnddate());
            dbChargework.setPost(chargework.getPost());
            dbChargework.setStartdate(chargework.getStartdate());
            this.chargeworkDao.update(dbChargework);
        }
    }

    public ChargeworkSearchDto search(ChargeworkSearchDto dto) {
        ChargeworkSearchDto resultDto = new ChargeworkSearchDto();
        List list = this.chargeworkDao.search(dto);
        resultDto.setData(list);
        resultDto.setTotalCount(this.chargeworkDao.searchCount(dto));
        return resultDto;
    }
}

