/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.ars.service.impl;

import com.abcxin.smart.validator.annotation.DataSyncAnnotation;
import com.bcxin.ars.dao.SbRewardDao;
import com.bcxin.ars.dao.SecurityPersonDao;
import com.bcxin.ars.dto.DataSynchronizationSearchDto;
import com.bcxin.ars.dto.sb.SbRewardSearchDto;
import com.bcxin.ars.model.SbReward;
import com.bcxin.ars.model.User;
import com.bcxin.ars.service.SbRewardService;
import com.bcxin.ars.service.util.ArsUtil;
import com.bcxin.ars.util.BuildWebServiceEntity;
import com.bcxin.ars.webservice.Babzjl;
import com.bcxin.ars.webservice.ClientUtil;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.StringUtils;

@Service
@Transactional
@DataSyncAnnotation(getClazz=SbReward.class)
public class SbRewardServiceImpl
implements SbRewardService {
    private static Logger logger = LoggerFactory.getLogger(SbRewardServiceImpl.class);
    @Autowired
    private SbRewardDao sbRewardDao;
    @Autowired
    private SecurityPersonDao securityPersonDao;
    @Autowired
    private ArsUtil arsUtil;
    @Autowired
    private ClientUtil clientUtil;

    public void saveOrUpdate(SbReward sbReward) {
        User user = this.arsUtil.getCurrentUser();
        SbReward dbSbReward = this.sbRewardDao.findById(sbReward.getId());
        if (dbSbReward != null) {
            if (!StringUtils.isEmpty((Object)sbReward.getDepartname())) {
                dbSbReward.setDepartname(sbReward.getDepartname());
            }
            if (!StringUtils.isEmpty((Object)sbReward.getEmployeeid())) {
                dbSbReward.setEmployeeid(sbReward.getEmployeeid());
            }
            if (!StringUtils.isEmpty((Object)sbReward.getIdNumber())) {
                dbSbReward.setIdNumber(sbReward.getIdNumber());
            }
            if (!StringUtils.isEmpty((Object)sbReward.getName())) {
                dbSbReward.setName(sbReward.getName());
            }
            if (!StringUtils.isEmpty((Object)sbReward.getRemarks())) {
                dbSbReward.setRemarks(sbReward.getRemarks());
            }
            if (!StringUtils.isEmpty((Object)sbReward.getRewardContext())) {
                dbSbReward.setRewardContext(sbReward.getRewardContext());
            }
            if (!StringUtils.isEmpty((Object)sbReward.getRewardDate())) {
                dbSbReward.setRewardDate(sbReward.getRewardDate());
            }
            if (!StringUtils.isEmpty((Object)sbReward.getRewardReason())) {
                dbSbReward.setRewardReason(sbReward.getRewardReason());
            }
            dbSbReward.setIsByPolice(sbReward.getIsByPolice());
            dbSbReward.setRewardCompany(sbReward.getRewardCompany());
            dbSbReward.setUpdateTime(new Date());
            dbSbReward.setUpdateBy(user.getRealname());
            this.sbRewardDao.update(dbSbReward);
        } else {
            if (user.getPlatform() == 2) {
                sbReward.setUserid(user.getId());
            }
            sbReward.setCreateTime(new Date());
            sbReward.setUpdateTime(sbReward.getCreateTime());
            sbReward.setActive(Boolean.valueOf(true));
            sbReward.setUpdateBy(user.getUsername());
            this.sbRewardDao.save(sbReward);
        }
    }

    public void delete(SbReward sbReward) {
        sbReward.setUpdateTime(new Date());
        this.sbRewardDao.delete(sbReward);
    }

    public SbReward findById(long id) {
        return this.sbRewardDao.findById(Long.valueOf(id));
    }

    public SbRewardSearchDto search(SbRewardSearchDto dto) {
        SbRewardSearchDto resultDto = new SbRewardSearchDto();
        List list = this.sbRewardDao.search(dto);
        resultDto.setData(list);
        resultDto.setTotalCount(Long.valueOf(this.sbRewardDao.count(dto)));
        return resultDto;
    }

    public List<SbReward> searchForDataSynchronization(DataSynchronizationSearchDto searchDto) {
        return this.sbRewardDao.searchForDataSynchronization(searchDto);
    }

    public void saveOrUpdateForDS(SbReward sbReward) {
        if (sbReward.getActive() == null) {
            sbReward.setActive(Boolean.valueOf(true));
        }
        if (!sbReward.getActive().booleanValue()) {
            this.sbRewardDao.delete(sbReward);
        } else {
            SbReward dbSbReward = this.sbRewardDao.findById(sbReward.getId());
            if (dbSbReward == null) {
                this.sbRewardDao.saveForDS(sbReward);
                new Thread(() -> {
                    try {
                        String[] key = new String[]{"bjldxlb"};
                        String[] value = new String[]{"4"};
                        sbReward.setIdNumber("12222111111112222");
                        sbReward.setRewardDate(sbReward.getRewardDate().replaceAll("-", ""));
                        String[] srccol = new String[]{"idNumber", "rewardcontext", "rewardDate", "rewardcompany"};
                        String[] desccol = new String[]{"bjldxbm", "jlsj", "jlrq", "jldwmc"};
                        Object desc = BuildWebServiceEntity.buildWebServiceEntity((String[])srccol, (String[])desccol, (Object)sbReward, (Object)new Babzjl(), (String[])key, (String[])value);
                        Babzjl babzjlxx = (Babzjl)desc;
                        this.clientUtil.send("xxba_babzjlxx", (Object)babzjlxx);
                    }
                    catch (Exception e) {
                        logger.error(e.getMessage(), (Throwable)e);
                    }
                }).start();
            } else if (sbReward.getUpdateTime().getTime() > dbSbReward.getUpdateTime().getTime()) {
                this.sbRewardDao.update(sbReward);
            }
        }
    }

    public void saveOrUpdateForSAAS(List<SbReward> sbRewardList) {
        List dbSbRewardList;
        User user = this.arsUtil.getCurrentUser();
        if (null != sbRewardList && null != sbRewardList.get(0) && null != (dbSbRewardList = this.sbRewardDao.findByAwardId(sbRewardList.get(0).getAwardId())) && dbSbRewardList.size() > 0) {
            this.sbRewardDao.deleteByawardId(sbRewardList.get(0).getAwardId());
        }
        for (SbReward sbReward : sbRewardList) {
            if (user.getPlatform() == 2) {
                sbReward.setUserid(user.getId());
            }
            sbReward.setCreateTime(new Date());
            sbReward.setUpdateTime(sbReward.getCreateTime());
            sbReward.setActive(Boolean.valueOf(true));
            sbReward.setUpdateBy(user.getUsername());
            this.sbRewardDao.save(sbReward);
        }
    }

    public List<SbReward> findByAwardId(Long awardId) {
        return this.sbRewardDao.findByAwardId(awardId);
    }

    public void deleteByawardId(Long awardId) {
        this.sbRewardDao.deleteByawardId(awardId);
    }
}

