/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.ars.service.impl;

import com.bcxin.ars.dao.ProjectChangeDao;
import com.bcxin.ars.dto.AjaxResult;
import com.bcxin.ars.model.ProjectChange;
import com.bcxin.ars.model.User;
import com.bcxin.ars.service.ProjectChangeService;
import com.bcxin.ars.util.BeanUtils;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ProjectChangeServiceImpl
implements ProjectChangeService {
    private Logger logger = LoggerFactory.getLogger(ProjectChangeService.class);
    @Autowired
    private ProjectChangeDao projectChangeDao;

    public List<ProjectChange> getProjectChangeList() {
        List lis = this.projectChangeDao.getProjectChangeList();
        return lis;
    }

    public ProjectChange findById(Long id) {
        return this.projectChangeDao.findById(id);
    }

    public AjaxResult saveOrUpdate(ProjectChange projectChange, User user) {
        AjaxResult ajaxResult = new AjaxResult();
        if (projectChange.getId() != null) {
            ProjectChange dbProjectChange = this.projectChangeDao.findById(projectChange.getId());
            if (dbProjectChange != null) {
                dbProjectChange.setUpdateTime(new Date());
                dbProjectChange.setUpdateBy(user.getUsername());
                BeanUtils.copyPropertiesIgnore((Object)projectChange, (Object)dbProjectChange, (Boolean)true);
                this.projectChangeDao.update(dbProjectChange);
            } else {
                projectChange.setCreateTime(new Date());
                projectChange.setUpdateTime(new Date());
                projectChange.setUserid(user.getId());
                projectChange.setUpdateBy(user.getUsername());
                this.projectChangeDao.save(projectChange);
            }
        }
        return ajaxResult;
    }

    public List<ProjectChange> findByCertificateIdAndType(String certificateId, String type) {
        return this.projectChangeDao.findByCertificateIdAndType(certificateId, type);
    }
}

