/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.ars.service.impl;

import com.abcxin.smart.validator.annotation.DataSyncAnnotation;
import com.bcxin.ars.dao.CyServerhtDao;
import com.bcxin.ars.dao.SecurityPersonDao;
import com.bcxin.ars.dto.AjaxResult;
import com.bcxin.ars.dto.DataSynchronizationSearchDto;
import com.bcxin.ars.dto.sb.CyServerhtSearchDto;
import com.bcxin.ars.model.CyServerht;
import com.bcxin.ars.model.User;
import com.bcxin.ars.service.CyServerhtService;
import com.bcxin.ars.service.util.ArsUtil;
import com.bcxin.ars.service.util.IdGeneratorUtil;
import java.util.Date;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.StringUtils;

@Service
@Transactional
@DataSyncAnnotation(getClazz=CyServerht.class)
public class CyServerhtServiceImpl
implements CyServerhtService {
    @Autowired
    private CyServerhtDao cyServerhtDao;
    @Autowired
    private SecurityPersonDao securityPersonDao;
    @Autowired
    private ArsUtil arsUtil;
    @Autowired
    private IdGeneratorUtil idGeneratorUtil;

    public void saveOrUpdate(CyServerht cyServerht) {
        User user = this.arsUtil.getCurrentUser();
        CyServerht dbCyServerht = this.cyServerhtDao.findById(cyServerht.getId());
        if (dbCyServerht != null) {
            if (!cyServerht.getHtstate().equals("2")) {
                if (!StringUtils.isEmpty((Object)cyServerht.getHtEndDate())) {
                    dbCyServerht.setHtEndDate(cyServerht.getHtEndDate());
                }
                if (!StringUtils.isEmpty((Object)cyServerht.getHtLife())) {
                    dbCyServerht.setHtLife(cyServerht.getHtLife());
                }
                if (!StringUtils.isEmpty((Object)cyServerht.getHtName())) {
                    dbCyServerht.setHtName(cyServerht.getHtName());
                }
                if (!StringUtils.isEmpty((Object)cyServerht.getHtNum())) {
                    dbCyServerht.setHtNum(cyServerht.getHtNum());
                }
                if (!StringUtils.isEmpty((Object)cyServerht.getHtStartDate())) {
                    dbCyServerht.setHtStartDate(cyServerht.getHtStartDate());
                }
                if (!StringUtils.isEmpty((Object)cyServerht.getServerObj())) {
                    dbCyServerht.setServerObj(cyServerht.getServerObj());
                }
                if (!StringUtils.isEmpty((Object)cyServerht.getHtstate())) {
                    dbCyServerht.setHtstate(cyServerht.getHtstate());
                }
                if (!StringUtils.isEmpty((Object)cyServerht.getHtqdStartDate())) {
                    dbCyServerht.setHtqdStartDate(cyServerht.getHtqdStartDate());
                }
                if (!StringUtils.isEmpty((Object)cyServerht.getSecurityNum())) {
                    dbCyServerht.setSecurityNum(cyServerht.getSecurityNum());
                }
            } else {
                dbCyServerht.setHtstate("5");
                cyServerht.setUserid(user.getId());
                cyServerht.setCreateTime(new Date());
                cyServerht.setUpdateTime(cyServerht.getCreateTime());
                cyServerht.setActive(Boolean.valueOf(true));
                cyServerht.setUpdateBy(user.getUsername());
                cyServerht.setHtstate("2");
                this.cyServerhtDao.save(cyServerht);
            }
            dbCyServerht.setUpdateTime(new Date());
            dbCyServerht.setUpdateBy(user.getRealname());
            this.cyServerhtDao.update(dbCyServerht);
        } else {
            cyServerht.setUserid(user.getId());
            cyServerht.setCreateTime(new Date());
            cyServerht.setUpdateTime(cyServerht.getCreateTime());
            cyServerht.setActive(Boolean.valueOf(true));
            cyServerht.setUpdateBy(user.getUsername());
            cyServerht.setHtstate("1");
            if (cyServerht.getId() == null) {
                cyServerht.setId(Long.valueOf(this.idGeneratorUtil.createID()));
            }
            this.cyServerhtDao.saveById(cyServerht);
        }
    }

    public void delete(CyServerht cyServerht) {
        cyServerht.setUpdateTime(new Date());
        this.cyServerhtDao.delete(cyServerht);
    }

    public CyServerht findById(long id) {
        return this.cyServerhtDao.findById(Long.valueOf(id));
    }

    public CyServerhtSearchDto search(CyServerhtSearchDto dto) {
        List list = this.cyServerhtDao.search(dto);
        dto.setData(list);
        dto.setTotalCount(Long.valueOf(this.cyServerhtDao.count(dto)));
        return dto;
    }

    public AjaxResult relieveHt(Long htId) {
        AjaxResult result = new AjaxResult();
        User user = this.arsUtil.getCurrentUser();
        if (user == null || user.getPlatform() != 2) {
            result.setSuccessful(false);
        } else {
            CyServerht cyServerht = this.cyServerhtDao.findById(htId);
            cyServerht.setHtstate("3");
            cyServerht.setUpdateBy(user.getUsername());
            cyServerht.setUpdateTime(new Date());
            this.cyServerhtDao.update(cyServerht);
            result.setSuccessful(true);
        }
        return result;
    }

    public List<CyServerht> searchForDataSynchronization(DataSynchronizationSearchDto searchDto) {
        return this.cyServerhtDao.searchForDataSynchronization(searchDto);
    }

    public void saveOrUpdateForDS(CyServerht cyServerht) {
        if (cyServerht.getActive() == null) {
            cyServerht.setActive(Boolean.valueOf(true));
        }
        if (!cyServerht.getActive().booleanValue()) {
            this.cyServerhtDao.delete(cyServerht);
        } else {
            CyServerht dbCyServerht = this.cyServerhtDao.findById(cyServerht.getId());
            if (dbCyServerht == null) {
                this.cyServerhtDao.saveForDS(cyServerht);
            } else if (cyServerht.getUpdateTime().getTime() > dbCyServerht.getUpdateTime().getTime()) {
                this.cyServerhtDao.update(cyServerht);
            }
        }
    }
}

