/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.ars.service.certificate.impl;

import com.abcxin.smart.validator.annotation.DataSyncAnnotation;
import com.abcxin.smart.validator.annotation.DataSyncOutAnnotation;
import com.bcxin.ars.dao.ConfigDao;
import com.bcxin.ars.dao.PoliceDao;
import com.bcxin.ars.dao.ProjectChangeDao;
import com.bcxin.ars.dao.certificate.TrainCertificateDao;
import com.bcxin.ars.dao.certificate.TrainCertificateSnapshotDao;
import com.bcxin.ars.dao.sb.LegalchangeDao;
import com.bcxin.ars.dao.sb.LegalchangeDaoAop;
import com.bcxin.ars.dao.sb.TraincompanyapplyDao;
import com.bcxin.ars.dao.sb.TraincompanyapplyDaoAop;
import com.bcxin.ars.dao.sys.ApprovalDAO;
import com.bcxin.ars.dao.sys.SyscodeDAO;
import com.bcxin.ars.dto.DataSynchronizationSearchDto;
import com.bcxin.ars.dto.SearchDto;
import com.bcxin.ars.dto.certificate.TrainCertificateSearchDto;
import com.bcxin.ars.dto.sys.PdfFormDto;
import com.bcxin.ars.enums.ImportType;
import com.bcxin.ars.exception.ArsException;
import com.bcxin.ars.model.Config;
import com.bcxin.ars.model.Police;
import com.bcxin.ars.model.ProjectChange;
import com.bcxin.ars.model.SecurityCompany;
import com.bcxin.ars.model.User;
import com.bcxin.ars.model.certificate.TrainCertificate;
import com.bcxin.ars.model.certificate.TrainCertificateSnapshot;
import com.bcxin.ars.model.sb.Legalchange;
import com.bcxin.ars.model.sb.Traincompanyapply;
import com.bcxin.ars.model.sys.Approval;
import com.bcxin.ars.model.sys.Syscode;
import com.bcxin.ars.service.SecurityCompanyService;
import com.bcxin.ars.service.certificate.TrainCertificateService;
import com.bcxin.ars.service.sb.CreatePDFService;
import com.bcxin.ars.service.util.ArsUtil;
import com.bcxin.ars.service.util.ConfigUtils;
import com.bcxin.ars.service.util.IdWorker;
import com.bcxin.ars.util.Base64Img;
import com.bcxin.ars.util.BeanUtils;
import com.bcxin.ars.util.Constants;
import com.bcxin.ars.util.DateUtil;
import com.bcxin.ars.util.QRCodeUtil;
import com.bcxin.ars.util.StringUtil;
import com.com.bcxin.ars.com.abcxin.smart.core.web.validate.AjaxPageResponse;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.StringUtils;

@Service
@Transactional
@DataSyncAnnotation(getClazz=TrainCertificate.class, getImportType=ImportType.BATCH, getMethodName="importBatch")
@DataSyncOutAnnotation(getClazz=TrainCertificate.class, getImportType=ImportType.BATCH)
public class TrainCertificateServiceImpl
implements TrainCertificateService {
    private Logger logger = LoggerFactory.getLogger(TrainCertificateServiceImpl.class);
    @Autowired
    private TrainCertificateDao trainCertificateDao;
    @Autowired
    private TraincompanyapplyDao traincompanyapplyDao;
    @Autowired
    private TraincompanyapplyDaoAop traincompanyapplyDaoAop;
    @Autowired
    private ApprovalDAO approvalDAO;
    @Autowired
    private ArsUtil arsUtil;
    @Autowired
    private ConfigDao configDao;
    @Autowired
    private ConfigUtils configUtils;
    @Autowired
    private PoliceDao policeDao;
    @Autowired
    private SyscodeDAO syscodeDAO;
    @Value(value="${temp-folder}")
    private String tempFolder;
    @Autowired
    private ProjectChangeDao projectChangeDao;
    @Autowired
    private CreatePDFService createPDFService;
    @Autowired
    private LegalchangeDao legalchangeDao;
    @Autowired
    private LegalchangeDaoAop legalchangeDaoAop;
    @Autowired
    private SecurityCompanyService securityCompanyService;
    @Autowired
    private IdWorker idWorker;
    @Autowired
    private TrainCertificateSnapshotDao trainCertificateSnapshotDao;

    public TrainCertificateSearchDto search(TrainCertificateSearchDto dto) {
        dto.setApplytype(Constants.TYPE_APPLY);
        TrainCertificateSearchDto resultDto = new TrainCertificateSearchDto();
        List list = this.trainCertificateDao.searchV1(dto);
        resultDto.setData(list);
        resultDto.setTotalCount(Long.valueOf(this.trainCertificateDao.count(dto)));
        return resultDto;
    }

    public void saveOrUpdate(TrainCertificate trainCertificate) {
        User user = this.arsUtil.getCurrentUser();
        Traincompanyapply traincompanyapply = null;
        if (trainCertificate.getTraincompanyapplyid() != null) {
            traincompanyapply = this.traincompanyapplyDao.findById(trainCertificate.getTraincompanyapplyid());
            trainCertificate.setOrgId(traincompanyapply.getOrgid());
            trainCertificate.setAreaCode(traincompanyapply.getDistrict());
        }
        Syscode syscode = null;
        TrainCertificate dbTrainCertificate = this.trainCertificateDao.findById(trainCertificate.getId());
        if (dbTrainCertificate != null) {
            BeanUtils.copyPropertiesIgnore((Object)trainCertificate, (Object)dbTrainCertificate, (Boolean)true);
            dbTrainCertificate.setUpdateTime(new Date());
            dbTrainCertificate.setUpdateBy(user.getRealname());
            dbTrainCertificate.setPrinttype(Constants.PRINT_TYPE_ONLINE_YES);
            dbTrainCertificate.setApplytype(Constants.TYPE_APPLY);
            dbTrainCertificate.setUpdateflag(Boolean.valueOf(true));
            if (StringUtil.isEmpty((String)dbTrainCertificate.getAreaCode())) {
                dbTrainCertificate.setOrgId(user.getOrgid());
                dbTrainCertificate.setAreaCode(user.getPolice().getAreaCode());
            }
            this.trainCertificateDao.update(dbTrainCertificate);
        } else {
            trainCertificate.setCreateTime(new Date());
            trainCertificate.setUpdateTime(trainCertificate.getCreateTime());
            trainCertificate.setActive(Boolean.valueOf(true));
            trainCertificate.setUpdateBy(user.getUsername());
            trainCertificate.setSlr(user.getRealname());
            trainCertificate.setSlrsj(user.getPhone());
            trainCertificate.setSlr(user.getRealname());
            trainCertificate.setSlrsj(user.getPhone());
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy");
            Date date = new Date();
            syscode = this.syscodeDAO.selectByPrimaryKey("PXXKZH", user.getCityAreaCode());
            String year = "";
            if (syscode != null && syscode.getCodename() != null) {
                year = syscode.getCodename() + simpleDateFormat.format(date);
            }
            TrainCertificateSearchDto searchdto = new TrainCertificateSearchDto();
            searchdto.setXkzh(year);
            String maxXkzh_year = this.trainCertificateDao.searchMaxXkzhCount(searchdto);
            maxXkzh_year = StringUtils.isEmpty((Object)maxXkzh_year) ? year + "0001" : maxXkzh_year.substring(0, maxXkzh_year.length() - 8) + String.valueOf(Long.valueOf(maxXkzh_year.substring(maxXkzh_year.length() - 8)) + 1L);
            trainCertificate.setXkzh(maxXkzh_year);
            trainCertificate.setPrinttype(Constants.PRINT_TYPE_ONLINE_YES);
            trainCertificate.setHasOld(Constants.PRINT_TYPE_OLD_NO);
            trainCertificate.setUpdateflag(Boolean.valueOf(true));
            trainCertificate.setApplytype(Constants.TYPE_APPLY);
            if (StringUtil.isEmpty((String)trainCertificate.getAreaCode())) {
                trainCertificate.setOrgId(user.getOrgid());
                trainCertificate.setAreaCode(user.getPolice().getAreaCode());
            }
            this.trainCertificateDao.save(trainCertificate);
            PdfFormDto pdfFormDto = new PdfFormDto();
            pdfFormDto.setBusinesstype("002");
            pdfFormDto.setBusinessid(trainCertificate.getId());
            try {
                this.createPDFService.createPDF(pdfFormDto);
            }
            catch (Exception e) {
                new ArsException("\u751f\u6210\u8bc1\u4e66pdf\u5931\u8d25");
            }
        }
        if (traincompanyapply != null) {
            traincompanyapply.setCardState("2");
            traincompanyapply.setUpdateTime(new Date());
            traincompanyapply.setUpdateBy(user.getUsername());
            this.traincompanyapplyDaoAop.update(traincompanyapply);
            Config configVersion = this.configDao.findByKey("APPROVAL_VERSION_SWITCH");
            if (configVersion != null && "1".equals(configVersion.getValue())) {
                User newUser = new User();
                newUser.setInit(Boolean.valueOf(false));
                newUser.setRealname(traincompanyapply.getTraincompanyname());
                newUser.setPhone(traincompanyapply.getTrainphone());
                newUser.setPlatform(Integer.valueOf(2));
                SecurityCompany newCompany = new SecurityCompany();
                newCompany.setName(traincompanyapply.getTraincompanyname());
                newCompany.setLegalPerson(traincompanyapply.getTrainlegalname());
                newCompany.setLegalPersonNo(traincompanyapply.getTraincreditcode());
                newCompany.setLocation(traincompanyapply.getTrainaddress());
                newCompany.setPublicSecurityLicenseNumber(trainCertificate.getXkzh().replace(syscode.getCodename(), ""));
                Approval approval = this.approvalDAO.findBybusinessidAndType(traincompanyapply.getId(), "002");
                if (null != approval) {
                    newCompany.setAreaCode(approval.getAreaCode());
                }
                newCompany.setUser(newUser);
                newCompany.setInstitutionType("0103");
                newCompany.setUpdateflag(Boolean.valueOf(true));
                newCompany.setOrgId(traincompanyapply.getOrgid().toString());
                Police police = this.policeDao.findById(traincompanyapply.getOrgid());
                newCompany.setOrgName(this.policeDao.findOrgNameByOrgIds(police.getPath().split("/")));
                newCompany.setGiveLicenseDate(trainCertificate.getFzrq());
                newCompany.setGiveLicenseName(trainCertificate.getFzjgmc());
                this.securityCompanyService.updateCompany(newCompany);
            }
        }
    }

    public void saveOrUpdateForLegalchange(TrainCertificate trainCertificate) {
        Legalchange legalchange = this.legalchangeDao.findById(trainCertificate.getLegalchangeId());
        SecurityCompany securityCompany = this.securityCompanyService.findById(legalchange.getCompanyid());
        User user = this.arsUtil.getCurrentUser();
        trainCertificate.setCreateTime(new Date());
        trainCertificate.setUpdateTime(trainCertificate.getCreateTime());
        trainCertificate.setActive(Boolean.valueOf(true));
        trainCertificate.setUpdateBy(user.getUsername());
        trainCertificate.setSlr(user.getRealname());
        trainCertificate.setSlrsj(user.getPhone());
        trainCertificate.setSlr(user.getRealname());
        trainCertificate.setSlrsj(user.getPhone());
        Syscode syscode = this.syscodeDAO.selectByPrimaryKey("PXXKZH", user.getCityAreaCode());
        if (syscode != null && syscode.getCodename() != null) {
            trainCertificate.setXkzh(syscode.getCodename() + securityCompany.getPublicSecurityLicenseNumber());
        }
        trainCertificate.setCompanyid(securityCompany.getId());
        trainCertificate.setPrinttype(Constants.PRINT_TYPE_ONLINE_YES);
        trainCertificate.setApplytype(Constants.TYPE_CHANGER);
        trainCertificate.setUpdateflag(Boolean.valueOf(true));
        trainCertificate.setAreaCode(legalchange.getDistrict());
        trainCertificate.setOrgId(legalchange.getOrgid());
        this.trainCertificateDao.save(trainCertificate);
        this.projectChangeDao.deleteByCidAndType(trainCertificate.getId().toString(), "002");
        if (StringUtil.isNotEmpty((String)legalchange.getSecurityScopes())) {
            this.insertProject(Constants.CHANGE_FWFW, legalchange.getSecurityScopes(), trainCertificate.getId());
        }
        if (StringUtil.isNotEmpty((String)legalchange.getCompanyname())) {
            this.insertProject(Constants.CHANGE_NAME, legalchange.getCompanyname(), trainCertificate.getId());
        }
        if (StringUtil.isNotEmpty((String)legalchange.getAddress())) {
            this.insertProject(Constants.CHANGE_ADDRESS, legalchange.getAddress(), trainCertificate.getId());
        }
        if (StringUtil.isNotEmpty((String)legalchange.getLegalname())) {
            this.insertProject(Constants.CHANGE_LEGALNAME, legalchange.getLegalname(), trainCertificate.getId());
        }
        if (legalchange.getBgregisteredMoney() != null) {
            this.insertProject(Constants.CHANGE_ZJ, legalchange.getBgregisteredMoney().toString(), trainCertificate.getId());
        }
        PdfFormDto pdfFormDto = new PdfFormDto();
        pdfFormDto.setBusinesstype("002");
        pdfFormDto.setBusinessid(trainCertificate.getId());
        try {
            this.createPDFService.createPDF(pdfFormDto);
        }
        catch (Exception e) {
            new ArsException("\u751f\u6210\u8bc1\u4e66pdf\u5931\u8d25");
        }
        legalchange.setCardState(Constants.CARDSTATE_YES);
        this.legalchangeDaoAop.update(legalchange);
        Approval approval = this.approvalDAO.findBybusinessidAndType(legalchange.getId(), "007");
        if (approval != null) {
            approval.setNextPerson(null);
            this.approvalDAO.update(approval);
        }
    }

    public void insertProject(String projectname, String projectcontent, Long trainCertificateId) {
        User currentUser = this.arsUtil.getCurrentUser();
        ProjectChange projectChange = new ProjectChange();
        projectChange.setActive(Boolean.valueOf(true));
        projectChange.setCreateTime(new Date());
        projectChange.setUpdateTime(new Date());
        projectChange.setUpdateBy(currentUser.getUsername());
        projectChange.setCertificateId(trainCertificateId);
        projectChange.setType("002");
        projectChange.setProjectname(projectname);
        projectChange.setProjectcontent(projectcontent);
        projectChange.setProjecttime(DateUtil.convertDateToString((Date)new Date(), (String)"yyyy-MM-dd"));
        this.projectChangeDao.save(projectChange);
    }

    public void delete(TrainCertificate trainCertificate) {
        trainCertificate.setUpdateTime(new Date());
        this.trainCertificateDao.delete(trainCertificate);
    }

    public TrainCertificate findById(long id) {
        return this.findById(id, "1");
    }

    public TrainCertificate findById(long id, String type) {
        TrainCertificate trainCertificate = this.trainCertificateDao.findById(Long.valueOf(id));
        if (trainCertificate != null) {
            try {
                String cerUrl = this.configUtils.getValueByKey("PERCERURL" + this.configUtils.getCurrentProvince());
                String pathName = QRCodeUtil.generateQRCode((String)(cerUrl + "/mobile/trainCertificate/find/" + id + ".do?type=" + type), (int)100, (int)100, (String)"jpg", (String)(this.tempFolder + "qrcode.jpg"));
                trainCertificate.setQrcode(Base64Img.GetImageStr((String)pathName, (String)"jpg"));
            }
            catch (Exception e) {
                this.logger.error(e.getMessage(), (Throwable)e);
            }
        }
        return trainCertificate;
    }

    public TrainCertificate findByIdV2(long id, String type) {
        User currentUser = this.arsUtil.getCurrentUser();
        Long qrCodeId = this.idWorker.nextId();
        TrainCertificate trainCertificate = this.trainCertificateDao.findById(Long.valueOf(id));
        if (trainCertificate != null) {
            try {
                TrainCertificateSnapshot trainCertificateSnapshot = new TrainCertificateSnapshot();
                trainCertificateSnapshot.setQrCodeId(qrCodeId);
                BeanUtils.copyPropertiesIgnore((Object)trainCertificate, (Object)trainCertificateSnapshot, (Boolean)true);
                trainCertificateSnapshot.setCreateTime(new Date());
                trainCertificateSnapshot.setUpdateTime(new Date());
                trainCertificateSnapshot.setCreateBy(currentUser.getUsername());
                if (this.trainCertificateSnapshotDao.save(trainCertificateSnapshot) <= 0) {
                    this.logger.error("\u4fdd\u5b89\u670d\u52a1\u516c\u53f8\u4fdd\u5b58\u5feb\u7167\u51fa\u9519\uff01");
                }
                String cerUrl = this.configUtils.getValueByKey("PERCERURL" + this.configUtils.getCurrentProvince());
                String pathName = QRCodeUtil.generateQRCode((String)(cerUrl + "/mobile/trainCertificateSnapshot/findByQrCodeId/" + qrCodeId + ".do?type=" + type), (int)100, (int)100, (String)"jpg", (String)(this.tempFolder + "qrcode.jpg"));
                trainCertificate.setQrcode(Base64Img.GetImageStr((String)pathName, (String)"jpg"));
            }
            catch (Exception e) {
                this.logger.error(e.getMessage(), (Throwable)e);
            }
        }
        return trainCertificate;
    }

    public TrainCertificate findByCompanyId(long companyId) {
        return this.trainCertificateDao.findByCompanyId(Long.valueOf(companyId));
    }

    public void searchForPage(TrainCertificateSearchDto dto, AjaxPageResponse page) {
        this.arsUtil.setPoliceSearch((SearchDto)dto);
        dto.setApplytype(Constants.TYPE_APPLY);
        this.trainCertificateDao.searchForPage(dto, page);
    }

    public void search(TrainCertificateSearchDto dto, AjaxPageResponse page) {
        this.arsUtil.setPoliceSearch((SearchDto)dto);
        dto.setApplytype(Constants.TYPE_APPLY);
        this.trainCertificateDao.search(dto, page);
    }

    public void updatePrintedByid(Long id) {
        TrainCertificate trainCertificate = this.trainCertificateDao.findById(id);
        if (trainCertificate.getPrintcount() == null || trainCertificate.getPrintcount().equals("")) {
            trainCertificate.setPrintcount("1");
        } else {
            int printcount = Integer.parseInt(trainCertificate.getPrintcount()) + 1;
            trainCertificate.setPrintcount(printcount + "");
        }
        trainCertificate.setPrintTime(new Date());
        trainCertificate.setHasprint(true);
        this.trainCertificateDao.update(trainCertificate);
    }

    public void createPdfBatch() {
        List list = this.trainCertificateDao.searchUnPdf();
        if (null != list && list.size() > 0) {
            PdfFormDto pdfFormDto = new PdfFormDto();
            pdfFormDto.setBusinesstype("002");
            new Thread(() -> {
                try {
                    for (TrainCertificate trainCertificate : list) {
                        pdfFormDto.setBusinessid(trainCertificate.getId());
                        try {
                            this.createPDFService.createPDF(pdfFormDto);
                        }
                        catch (Exception e) {
                            new ArsException("\u751f\u6210\u8bc1\u4e66pdf\u5931\u8d25");
                        }
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }).start();
        } else {
            new ArsException("\u6ca1\u6709\u9700\u8981\u751f\u6210PDF\u7684\u8bc1\u4e66\u6570\u636e");
        }
    }

    public int save(TrainCertificate trainCertificate) {
        User currentUser = this.arsUtil.getCurrentUser();
        if (trainCertificate.getId() == null) {
            trainCertificate.setApplytype(Constants.TYPE_APPLY);
            trainCertificate.setPrinttype(Constants.TYPE_PRINT_HZ);
            trainCertificate.setCreateTime(new Date());
        } else {
            TrainCertificate dbRecord = this.trainCertificateDao.findById(trainCertificate.getId());
            BeanUtils.copyPropertiesIgnore((Object)trainCertificate, (Object)dbRecord, (Boolean)true);
            BeanUtils.copyPropertiesIgnore((Object)dbRecord, (Object)trainCertificate, (Boolean)false);
        }
        String isInSystem = trainCertificate.getIsInSystem();
        if (!StringUtils.isEmpty((Object)isInSystem) && isInSystem.equals("2")) {
            String gsmcDefine = trainCertificate.getGsmcDefine();
            trainCertificate.setGsmc(gsmcDefine);
            trainCertificate.setCompanyid(null);
        }
        if (StringUtil.isEmpty((String)trainCertificate.getAreaCode())) {
            SecurityCompany company = this.securityCompanyService.findById(trainCertificate.getCompanyid());
            if (company != null && company.getOrgId() != null) {
                trainCertificate.setOrgId(Long.valueOf(Long.parseLong(company.getOrgId())));
                trainCertificate.setAreaCode(company.getAreaCode());
            } else {
                trainCertificate.setOrgId(currentUser.getOrgid());
                trainCertificate.setAreaCode(currentUser.getPolice().getAreaCode());
            }
        }
        trainCertificate.setActive(Boolean.valueOf(true));
        trainCertificate.setUpdateBy(currentUser.getUsername());
        trainCertificate.setUpdateTime(new Date());
        trainCertificate.setUpdateflag(Boolean.valueOf(true));
        return this.trainCertificateDao.insertOrUpdate(trainCertificate);
    }

    public List<String> selectCompanyName() {
        return this.trainCertificateDao.selectCompanyName();
    }

    public void updateAndCreatePDF(TrainCertificate trainCertificate) {
        User currentUser = this.arsUtil.getCurrentUser();
        TrainCertificate dbTrainCertificate = this.trainCertificateDao.findById(trainCertificate.getId());
        String[] projectname = new String[]{};
        String[] projectcontent = new String[]{};
        String[] projecttime = new String[]{};
        if (null != trainCertificate.getProjectChange()) {
            if (StringUtil.isNotEmpty((String)trainCertificate.getProjectChange().getProjectname())) {
                projectname = trainCertificate.getProjectChange().getProjectname().split(",");
            }
            if (StringUtil.isNotEmpty((String)trainCertificate.getProjectChange().getProjectcontent())) {
                projectcontent = trainCertificate.getProjectChange().getProjectcontent().split(",");
            }
            if (StringUtil.isNotEmpty((String)trainCertificate.getProjectChange().getProjecttime())) {
                projecttime = trainCertificate.getProjectChange().getProjecttime().split(",");
            }
        }
        int[] a = new int[]{projectname.length, projectcontent.length, projecttime.length};
        int counta = StringUtil.getMax((int[])a);
        this.projectChangeDao.deleteByCidAndType(trainCertificate.getId().toString(), "002");
        for (int i = 0; i < counta; ++i) {
            ProjectChange projectChange = new ProjectChange();
            projectChange.setActive(Boolean.valueOf(true));
            projectChange.setCreateTime(new Date());
            projectChange.setUpdateTime(new Date());
            projectChange.setUpdateBy(currentUser.getUsername());
            projectChange.setCertificateId(trainCertificate.getId());
            projectChange.setType("002");
            if (trainCertificate.getProjectChange() != null) {
                if (!StringUtil.isEmpty((String)trainCertificate.getProjectChange().getProjectname()) && projectname.length > i) {
                    projectChange.setProjectname(projectname[i]);
                }
                if (!StringUtil.isEmpty((String)trainCertificate.getProjectChange().getProjectcontent()) && projectcontent.length > i) {
                    projectChange.setProjectcontent(projectcontent[i]);
                }
                if (!StringUtil.isEmpty((String)trainCertificate.getProjectChange().getProjecttime()) && projecttime.length > i) {
                    projectChange.setProjecttime(projecttime[i]);
                }
            }
            this.projectChangeDao.save(projectChange);
        }
        if (dbTrainCertificate != null) {
            BeanUtils.copyPropertiesIgnore((Object)trainCertificate, (Object)dbTrainCertificate, (Boolean)true);
            dbTrainCertificate.setUpdateTime(new Date());
            if (StringUtil.isEmpty((String)dbTrainCertificate.getHasOld())) {
                dbTrainCertificate.setHasOld(Constants.PRINT_TYPE_OLD_NO);
                dbTrainCertificate.setPrinttype(Constants.PRINT_TYPE_ONLINE_YES);
            }
            dbTrainCertificate.setUpdateBy(currentUser.getUsername());
            dbTrainCertificate.setPdfpath(null);
            dbTrainCertificate.setPdfpathRevese(null);
            this.trainCertificateDao.update(dbTrainCertificate);
        } else {
            new ArsException("\u67e5\u627e\u4e0d\u5230\u4fdd\u5b89\u670d\u52a1\u516c\u53f8\u8bc1\u4e66\u4fe1\u606f");
        }
        PdfFormDto pdfFormDto = new PdfFormDto();
        pdfFormDto.setBusinesstype("002");
        pdfFormDto.setBusinessid(trainCertificate.getId());
        try {
            this.createPDFService.createPDF(pdfFormDto);
        }
        catch (Exception e) {
            new ArsException("\u751f\u6210\u8bc1\u4e66pdf\u5931\u8d25");
        }
    }

    public List<TrainCertificate> searchForDataSynchronization(DataSynchronizationSearchDto searchDto) {
        return this.trainCertificateDao.searchForDataSynchronization(searchDto);
    }

    public List<TrainCertificate> findDSOutList(String startDate) {
        return this.trainCertificateDao.findDSOutList(startDate);
    }

    public void importBatch(List<TrainCertificate> list) {
        List dbList = this.trainCertificateDao.findByBatchId(list);
        list.removeAll(dbList);
        if (list.size() > 0) {
            for (TrainCertificate companyCertificate : list) {
                companyCertificate.setUpdateflag(Boolean.valueOf(false));
                try {
                    if (this.configUtils.isIntranet()) continue;
                    companyCertificate.setUpdateTime(DateUtil.dateAdd((int)6, (Date)companyCertificate.getUpdateTime(), (int)1));
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            this.trainCertificateDao.saveBatch(list);
        }
    }
}

