/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.ars.service.certificate.impl;

import com.abcxin.smart.validator.annotation.DataSyncAnnotation;
import com.abcxin.smart.validator.annotation.DataSyncOutAnnotation;
import com.bcxin.ars.dao.certificate.GradeCompleteCerDao;
import com.bcxin.ars.dao.sb.PersonGradeDao;
import com.bcxin.ars.dto.DataSynchronizationSearchDto;
import com.bcxin.ars.dto.SearchDto;
import com.bcxin.ars.dto.page.GradeCompleteCerPageSearchDto;
import com.bcxin.ars.enums.ImportType;
import com.bcxin.ars.model.User;
import com.bcxin.ars.model.certificate.GradeCompleteCer;
import com.bcxin.ars.model.sb.PersonGrade;
import com.bcxin.ars.service.certificate.GradeCompleteCerService;
import com.bcxin.ars.service.impl.BaseService;
import com.bcxin.ars.service.util.ArsUtil;
import com.bcxin.ars.service.util.ConfigUtils;
import com.bcxin.ars.util.BeanUtils;
import com.bcxin.ars.util.DES3;
import com.bcxin.ars.util.DateUtil;
import com.bcxin.ars.util.GetPersonImgUtil;
import com.bcxin.ars.util.QRCodeUtil;
import com.com.bcxin.ars.com.abcxin.smart.core.web.validate.AjaxPageResponse;
import java.net.URLEncoder;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
@DataSyncAnnotation(getClazz=GradeCompleteCer.class, getMethodName="importBatch", getImportType=ImportType.BATCH)
@DataSyncOutAnnotation(getClazz=GradeCompleteCer.class)
public class GradeCompleteCerServiceImpl
extends BaseService
implements GradeCompleteCerService {
    Logger logger = LoggerFactory.getLogger(GradeCompleteCerServiceImpl.class);
    @Value(value="${BBD_H5_URL}")
    private String bbdH5Url;
    @Autowired
    private GradeCompleteCerDao gradeCompleteCerDao;
    @Autowired
    private PersonGradeDao personGradeDao;
    @Autowired
    private ConfigUtils configUtils;
    @Autowired
    private ArsUtil arsUtil;

    public int delete(GradeCompleteCer gradeCompleteCer) {
        User currentUser = this.arsUtil.getCurrentUser();
        gradeCompleteCer.setUpdateTime(new Date());
        gradeCompleteCer.setUpdateBy(currentUser.getUsername());
        return this.gradeCompleteCerDao.delete(gradeCompleteCer);
    }

    public int save(GradeCompleteCer gradeCompleteCer) {
        User currentUser = this.arsUtil.getCurrentUser();
        if (gradeCompleteCer.getId() == null) {
            gradeCompleteCer.setCreateTime(new Date());
        } else {
            GradeCompleteCer dbGradeCompleteCer = this.gradeCompleteCerDao.findById(gradeCompleteCer.getId());
            BeanUtils.copyPropertiesIgnore((Object)gradeCompleteCer, (Object)dbGradeCompleteCer, (Boolean)true);
            BeanUtils.copyPropertiesIgnore((Object)dbGradeCompleteCer, (Object)gradeCompleteCer, (Boolean)false);
        }
        gradeCompleteCer.setActive(Boolean.valueOf(true));
        gradeCompleteCer.setUpdateBy(currentUser.getUsername());
        gradeCompleteCer.setUpdateTime(new Date());
        gradeCompleteCer.setUpdateflag(Boolean.valueOf(true));
        gradeCompleteCer.setAreaCode(currentUser.getPolice().getAreacode());
        return this.gradeCompleteCerDao.save(gradeCompleteCer);
    }

    public GradeCompleteCer findById(Long id) {
        return this.gradeCompleteCerDao.findById(id);
    }

    public void searchForPage(GradeCompleteCerPageSearchDto dto, AjaxPageResponse page) {
        this.arsUtil.setPoliceSearch((SearchDto)dto);
        this.gradeCompleteCerDao.searchForPage(dto, page);
    }

    public void importBatch(List<GradeCompleteCer> list) {
        List dbList = this.gradeCompleteCerDao.findByBatchId(list);
        list.removeAll(dbList);
        if (list.size() > 0) {
            for (GradeCompleteCer gradeCompleteCer : list) {
                gradeCompleteCer.setUpdateflag(Boolean.valueOf(false));
                try {
                    if (this.configUtils.isIntranet()) continue;
                    gradeCompleteCer.setUpdateTime(DateUtil.dateAdd((int)6, (Date)gradeCompleteCer.getUpdateTime(), (int)1));
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            this.gradeCompleteCerDao.saveBatch(list);
        }
    }

    public List<GradeCompleteCer> findByBatchId(List<GradeCompleteCer> list) {
        return this.gradeCompleteCerDao.findByBatchId(list);
    }

    public List<GradeCompleteCer> searchForDataSynchronization(DataSynchronizationSearchDto dto) {
        return this.gradeCompleteCerDao.searchForDataSynchronization(dto);
    }

    public void saveOrUpdateForDS(List<GradeCompleteCer> list) {
        for (GradeCompleteCer gradeCompleteCer : list) {
            GradeCompleteCer gradeCompleteCerIn = this.gradeCompleteCerDao.findById(gradeCompleteCer.getId());
            if (gradeCompleteCerIn == null) {
                gradeCompleteCer.setUpdateflag(Boolean.valueOf(false));
                this.gradeCompleteCerDao.insert(gradeCompleteCer);
                continue;
            }
            if (gradeCompleteCer.getUpdateTime().getTime() <= gradeCompleteCerIn.getUpdateTime().getTime()) continue;
            this.gradeCompleteCerDao.update(gradeCompleteCer);
        }
    }

    public List<GradeCompleteCer> findDSOutList(String startDate) {
        return this.gradeCompleteCerDao.findDSOutList(startDate);
    }

    public void updateSelective(GradeCompleteCer gradeCompleteCer) {
        User currentUser = this.arsUtil.getCurrentUser();
        gradeCompleteCer.setUpdateTime(new Date());
        gradeCompleteCer.setUpdateBy(currentUser.getUsername());
        this.gradeCompleteCerDao.updateSelective(gradeCompleteCer);
    }

    public GradeCompleteCer findByPersonGradeId(Long personGradeId) {
        return this.gradeCompleteCerDao.findByPersonGradeId(personGradeId);
    }

    @Deprecated
    public GradeCompleteCer findByPersonGradeIdWithQRCode(Long personGradeId) throws Exception {
        PersonGrade personGrade = this.personGradeDao.findById(personGradeId);
        GradeCompleteCer completeCer = this.gradeCompleteCerDao.findByIdNum(personGrade.getIdNum(), personGrade.getGradeLevel());
        try {
            completeCer.setHeadImg("data:image/jpg;base64," + GetPersonImgUtil.GetImageStr((String)this.getResourcePath(personGrade.getHeadImg())));
            completeCer.setQrCode(this.createRQCode(completeCer.getId().toString()));
        }
        catch (Exception e) {
            e.printStackTrace();
            this.logger.error(e.getMessage());
        }
        return completeCer;
    }

    public String createRQCode(String cerId) throws Exception {
        return QRCodeUtil.generateBase64QRCode((String)this.getBbdH5Url(cerId), (int)100, (int)100, (String)"jpg");
    }

    public String getBbdH5Url(String cerId) throws Exception {
        String cerUrl = this.configUtils.getValueByKey("PERCERURL" + this.configUtils.getCurrentProvince());
        cerId = DES3.encode((String)cerId);
        cerId = URLEncoder.encode(cerId, "UTF-8");
        return cerUrl + "gradeiate/detail/index.do?cerId=" + cerId;
    }

    public GradeCompleteCer findByIdNum(String idNum, String gradeLevel) {
        return this.gradeCompleteCerDao.findByIdNum(idNum, gradeLevel);
    }
}

