/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.ars.service.certificate.impl;

import com.bcxin.ars.dao.ProjectChangeDao;
import com.bcxin.ars.dao.SecurityCompanyDao;
import com.bcxin.ars.dao.certificate.CompanyCertificateDao;
import com.bcxin.ars.dao.certificate.TrainCertificateDao;
import com.bcxin.ars.dao.sb.LegalchangeDao;
import com.bcxin.ars.dto.certificate.CompanyCertificateSearchDto;
import com.bcxin.ars.dto.certificate.TrainCertificateSearchDto;
import com.bcxin.ars.dto.pdf.PdfChangeDTO;
import com.bcxin.ars.dto.sys.PdfFormDto;
import com.bcxin.ars.model.Config;
import com.bcxin.ars.model.ProjectChange;
import com.bcxin.ars.model.SecurityCompany;
import com.bcxin.ars.model.certificate.CompanyCertificate;
import com.bcxin.ars.model.certificate.TrainCertificate;
import com.bcxin.ars.service.pdf.StampService;
import com.bcxin.ars.service.sb.CreatePDFService;
import com.bcxin.ars.service.util.ConfigUtils;
import com.bcxin.ars.util.BeanUtils;
import com.bcxin.ars.util.DateUtil;
import com.bcxin.ars.util.PDFUtils;
import com.bcxin.ars.util.StringUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class CreatePDFServiceImpl
implements CreatePDFService {
    @Autowired
    private CompanyCertificateDao companyCertificateDao;
    @Autowired
    private SecurityCompanyDao securityCompanyDao;
    @Autowired
    private TrainCertificateDao trainCertificateDao;
    @Autowired
    private LegalchangeDao legalchangeDao;
    @Autowired
    private ProjectChangeDao projectChangeDao;
    @Autowired
    private StampService stampService;
    @Autowired
    private ConfigUtils configUtils;
    @Value(value="${base-folder}")
    private String baseFolder;

    CompanyCertificateSearchDto getompanyCertificateData(PdfFormDto pdfFormDto) {
        CompanyCertificate companyCertificate = this.companyCertificateDao.findById(pdfFormDto.getBusinessid().longValue());
        CompanyCertificateSearchDto companyCertificateSearchDto = new CompanyCertificateSearchDto();
        if (null == companyCertificate) {
            return companyCertificateSearchDto;
        }
        companyCertificateSearchDto.setChange("");
        BeanUtils.copyPropertiesIgnore((Object)companyCertificate, (Object)companyCertificateSearchDto);
        if (null != companyCertificate.getZczb()) {
            companyCertificateSearchDto.setZczb(CreatePDFServiceImpl.digitUppercase(Double.parseDouble(companyCertificate.getZczb())));
        }
        if (StringUtil.isNotEmpty((String)companyCertificate.getPzwh())) {
            companyCertificateSearchDto.setPzwh(companyCertificate.getPzwh().replace("\u3010", "[").replace("\u3011", "]"));
        }
        try {
            companyCertificateSearchDto.setXkzh(companyCertificate.getXkzh().substring(0, companyCertificate.getXkzh().indexOf("2")) + " " + companyCertificate.getXkzh().substring(companyCertificate.getXkzh().indexOf("2")) + " \u53f7");
        }
        catch (Exception e) {
            companyCertificateSearchDto.setXkzh(companyCertificate.getXkzh().substring(0, companyCertificate.getXkzh().indexOf("\u670d") + 1) + " " + companyCertificate.getXkzh().substring(companyCertificate.getXkzh().indexOf("\u670d") + 1) + " \u53f7");
        }
        if (null != companyCertificate.getFzrq()) {
            companyCertificateSearchDto.setFzrqn(DateUtil.convertDateToString((Date)companyCertificate.getFzrq(), (String)"yyyy-MM-dd").substring(0, 4));
            companyCertificateSearchDto.setFzrqy(DateUtil.convertDateToString((Date)companyCertificate.getFzrq(), (String)"yyyy-MM-dd").substring(5, 7));
            companyCertificateSearchDto.setFzrqr(DateUtil.convertDateToString((Date)companyCertificate.getFzrq(), (String)"yyyy-MM-dd").substring(8, 10));
        }
        if (null != companyCertificate.getFwfw()) {
            String fwfw = this.formatManagement(companyCertificate.getFwfw(), companyCertificate.getOtherSecScopeType());
            SecurityCompany company = this.securityCompanyDao.findById(companyCertificate.getCompanyid());
            if (company != null && "02".equals(company.getSponsorlicenseType())) {
                companyCertificateSearchDto.setSponsorlicenseType(company.getSponsorlicenseType());
                if (null != fwfw && fwfw.length() > 22) {
                    companyCertificateSearchDto.setManagement(fwfw.substring(0, 22));
                    companyCertificateSearchDto.setManagement2(fwfw.substring(22));
                } else {
                    companyCertificateSearchDto.setManagement(fwfw);
                }
                if (null != fwfw && fwfw.length() > 22) {
                    companyCertificateSearchDto.setManagement_1(fwfw.substring(0, 22));
                    companyCertificateSearchDto.setManagement_2(fwfw.substring(22));
                } else {
                    companyCertificateSearchDto.setManagement_1(fwfw);
                }
            } else {
                if (null != fwfw && fwfw.length() > 19) {
                    companyCertificateSearchDto.setManagement(fwfw.substring(0, 19));
                    companyCertificateSearchDto.setManagement2(fwfw.substring(19));
                } else {
                    companyCertificateSearchDto.setManagement(fwfw);
                }
                if (null != fwfw && fwfw.length() > 19) {
                    companyCertificateSearchDto.setManagement_1(fwfw.substring(0, 19));
                    companyCertificateSearchDto.setManagement_2(fwfw.substring(19));
                } else {
                    companyCertificateSearchDto.setManagement_1(fwfw);
                }
            }
        }
        if (null != companyCertificate.getGsdz() && companyCertificate.getGsdz().length() > 16) {
            companyCertificateSearchDto.setGsdz_1(companyCertificate.getGsdz().substring(0, 16));
            companyCertificateSearchDto.setGsdz_2(companyCertificate.getGsdz().substring(16));
            if (companyCertificate.getGsdz().length() > 34) {
                companyCertificateSearchDto.setGsdz_2(companyCertificate.getGsdz().substring(16, 32));
                companyCertificateSearchDto.setGsdz_3(companyCertificate.getGsdz().substring(32));
            }
        } else {
            companyCertificateSearchDto.setGsdz_1(companyCertificate.getGsdz());
        }
        if (null != companyCertificate.getGsdz() && companyCertificate.getGsdz().length() > 20) {
            companyCertificateSearchDto.setGsdz(companyCertificate.getGsdz().substring(0, 20));
            companyCertificateSearchDto.setGsdz2(companyCertificate.getGsdz().substring(20));
        } else {
            companyCertificateSearchDto.setGsdz(companyCertificate.getGsdz());
        }
        if (null != companyCertificate) {
            List projectChangeList = this.projectChangeDao.findByCertificateIdAndType(companyCertificate.getId().toString(), "001");
            ArrayList<PdfChangeDTO> pdfChangeDTOList = new ArrayList<PdfChangeDTO>();
            if (null != projectChangeList && projectChangeList.size() > 0) {
                for (ProjectChange p : projectChangeList) {
                    PdfChangeDTO pdfChangeDTO = new PdfChangeDTO();
                    pdfChangeDTO.setProject(p.getProjectname());
                    pdfChangeDTO.setAfterChange(p.getProjectcontent());
                    pdfChangeDTO.setTime(p.getProjecttime());
                    pdfChangeDTOList.add(pdfChangeDTO);
                }
            }
            companyCertificateSearchDto.setPdfChangeDTOList(pdfChangeDTOList);
        }
        return companyCertificateSearchDto;
    }

    TrainCertificateSearchDto gettrainCertificateData(PdfFormDto pdfFormDto) {
        TrainCertificate trainCertificate = this.trainCertificateDao.findById(pdfFormDto.getBusinessid());
        TrainCertificateSearchDto trainCertificateSearchDto = new TrainCertificateSearchDto();
        if (null == trainCertificate) {
            return trainCertificateSearchDto;
        }
        BeanUtils.copyPropertiesIgnore((Object)trainCertificate, (Object)trainCertificateSearchDto);
        trainCertificateSearchDto.setChange("");
        trainCertificateSearchDto.setXkzh(trainCertificate.getXkzh().substring(0, trainCertificate.getXkzh().indexOf("2")) + " " + trainCertificate.getXkzh().substring(trainCertificate.getXkzh().indexOf("2")) + " \u53f7");
        if (null != trainCertificate.getFzrq()) {
            trainCertificateSearchDto.setFzrqn(DateUtil.convertDateToString((Date)trainCertificate.getFzrq(), (String)"yyyy-MM-dd").substring(0, 4));
            trainCertificateSearchDto.setFzrqy(DateUtil.convertDateToString((Date)trainCertificate.getFzrq(), (String)"yyyy-MM-dd").substring(5, 7));
            trainCertificateSearchDto.setFzrqr(DateUtil.convertDateToString((Date)trainCertificate.getFzrq(), (String)"yyyy-MM-dd").substring(8, 10));
        }
        if (null != trainCertificate.getGsdz() && trainCertificate.getGsdz().length() > 19) {
            trainCertificateSearchDto.setGsdz(trainCertificate.getGsdz().substring(0, 19));
            trainCertificateSearchDto.setGsdz2(trainCertificate.getGsdz().substring(19));
        } else {
            trainCertificateSearchDto.setGsdz(trainCertificate.getGsdz());
        }
        if (null != trainCertificate.getPxnr() && trainCertificate.getPxnr().length() > 46) {
            trainCertificateSearchDto.setPxnr(trainCertificate.getPxnr().substring(0, 23));
            trainCertificateSearchDto.setPxnr2(trainCertificate.getPxnr().substring(23, 46));
            trainCertificateSearchDto.setPxnr3(trainCertificate.getPxnr().substring(46));
        } else if (null != trainCertificate.getPxnr() && trainCertificate.getPxnr().length() > 23) {
            trainCertificateSearchDto.setPxnr(trainCertificate.getPxnr().substring(0, 23));
            trainCertificateSearchDto.setPxnr2(trainCertificate.getPxnr().substring(23));
        } else {
            trainCertificateSearchDto.setPxnr(trainCertificate.getPxnr());
        }
        if (null != trainCertificate.getGsdz() && trainCertificate.getGsdz().length() > 16) {
            trainCertificateSearchDto.setGsdz_1(trainCertificate.getGsdz().substring(0, 16));
            trainCertificateSearchDto.setGsdz_2(trainCertificate.getGsdz().substring(16));
        } else {
            trainCertificateSearchDto.setGsdz_1(trainCertificate.getGsdz());
        }
        if (null != trainCertificate.getPxnr() && trainCertificate.getPxnr().length() > 44) {
            trainCertificateSearchDto.setPxnr_1(trainCertificate.getPxnr().substring(0, 22));
            trainCertificateSearchDto.setPxnr_2(trainCertificate.getPxnr().substring(22, 44));
            trainCertificateSearchDto.setPxnr_3(trainCertificate.getPxnr().substring(44));
        } else if (null != trainCertificate.getPxnr() && trainCertificate.getPxnr().length() > 22) {
            trainCertificateSearchDto.setPxnr_1(trainCertificate.getPxnr().substring(0, 22));
            trainCertificateSearchDto.setPxnr_2(trainCertificate.getPxnr().substring(22));
        } else {
            trainCertificateSearchDto.setPxnr_1(trainCertificate.getPxnr());
        }
        List projectChangeList = this.projectChangeDao.findByCertificateIdAndType(trainCertificate.getId().toString(), "002");
        if (null != projectChangeList && projectChangeList.size() > 0) {
            ArrayList<PdfChangeDTO> pdfChangeDTOList = new ArrayList<PdfChangeDTO>();
            for (ProjectChange p : projectChangeList) {
                PdfChangeDTO pdfChangeDTO = new PdfChangeDTO();
                pdfChangeDTO.setProject(p.getProjectname());
                pdfChangeDTO.setAfterChange(p.getProjectcontent());
                pdfChangeDTO.setTime(p.getProjecttime());
                pdfChangeDTOList.add(pdfChangeDTO);
            }
            trainCertificateSearchDto.setPdfChangeDTOList(pdfChangeDTOList);
        }
        return trainCertificateSearchDto;
    }

    public void createPDF(PdfFormDto pdfFormDto) throws Exception {
        String templatePath = CreatePDFServiceImpl.class.getResource("/").toString();
        Config provinceConfig = this.configUtils.getConfigByKey("current_province");
        String companyCertificate1_Path = templatePath + "pdfTemplate/CompanyCertificate-1-6.pdf";
        String companyCertificate2_Path = templatePath + "pdfTemplate/CompanyCertificate-2-6.pdf";
        String companyTrain1_Path = templatePath + "pdfTemplate/CompanyTrain-1-2.pdf";
        String companyTrain2_Path = templatePath + "pdfTemplate/CompanyTrain-2-2.pdf";
        Date now = new Date();
        String confirmUrl = "";
        String registerUrl = "";
        String companyCertificate1FileName = now.getTime() + "_companyCertificate1.pdf";
        String companyCertificate2FileName = now.getTime() + "_companyCertificate2.pdf";
        String companyTrain1FileName = now.getTime() + "_companyTrain1.pdf";
        String companyTrain2FileName = now.getTime() + "_companyTrain2.pdf";
        String dirDate = DateUtil.systemDate.format(now);
        String filePath = "pdf/" + dirDate + "/";
        String pdfPath = this.baseFolder + filePath;
        File pdfFile = new File(pdfPath);
        if (!pdfFile.exists()) {
            pdfFile.mkdirs();
        }
        String companyCertificate1Path = pdfPath + companyCertificate1FileName;
        String companyCertificate2Path = pdfPath + companyCertificate2FileName;
        String companyCertificate2PathChaneg = pdfPath + "change_" + companyCertificate2FileName;
        String companyTrain1Path = pdfPath + companyTrain1FileName;
        String companyTrain2Path = pdfPath + companyTrain2FileName;
        String companyTrain2FileNameChaneg = pdfPath + "change_" + companyTrain2FileName;
        if ("001".equals(pdfFormDto.getBusinesstype())) {
            CompanyCertificateSearchDto companyCertificateSearchDto = this.getompanyCertificateData(pdfFormDto);
            if (null != companyCertificateSearchDto) {
                if ("02".equals(companyCertificateSearchDto.getSponsorlicenseType())) {
                    if (StringUtil.isEmpty((String)companyCertificateSearchDto.getGsdz_2())) {
                        companyCertificate1_Path = templatePath + "pdfTemplate/CompanyCertificate-1-6_single.pdf";
                        companyCertificate2_Path = templatePath + "pdfTemplate/CompanyCertificate-2-6_single_wz.pdf";
                    } else {
                        companyCertificate2_Path = StringUtil.isNotEmpty((String)companyCertificateSearchDto.getGsdz_3()) ? templatePath + "pdfTemplate/CompanyCertificate-2-6-3_wz.pdf" : templatePath + "pdfTemplate/CompanyCertificate-2-6_wz.pdf";
                    }
                } else {
                    if (StringUtil.isEmpty((String)companyCertificateSearchDto.getGsdz_2())) {
                        companyCertificate1_Path = templatePath + "pdfTemplate/CompanyCertificate-1-6_single.pdf";
                        companyCertificate2_Path = templatePath + "pdfTemplate/CompanyCertificate-2-6_single.pdf";
                    }
                    if (StringUtil.isNotEmpty((String)companyCertificateSearchDto.getGsdz_3())) {
                        companyCertificate2_Path = templatePath + "pdfTemplate/CompanyCertificate-2-6-3.pdf";
                    }
                }
                if (companyCertificateSearchDto.getGsmc().length() > 15) {
                    companyCertificate2_Path = templatePath + "pdfTemplate/CompanyCertificate-2-6_c.pdf";
                }
                PDFUtils.addPDFChange((String)companyCertificate2_Path, (String)companyCertificate2PathChaneg, (List)companyCertificateSearchDto.getPdfChangeDTOList());
                PDFUtils.createPDFForTemplate((String)companyCertificate1_Path, (String)companyCertificate1Path, (Object)companyCertificateSearchDto);
                PDFUtils.createPDFForTemplate((String)companyCertificate2PathChaneg, (String)companyCertificate2Path, (Object)companyCertificateSearchDto);
                if (null != provinceConfig && "610000".equals(provinceConfig.getValue())) {
                    this.stampService.addStamp(companyCertificate1Path, "1");
                    this.stampService.addStamp(companyCertificate2Path, "2");
                }
                CompanyCertificate companyCertificate = this.companyCertificateDao.findById(pdfFormDto.getBusinessid().longValue());
                companyCertificate.setPdfpath("getResource.do?path=" + filePath + companyCertificate1FileName);
                companyCertificate.setPdfpathRevese("getResource.do?path=" + filePath + companyCertificate2FileName);
                this.companyCertificateDao.update(companyCertificate);
            }
        } else if ("002".equals(pdfFormDto.getBusinesstype())) {
            TrainCertificateSearchDto trainCertificateSearchDto = this.gettrainCertificateData(pdfFormDto);
            if (StringUtil.isNotEmpty((String)trainCertificateSearchDto.getPxnr3())) {
                companyTrain1_Path = templatePath + "pdfTemplate/CompanyTrain-1-2-3.pdf";
            }
            if (StringUtil.isEmpty((String)trainCertificateSearchDto.getGsdz2())) {
                companyTrain1_Path = templatePath + "pdfTemplate/CompanyTrain-1-2_single.pdf";
                if (StringUtil.isNotEmpty((String)trainCertificateSearchDto.getPxnr3())) {
                    companyTrain1_Path = templatePath + "pdfTemplate/CompanyTrain-1-2_single-3.pdf";
                }
            }
            if (StringUtil.isNotEmpty((String)trainCertificateSearchDto.getPxnr_3())) {
                companyTrain2_Path = templatePath + "pdfTemplate/CompanyTrain-2-2-3.pdf";
            }
            if (StringUtil.isEmpty((String)trainCertificateSearchDto.getGsdz_2())) {
                companyTrain2_Path = templatePath + "pdfTemplate/CompanyTrain-2-2_single.pdf";
                if (StringUtil.isNotEmpty((String)trainCertificateSearchDto.getPxnr_3())) {
                    companyTrain2_Path = templatePath + "pdfTemplate/CompanyTrain-2-2_single-3.pdf";
                }
                if (trainCertificateSearchDto.getGsmc().length() > 15) {
                    companyTrain2_Path = templatePath + "pdfTemplate/CompanyTrain-2-2_single_c.pdf";
                    if (StringUtil.isNotEmpty((String)trainCertificateSearchDto.getPxnr_3())) {
                        companyTrain2_Path = templatePath + "pdfTemplate/CompanyTrain-2-2_single_c-3.pdf";
                    }
                }
            } else if (trainCertificateSearchDto.getGsmc().length() > 15) {
                companyTrain2_Path = templatePath + "pdfTemplate/CompanyTrain-2-2_c.pdf";
                if (StringUtil.isNotEmpty((String)trainCertificateSearchDto.getPxnr_3())) {
                    companyTrain2_Path = templatePath + "pdfTemplate/CompanyTrain-2-2_c-3.pdf";
                }
            }
            if (null != trainCertificateSearchDto) {
                PDFUtils.addPDFChange((String)companyTrain2_Path, (String)companyTrain2FileNameChaneg, (List)trainCertificateSearchDto.getPdfChangeDTOList());
                PDFUtils.createPDFForTemplate((String)companyTrain1_Path, (String)companyTrain1Path, (Object)trainCertificateSearchDto);
                PDFUtils.createPDFForTemplate((String)companyTrain2FileNameChaneg, (String)companyTrain2Path, (Object)trainCertificateSearchDto);
                if (null != provinceConfig && "610000".equals(provinceConfig.getValue())) {
                    this.stampService.addStamp(companyTrain1Path, "1");
                    this.stampService.addStamp(companyTrain2Path, "2");
                }
                TrainCertificate trainCertificate = this.trainCertificateDao.findById(pdfFormDto.getBusinessid());
                trainCertificate.setPdfpath("getResource.do?path=" + filePath + companyTrain1FileName);
                trainCertificate.setPdfpathRevese("getResource.do?path=" + filePath + companyTrain2FileName);
                this.trainCertificateDao.update(trainCertificate);
            }
        }
    }

    public static String digitUppercase(double v) {
        String UNIT = "\u4e07\u4edf\u4f70\u62fe\u4ebf\u4edf\u4f70\u62fe\u4e07\u4edf\u4f70\u62fe\u5143\u89d2\u5206";
        String DIGIT = "\u96f6\u58f9\u8d30\u53c1\u8086\u4f0d\u9646\u67d2\u634c\u7396";
        double MAX_VALUE = 9.99999999999999E12;
        if ((v *= 10000.0) < 0.0 || v > MAX_VALUE) {
            return "\u53c2\u6570\u975e\u6cd5!";
        }
        long l = Math.round(v * 100.0);
        if (l == 0L) {
            return "\u96f6\u5143";
        }
        String strValue = l + "";
        int i = 0;
        int j = UNIT.length() - strValue.length();
        String rs = "";
        boolean isZero = false;
        while (i < strValue.length()) {
            char ch = strValue.charAt(i);
            if (ch == '0') {
                isZero = true;
                if (UNIT.charAt(j) == '\u4ebf' || UNIT.charAt(j) == '\u4e07' || UNIT.charAt(j) == '\u5143') {
                    rs = rs + UNIT.charAt(j);
                    isZero = false;
                }
            } else {
                if (isZero) {
                    rs = rs + "\u96f6";
                    isZero = false;
                }
                rs = rs + DIGIT.charAt(ch - 48) + UNIT.charAt(j);
            }
            ++i;
            ++j;
        }
        rs = rs.replaceAll("\u4ebf\u4e07", "\u4ebf");
        return rs;
    }

    String formatManagement(String fwfw, String otherSecScopeType) {
        if (StringUtil.isEmpty((String)fwfw)) {
            return "";
        }
        StringBuffer management = new StringBuffer();
        String[] orders = new String[]{"1", "2", "3", "6", "4", "7", "9", "8", "10"};
        String[] ss = fwfw.split(",");
        for (int j = 0; j < orders.length; ++j) {
            for (int i = 0; i < ss.length; ++i) {
                if (!orders[j].equals(ss[i])) continue;
                if ("1".equals(ss[i])) {
                    management.append("\u95e8\u536b\u3001");
                    continue;
                }
                if ("2".equals(ss[i])) {
                    management.append("\u5de1\u903b\u3001");
                    continue;
                }
                if ("3".equals(ss[i])) {
                    management.append("\u5b88\u62a4\u3001");
                    continue;
                }
                if ("4".equals(ss[i])) {
                    management.append("\u968f\u8eab\u62a4\u536b\u3001");
                    continue;
                }
                if ("6".equals(ss[i])) {
                    management.append("\u62bc\u8fd0\u3001");
                    continue;
                }
                if ("10".equals(ss[i])) {
                    management.append("\u533a\u57df\u79e9\u5e8f\u7ef4\u62a4\u3001");
                    continue;
                }
                if ("7".equals(ss[i])) {
                    management.append("\u5b89\u5168\u68c0\u67e5\u3001");
                    continue;
                }
                if ("8".equals(ss[i])) {
                    management.append("\u5b89\u5168\u98ce\u9669\u8bc4\u4f30\u3001");
                    continue;
                }
                if ("9".equals(ss[i])) {
                    management.append("\u5b89\u5168\u6280\u672f\u9632\u8303\u3001");
                    continue;
                }
                if (!"20".equals(ss[i])) continue;
                management.append("\u5176\u4ed6" + (otherSecScopeType == null ? "" : "(" + otherSecScopeType + ")\u3001"));
            }
        }
        return management.toString().substring(0, management.toString().length() - 1);
    }

    public static void main(String[] args) throws Exception {
    }
}

