/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.ars.service.appeal.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.bcxin.ars.dao.sb.PersonGradeDao;
import com.bcxin.ars.dao.sb.PersonGradeDaoAop;
import com.bcxin.ars.dto.AjaxResult;
import com.bcxin.ars.exception.ArsException;
import com.bcxin.ars.model.appeal.Appeal;
import com.bcxin.ars.model.sb.PersonGrade;
import com.bcxin.ars.service.appeal.AppealHandle;
import com.bcxin.ars.service.util.BKTInterfaceUtil;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class GradeAppealHandle
implements AppealHandle {
    @Autowired
    private PersonGradeDao personGradeDao;
    @Autowired
    private PersonGradeDaoAop personGradeDaoAop;
    @Autowired
    private BKTInterfaceUtil bktInterfaceUtil;

    public void handle(Appeal appeal) {
        PersonGrade personGrade = this.personGradeDao.findById(appeal.getBusinessid());
        if ("003".equals(appeal.getAppealState())) {
            personGrade.setApprovalState("0");
            personGrade.setCensorStatus("1");
            personGrade.setApprovalReason(null);
            personGrade.setUpdateTime(new Date());
        } else if ("004".equals(appeal.getAppealState())) {
            personGrade.setApprovalState("2");
            personGrade.setCensorStatus("2");
            personGrade.setApprovalReason(appeal.getAppealReson());
            personGrade.setUpdateTime(new Date());
        }
        this.personGradeDaoAop.update(personGrade);
    }

    public void handle(List<Appeal> list) {
        if (list != null && list.size() > 0) {
            JSONArray paramArr = new JSONArray();
            JSONObject param = null;
            ArrayList<PersonGrade> gradeList = new ArrayList<PersonGrade>();
            for (Appeal appeal : list) {
                PersonGrade personGrade = this.personGradeDao.findById(appeal.getBusinessid());
                if ("003".equals(appeal.getAppealState())) {
                    personGrade.setApprovalState("0");
                    personGrade.setCensorStatus("1");
                    personGrade.setApprovalReason(null);
                    personGrade.setUpdateTime(new Date());
                } else if ("004".equals(appeal.getAppealState())) {
                    personGrade.setApprovalState("2");
                    personGrade.setCensorStatus("2");
                    personGrade.setApprovalReason(appeal.getAppealReson());
                    personGrade.setUpdateTime(new Date());
                }
                param = new JSONObject();
                param.put("gradeApplyId", (Object)(personGrade.getId() + ""));
                param.put("backgroundStatus", (Object)personGrade.getCensorStatus());
                param.put("approvalState", (Object)personGrade.getApprovalState());
                param.put("backgroundFailReason", (Object)personGrade.getApprovalReason());
                param.put("backgroundType", (Object)"2");
                paramArr.add((Object)param);
                gradeList.add(personGrade);
            }
            HashMap<String, Object> paramMap = new HashMap<String, Object>();
            paramMap.put("personList", JSON.toJSONString((Object)paramArr));
            AjaxResult result = this.bktInterfaceUtil.callInterface("train/bbd/grade/person/backgroundStatus", paramMap);
            if (!result.isSuccessful()) {
                throw new ArsException("\u3010\u7b49\u7ea7\u8bc1\u62a5\u540d\u7533\u8bc9\u7ed3\u679c\u3011" + result.getMsg());
            }
            this.personGradeDaoAop.saveBatch(gradeList);
        }
    }
}

