/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.ars.aspect;

import com.abcxin.smart.validator.annotation.RedissonAnnotation;
import java.lang.reflect.Method;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.reflect.MethodSignature;
import org.redisson.api.RLock;
import org.redisson.api.RedissonClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
@Aspect
public class RedissonAspect {
    private Logger logger = LoggerFactory.getLogger(RedissonAspect.class);
    private RedissonClient redisson;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Around(value="@annotation(com.abcxin.smart.validator.annotation.RedissonAnnotation)")
    public Object doAround(ProceedingJoinPoint pjp) throws Throwable {
        Signature sig = pjp.getSignature();
        MethodSignature msig = null;
        if (!(sig instanceof MethodSignature)) {
            this.logger.error("\u8be5\u6ce8\u89e3\u53ea\u80fd\u7528\u4e8e\u65b9\u6cd5");
            return pjp.proceed();
        }
        msig = (MethodSignature)sig;
        Object target = pjp.getTarget();
        Method currentMethod = target.getClass().getMethod(msig.getName(), msig.getParameterTypes());
        RedissonAnnotation annotation = currentMethod.getAnnotation(RedissonAnnotation.class);
        Object obj = null;
        RLock lock = null;
        boolean res = false;
        try {
            lock = this.redisson.getLock(annotation.getLockName());
            res = lock.tryLock(annotation.getWaitTime(), annotation.getLeaseTime(), annotation.getUnit());
            if (res) {
                obj = pjp.proceed();
            }
        }
        catch (Exception e) {
            this.logger.error(e.getMessage(), (Throwable)e);
        }
        finally {
            if (lock != null && lock.isLocked() && res) {
                lock.forceUnlock();
            }
        }
        return obj;
    }
}

