/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.ars.aspect;

import cn.hutool.core.util.ObjectUtil;
import com.abcxin.smart.validator.annotation.DataChangeAnnotation;
import com.abcxin.smart.validator.enums.ParamType;
import com.alibaba.fastjson.JSON;
import com.bcxin.ars.dto.DataChangeDto;
import com.bcxin.ars.model.sys.DataChange;
import com.bcxin.ars.service.sys.DataChangeService;
import com.bcxin.ars.util.DateUtil;
import com.bcxin.ars.util.StringUtil;
import com.bcxin.ars.util.spring.util.SpringUtils;
import com.bcxin.ars.util.thread.ThreadPoolManager;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.reflect.MethodSignature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.ReflectionUtils;

@Component
@Aspect
public class DataChangeAspect {
    private static final Logger logger = LoggerFactory.getLogger(DataChangeAspect.class);
    @Autowired
    private DataChangeService dataChangeService;

    @Around(value="@annotation(com.abcxin.smart.validator.annotation.DataChangeAnnotation)")
    public Object doAround(ProceedingJoinPoint pjp) throws Throwable {
        Signature sig = pjp.getSignature();
        MethodSignature msig = null;
        if (!(sig instanceof MethodSignature)) {
            logger.error("\u8be5\u6ce8\u89e3\u53ea\u80fd\u7528\u4e8e\u65b9\u6cd5");
            return pjp.proceed();
        }
        msig = (MethodSignature)sig;
        Object target = pjp.getTarget();
        Method currentMethod = target.getClass().getMethod(msig.getName(), msig.getParameterTypes());
        DataChangeAnnotation annotation = currentMethod.getAnnotation(DataChangeAnnotation.class);
        Class entityClazz = annotation.getEntityClazz();
        String fieldName = annotation.getFieldName();
        String methodName = msig.getDeclaringTypeName() + "." + msig.getName();
        Object oldValue = null;
        Object newValue = null;
        String tableName = null;
        Object value = null;
        try {
            if (msig.getParameterTypes() != null && msig.getParameterTypes().length > 0) {
                value = pjp.getArgs()[0];
                oldValue = this.getDBValue(value, annotation);
                String tableNameFieldName = annotation.getTableNameField();
                if (StringUtil.isNotEmpty((String)tableNameFieldName)) {
                    Field tableNameField = ReflectionUtils.findField((Class)entityClazz, (String)tableNameFieldName);
                    tableNameField.setAccessible(true);
                    Object fieldValue = ReflectionUtils.getField((Field)tableNameField, (Object)value);
                    if (fieldValue != null) {
                        tableName = fieldValue.toString();
                    }
                }
            }
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            e.printStackTrace();
        }
        Object obj = pjp.proceed();
        try {
            if (oldValue != null && (newValue = this.getDBValue(value, annotation)) != null) {
                final DataChangeDto dataChangeDto = new DataChangeDto(annotation, oldValue, newValue, methodName, entityClazz.getName(), tableName, fieldName);
                ThreadPoolManager threadPoolManager = ThreadPoolManager.newInstance();
                threadPoolManager.addExecuteTask(new Runnable(){

                    @Override
                    public void run() {
                        DataChangeAspect.this.saveLog(dataChangeDto);
                    }
                });
            }
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            e.printStackTrace();
        }
        return obj;
    }

    private void saveLog(DataChangeDto dataChangeDto) {
        if (dataChangeDto != null) {
            DataChangeAnnotation annotation = dataChangeDto.getAnnotation();
            Object oldValue = dataChangeDto.getOldValue();
            Object newValue = dataChangeDto.getNewValue();
            String methodName = dataChangeDto.getMethodName();
            String fieldName = dataChangeDto.getFieldName();
            Class entityClazz = annotation.getEntityClazz();
            Field field = ReflectionUtils.findField((Class)entityClazz, (String)fieldName);
            field.setAccessible(true);
            if (List.class.isInstance(oldValue)) {
                block0: for (Object oldObject : (List)oldValue) {
                    Object keyValue = ReflectionUtils.getField((Field)field, oldObject);
                    for (Object newObject : (List)newValue) {
                        if (!ObjectUtil.equal((Object)keyValue, (Object)ReflectionUtils.getField((Field)field, newObject))) continue;
                        this.saveDataChangeLog(entityClazz.getName(), oldObject, newObject, methodName, field, null, fieldName);
                        continue block0;
                    }
                }
            } else {
                this.saveDataChangeLog(entityClazz.getName(), oldValue, newValue, methodName, field, dataChangeDto.getTableName(), fieldName);
            }
        }
    }

    private Object getDBValue(Object value, DataChangeAnnotation annotation) {
        ParamType paramType = annotation.getParamType();
        Class daoClazz = annotation.getDaoClazz();
        Class paramClazz = annotation.getParamClazz();
        String searchMethodName = annotation.getSearchMethodName();
        String fieldName = annotation.getFieldName();
        Class entityClazz = annotation.getEntityClazz();
        Object entityDao = SpringUtils.getBean((Class)daoClazz);
        Method method = ReflectionUtils.findMethod((Class)daoClazz, (String)searchMethodName, (Class[])new Class[]{paramClazz});
        Object result = null;
        switch (paramType) {
            case FIELD: {
                Field field = ReflectionUtils.findField((Class)entityClazz, (String)fieldName);
                field.setAccessible(true);
                result = ReflectionUtils.invokeMethod((Method)method, (Object)entityDao, (Object[])new Object[]{ReflectionUtils.getField((Field)field, (Object)value)});
                break;
            }
            default: {
                if (method == null) {
                    logger.error("method\u4e3a\u7a7a");
                    break;
                }
                if (entityDao == null) {
                    logger.error("entityDao\u4e3a\u7a7a");
                    break;
                }
                if (value == null) {
                    logger.error("value\u4e3a\u7a7a");
                    break;
                }
                result = ReflectionUtils.invokeMethod((Method)method, (Object)entityDao, (Object[])new Object[]{value});
            }
        }
        return result;
    }

    private void saveDataChangeLog(String entityClazz, Object oldValue, Object newValue, String methodName, Field field, String tableName, String fieldName) {
        ArrayList<DataChangeDto> changeList = new ArrayList<DataChangeDto>();
        this.geChangeFieldValue(changeList, oldValue, newValue, oldValue.getClass());
        if (changeList.size() > 0) {
            this.dataChangeService.save(new DataChange(methodName, entityClazz, tableName, fieldName, ReflectionUtils.getField((Field)field, (Object)oldValue).toString(), JSON.toJSONString(changeList).toString()));
        }
    }

    private void geChangeFieldValue(List<DataChangeDto> changeList, Object oldValue, Object newValue, Class clazz) {
        Field[] fields = clazz.getDeclaredFields();
        DataChangeDto changeDto = null;
        for (Field field : fields) {
            if ("handler".equals(field.getName()) || !this.checkType(field).booleanValue()) continue;
            field.setAccessible(true);
            Object oldFieldValue = ReflectionUtils.getField((Field)field, (Object)oldValue);
            Object newFieldValue = ReflectionUtils.getField((Field)field, (Object)newValue);
            if (ObjectUtil.equal((Object)oldFieldValue, (Object)newFieldValue)) continue;
            changeDto = new DataChangeDto();
            changeDto.setFieldName(field.getName());
            if (Date.class.isInstance(oldFieldValue)) {
                try {
                    changeDto.setOldValue((Object)DateUtil.convertDateToString((Date)((Date)oldFieldValue), (String)"yyyy-MM-dd HH:mm:ss"));
                }
                catch (Exception e) {
                    logger.error(e.getMessage(), (Throwable)e);
                }
                try {
                    changeDto.setNewValue((Object)DateUtil.convertDateToString((Date)((Date)newFieldValue), (String)"yyyy-MM-dd HH:mm:ss"));
                }
                catch (Exception e) {
                    logger.error(e.getMessage(), (Throwable)e);
                }
            } else {
                changeDto.setOldValue(oldFieldValue);
                changeDto.setNewValue(newFieldValue);
            }
            changeList.add(changeDto);
        }
        if (clazz.getSuperclass() != null) {
            this.geChangeFieldValue(changeList, oldValue, newValue, clazz.getSuperclass());
        }
    }

    private Boolean checkType(Field field) {
        if (field.getType().isPrimitive()) {
            return true;
        }
        if (field.getType().equals(Long.class) || field.getType().equals(String.class) || field.getType().equals(Integer.class) || field.getType().equals(Date.class) || field.getType().equals(LocalDate.class) || field.getType().equals(LocalDateTime.class) || field.getType().equals(Boolean.class)) {
            return true;
        }
        return false;
    }
}

