/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.ars.service.util.gen;

import com.bcxin.ars.model.gen.GenTable;
import com.bcxin.ars.service.util.gen.GenConfig;
import com.bcxin.ars.util.DateUtil;
import com.bcxin.ars.util.StringUtil;
import com.bcxin.ars.util.text.StringUtils;
import java.util.ArrayList;
import java.util.List;
import org.apache.velocity.VelocityContext;

public class VelocityUtils {
    private static final String PROJECT_PATH = "main/java";
    private static final String MYBATIS_PATH = "main/resources/mapper";
    private static final String TEMPLATES_PATH = "main/resources/templates";
    private static final String DEFAULT_PARENT_MENU_ID = "3";

    public static VelocityContext prepareContext(GenTable genTable) {
        String moduleName = genTable.getModuleName();
        String businessName = genTable.getBusinessName();
        String packageName = genTable.getPackageName();
        String tplCategory = genTable.getTplCategory();
        String functionName = genTable.getFunctionName();
        VelocityContext velocityContext = new VelocityContext();
        velocityContext.put("tplCategory", (Object)genTable.getTplCategory());
        velocityContext.put("tableName", (Object)genTable.getTableName());
        velocityContext.put("functionName", (Object)(StringUtils.isNotEmpty((String)functionName) ? functionName : "\u3010\u8bf7\u586b\u5199\u529f\u80fd\u540d\u79f0\u3011"));
        velocityContext.put("ClassName", (Object)genTable.getClassName());
        velocityContext.put("className", (Object)StringUtils.uncapitalize((String)genTable.getClassName()));
        velocityContext.put("moduleName", (Object)genTable.getModuleName());
        velocityContext.put("businessName", (Object)genTable.getBusinessName());
        velocityContext.put("basePackage", (Object)VelocityUtils.getPackagePrefix(packageName));
        velocityContext.put("packageName", (Object)packageName);
        velocityContext.put("author", (Object)genTable.getFunctionAuthor());
        velocityContext.put("datetime", (Object)DateUtil.getCurrentDate());
        velocityContext.put("pkColumn", (Object)genTable.getPkColumn());
        velocityContext.put("permissionPrefix", (Object)VelocityUtils.getPermissionPrefix(moduleName, businessName));
        velocityContext.put("columns", (Object)genTable.getColumns());
        velocityContext.put("table", (Object)genTable);
        VelocityUtils.setMenuVelocityContext(velocityContext, genTable);
        return velocityContext;
    }

    public static void setMenuVelocityContext(VelocityContext context, GenTable genTable) {
        context.put("parentMenuId", (Object)genTable.getParentMenuId());
    }

    public static List<String> getTemplateList(String tplCategory) {
        ArrayList<String> templates = new ArrayList<String>();
        templates.add("vm/java/domain.java.vm");
        templates.add("vm/java/searchDto.java.vm");
        templates.add("vm/java/mapper.java.vm");
        templates.add("vm/java/service.java.vm");
        templates.add("vm/java/serviceImpl.java.vm");
        templates.add("vm/java/controller.java.vm");
        templates.add("vm/xml/mapper.xml.vm");
        templates.add("vm/html/list.jsp.vm");
        templates.add("vm/html/detail.jsp.vm");
        templates.add("vm/html/edit.jsp.vm");
        templates.add("vm/sql/sql.vm");
        return templates;
    }

    public static String getFileName(String template, GenTable genTable) {
        String fileName = "";
        String packageName = genTable.getPackageName();
        String moduleName = genTable.getModuleName();
        String className = genTable.getClassName();
        String businessName = genTable.getBusinessName();
        String javaPath = "main/java/" + StringUtils.replace((String)packageName, (String)".", (String)"/");
        String mybatisPath = MYBATIS_PATH;
        String htmlPath = "main/resources/templates/" + businessName;
        if (template.contains("domain.java.vm")) {
            fileName = StringUtils.format((String)"{}/model/{}.java", (Object[])new Object[]{javaPath, className});
        } else if (template.contains("searchDto.java.vm")) {
            fileName = StringUtils.format((String)"{}/dto/{}PageSearchDto.java", (Object[])new Object[]{javaPath, className});
        } else if (template.contains("mapper.java.vm")) {
            fileName = StringUtils.format((String)"{}/dao/{}Dao.java", (Object[])new Object[]{javaPath, className});
        } else if (template.contains("service.java.vm")) {
            fileName = StringUtils.format((String)"{}/service/{}Service.java", (Object[])new Object[]{javaPath, className});
        } else if (template.contains("serviceImpl.java.vm")) {
            fileName = StringUtils.format((String)"{}/service/impl/{}ServiceImpl.java", (Object[])new Object[]{javaPath, className});
        } else if (template.contains("controller.java.vm")) {
            fileName = StringUtils.format((String)"{}/controller/{}Controller.java", (Object[])new Object[]{javaPath, className});
        } else if (template.contains("mapper.xml.vm")) {
            fileName = StringUtils.format((String)"{}/{}Dao.xml", (Object[])new Object[]{mybatisPath, className});
        } else if (template.contains("list.jsp.vm")) {
            fileName = StringUtils.format((String)"{}/list.jsp", (Object[])new Object[]{htmlPath});
        } else if (template.contains("detail.jsp.vm")) {
            fileName = StringUtils.format((String)"{}/detail.jsp", (Object[])new Object[]{htmlPath});
        } else if (template.contains("edit.jsp.vm")) {
            fileName = StringUtils.format((String)"{}/edit.jsp", (Object[])new Object[]{htmlPath});
        } else if (template.contains("sql.vm")) {
            fileName = businessName + "Menu.sql";
        }
        return fileName;
    }

    public static String getProjectPath() {
        String packageName = GenConfig.packageName;
        StringBuffer projectPath = new StringBuffer();
        projectPath.append("main/java/");
        projectPath.append(packageName.replace(".", "/"));
        projectPath.append("/");
        return projectPath.toString();
    }

    public static String getPackagePrefix(String packageName) {
        int lastIndex = packageName.lastIndexOf(".");
        String basePackage = StringUtils.substring((String)packageName, (int)0, (int)lastIndex);
        return basePackage;
    }

    public static String getPermissionPrefix(String moduleName, String businessName) {
        if (StringUtil.isNotEmpty((String)moduleName)) {
            return StringUtils.format((String)"{}:{}", (Object[])new Object[]{moduleName, businessName});
        }
        return StringUtils.format((String)"{}", (Object[])new Object[]{businessName});
    }
}

