/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.ars.service.util;

import com.alibaba.fastjson.JSONObject;
import com.bcxin.ars.model.GXSSO;
import com.bcxin.ars.service.gx.GXSSOService;
import com.bcxin.ars.util.gx.encry.AES;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.ResponseBody;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class GXSSOUtil {
    private final Logger logger = LoggerFactory.getLogger(GXSSOUtil.class);
    private String url = "http://gafw.gat.gxzf.gov.cn/gxga/oauthSingleLogin";
    private String getuser = "/getUserObj";
    private String destroyProject = "/destroyProjectNo";
    private String report = "/reportData";
    @Autowired
    private GXSSOService gxssoService;

    public String getUserObj(String token) throws IOException {
        String urlPath = this.url + this.getuser;
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("token", (Object)token);
        String userinfo = "";
        JSONObject result = JSONObject.parseObject((String)this.doPost(jsonObject.toString(), urlPath));
        String num = result.getString("code");
        this.logger.error("\u5e7f\u897f\u5355\u70b9\u767b\u5f55\u83b7\u53d6\u7528\u6237\u4fe1\u606f" + userinfo);
        if (num.equals("100000")) {
            String date = result.getString("data");
            JSONObject dateObject = JSONObject.parseObject((String)date);
            userinfo = dateObject.getString("userObj");
            System.out.println(userinfo);
        }
        return userinfo;
    }

    public void destroyProjectNo(String projectNo) throws IOException {
        String urlPath = this.url + this.destroyProject;
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("projectNo", (Object)projectNo);
        String str = this.doPost(jsonObject.toString(), urlPath);
        JSONObject result = JSONObject.parseObject((String)str);
        String num = result.getString("code");
        this.logger.error("\u5e7f\u897f\u5355\u70b9\u767b\u5f55\u6838\u9500\u529e\u4ef6\u6d41\u6c34\u53f7\u7ed3\u679c" + str);
        if (num.equals("100000")) {
            GXSSO gxsso = this.gxssoService.findByProjectNo(projectNo);
            gxsso.setComplete(true);
            gxsso.setEndTime(new Date());
            this.gxssoService.update(gxsso);
        }
    }

    public void reportData(String token, String projectNo) throws IOException {
        String urlPath = this.url + this.report;
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("token", (Object)token);
        jsonObject.put("projectNo", (Object)projectNo);
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        jsonObject.put("applyDate", (Object)simpleDateFormat.format(new Date()));
        jsonObject.put("handleState", (Object)"\u53d7\u7406");
        String str = this.doPost(jsonObject.toString(), urlPath);
        JSONObject result = JSONObject.parseObject((String)str);
        String num = result.getString("code");
        this.logger.error("\u5e7f\u897f\u5355\u70b9\u767b\u5f55\u4e0a\u4f20\u529e\u4ef6\u7ed3\u679c" + str);
        if (num.equals("100000")) {
            GXSSO gxsso = this.gxssoService.findByProjectNo(projectNo);
            gxsso.setEndTime(new Date());
            gxsso.setComplete(true);
            this.gxssoService.update(gxsso);
        }
    }

    public String doPost(String param, String urlPath) throws IOException {
        OkHttpClient client = new OkHttpClient().newBuilder().build();
        MediaType mediaType = MediaType.parse((String)"application/json");
        RequestBody body = RequestBody.create((MediaType)mediaType, (String)param);
        Request request = new Request.Builder().url(urlPath).method("POST", body).addHeader("Content-Type", "application/json").build();
        Response response = client.newCall(request).execute();
        ResponseBody responseBody = response.body();
        return responseBody.string();
    }

    public String getPathFour(String taskCode) {
        String path = "/iframe/apply-login.jsp";
        if (taskCode.equals("34000000GA-XK-BA0047")) {
            path = path + "?butype=001";
        } else if (taskCode.equals("34000000GA-XK-BA0051")) {
            path = path + "?butype=002";
        } else if (taskCode.equals("34000000GA-XK-BA0001")) {
            path = path + "?butype=004";
        } else if (taskCode.equals("34000000GA-FW-BA0003")) {
            path = path + "?butype=006";
        } else if (taskCode.equals("34000000GA-FW-BA0001")) {
            path = path + "?butype=005";
        } else if (taskCode.equals("34000000GA-FW-BA0002")) {
            path = path + "?butype=003";
        } else if (taskCode.equals("34000000GA-XK-BA0048")) {
            path = path + "?butype=007";
        }
        return path;
    }

    public String getPathTwo(String taskCode, String sessionId) {
        String path = "/approval/approveMenu.do?sid=" + sessionId;
        if (!taskCode.equals("34000000GA-XK-BA0047")) {
            if (taskCode.equals("34000000GA-XK-BA0051")) {
                path = path + "&butype=002";
            } else if (taskCode.equals("34000000GA-XK-BA0001")) {
                path = path + "&butype=004";
            } else if (!taskCode.equals("34000000GA-FW-BA0003") && !taskCode.equals("34000000GA-FW-BA0001")) {
                if (taskCode.equals("34000000GA-FW-BA0002")) {
                    path = path + "&butype=003";
                } else if (taskCode.equals("34000000GA-XK-BA0048")) {
                    path = path + "&butype=007";
                }
            }
        }
        return path;
    }

    public void main(String[] args) {
        String un = AES.encrypt((String)"\u5bf9\u5bf9\u5bf9", (String)"76172485e4b7c82f02a7ce96214ee3e6");
        System.out.println(un);
        String str = "{\n    \"success\":true,\n    \"code\":\"10000\",\n    \"msg\":\"\u6210\u529f\",\n    \"data\":{\n        \"token\":\"90618a46659708a5ee6de508e25064ba\",\n        \"userObj\":{\n            \"authLevel\":0,\n            \"identityId\":\"3E4C316A63F17B1A112BBC7DADF38039E6A6CEB1F428146A1D1D93D3510F34C9\",\n            \"mobile\":\"C38F0C14288086BEF48FBA7B22102776\",\n            \"userName\":\"5474A014B81E8E6864A0DADCCDE6D04F\"\n        }\n    }\n}";
        JSONObject result = JSONObject.parseObject((String)str);
        if (result.getString("code").equals("10000")) {
            String date = result.getString("data");
            JSONObject dateObject = JSONObject.parseObject((String)date);
            String userinfo = dateObject.getString("userObj");
            JSONObject js = JSONObject.parseObject((String)userinfo);
            System.out.println(js.getString("userName"));
            String username = AES.decrypt((String)js.getString("userName"), (String)"76172485e4b7c82f02a7ce96214ee3e6");
            System.out.println(username);
        } else {
            System.out.println("dddd");
        }
    }
}

