/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.ars.service.task.impl;

import com.abcxin.smart.validator.annotation.DataSyncAnnotation;
import com.bcxin.ars.dao.task.PerTaskCardRecordDao;
import com.bcxin.ars.dao.task.PersonClockInDao;
import com.bcxin.ars.dto.DataSynchronizationSearchDto;
import com.bcxin.ars.dto.task.PersonClockInDto;
import com.bcxin.ars.enums.ImportType;
import com.bcxin.ars.model.task.PerTaskCardRecord;
import com.bcxin.ars.model.task.PersonClockIn;
import com.bcxin.ars.service.task.PersonClockInService;
import com.bcxin.ars.service.util.ConfigUtils;
import com.bcxin.ars.util.DateUtil;
import java.sql.Time;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
@DataSyncAnnotation(getClazz=PersonClockIn.class, getMethodName="importBatch", getImportType=ImportType.BATCH)
public class PersonClockInServiceImpl
implements PersonClockInService {
    Logger logger = LoggerFactory.getLogger(PersonClockInServiceImpl.class);
    @Autowired
    private PerTaskCardRecordDao perTaskCardRecordDao;
    @Autowired
    private PersonClockInDao personClockInDao;
    @Autowired
    private ConfigUtils configUtils;

    public int savePerClockIn(PerTaskCardRecord perTaskCardRecord) {
        PersonClockInDto personClockInDto = this.perTaskCardRecordDao.selectPerClockInDto(perTaskCardRecord.getTaskCardRecordId());
        if (personClockInDto == null) {
            return 0;
        }
        PersonClockIn personClockIn = this.personClockInDao.selectPerClockIn(personClockInDto);
        Date clockInDate = personClockInDto.getClockInDate();
        Date startWorkTime = this.timeToTimeDate(clockInDate, personClockInDto.getStartWorkTime());
        Date endWorkTime = this.timeToTimeDate(clockInDate, personClockInDto.getEndWorkTime());
        if (personClockIn == null) {
            personClockIn = new PersonClockIn();
            personClockIn.setPersonId(personClockInDto.getPersonId());
            personClockIn.setWorkDate(personClockInDto.getClockInDate());
            personClockIn.setShiftRuleId(personClockInDto.getShiftRuleId());
            personClockIn.setClockInRound(personClockInDto.getClockInRound());
            personClockIn.setStartWorkTime(startWorkTime);
            personClockIn.setEndWorkTime(endWorkTime);
        }
        if (personClockInDto.getClockInType().equals("1")) {
            if (personClockInDto.getClockInTime().getTime() > endWorkTime.getTime()) {
                Calendar c = Calendar.getInstance();
                c.setTime(clockInDate);
                c.add(5, 1);
                endWorkTime = this.timeToTimeDate(c.getTime(), personClockInDto.getEndWorkTime());
            }
            personClockIn.setStartWorkTime(personClockInDto.getClockInTime());
            personClockIn.setEndWorkTime(endWorkTime);
        }
        if (personClockInDto.getClockInType().equals("2")) {
            personClockIn.setEndWorkTime(personClockInDto.getClockInTime());
        }
        personClockIn.setUpdateTime(new Date());
        return this.personClockInDao.save(personClockIn);
    }

    public Date timeToTimeDate(Date date, Time time) {
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd");
        SimpleDateFormat formatter1 = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        String dateString = formatter.format(date) + " " + time.toString();
        Date timeDate = null;
        try {
            timeDate = formatter1.parse(dateString);
        }
        catch (Exception e) {
            this.logger.error(e.getMessage(), (Throwable)e);
        }
        return timeDate;
    }

    public void importBatch(List<PersonClockIn> list) {
        List dbList = this.personClockInDao.findByBatchId(list);
        list.removeAll(dbList);
        if (list.size() > 0) {
            for (PersonClockIn perTaskCardRecord : list) {
                try {
                    if (this.configUtils.isIntranet()) continue;
                    perTaskCardRecord.setUpdateTime(DateUtil.dateAdd((int)6, (Date)perTaskCardRecord.getUpdateTime(), (int)1));
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            this.personClockInDao.saveBatch(list);
        }
    }

    public List<PersonClockIn> searchForDataSynchronization(DataSynchronizationSearchDto dto) {
        return this.personClockInDao.searchForDataSynchronization(dto);
    }
}

