/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.ars.service.task.impl;

import com.abcxin.smart.validator.annotation.DataSyncAnnotation;
import com.bcxin.ars.dao.task.PerTaskCardRecordDao;
import com.bcxin.ars.dto.DataSynchronizationSearchDto;
import com.bcxin.ars.dto.SearchDto;
import com.bcxin.ars.dto.page.task.PerTaskCardRecordPageSearchDto;
import com.bcxin.ars.enums.ImportType;
import com.bcxin.ars.model.User;
import com.bcxin.ars.model.task.PerTaskCardRecord;
import com.bcxin.ars.service.task.PerTaskCardRecordService;
import com.bcxin.ars.service.util.ArsUtil;
import com.bcxin.ars.service.util.ConfigUtils;
import com.bcxin.ars.util.BeanUtils;
import com.bcxin.ars.util.DateUtil;
import com.com.bcxin.ars.com.abcxin.smart.core.web.validate.AjaxPageResponse;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
@DataSyncAnnotation(getClazz=PerTaskCardRecord.class, getMethodName="importBatch", getImportType=ImportType.BATCH)
public class PerTaskCardRecordServiceImpl
implements PerTaskCardRecordService {
    Logger logger = LoggerFactory.getLogger(PerTaskCardRecordServiceImpl.class);
    @Autowired
    private PerTaskCardRecordDao perTaskCardRecordDao;
    @Autowired
    private ConfigUtils configUtils;
    @Autowired
    private ArsUtil arsUtil;

    public int delete(PerTaskCardRecord perTaskCardRecord) {
        User currentUser = this.arsUtil.getCurrentUser();
        perTaskCardRecord.setUpdateTime(new Date());
        perTaskCardRecord.setUpdateBy(currentUser.getUsername());
        return this.perTaskCardRecordDao.delete(perTaskCardRecord);
    }

    public int save(PerTaskCardRecord perTaskCardRecord) {
        User currentUser = this.arsUtil.getCurrentUser();
        PerTaskCardRecord dbPerTaskCardRecord = this.perTaskCardRecordDao.findById(perTaskCardRecord.getTaskCardRecordId());
        if (dbPerTaskCardRecord != null) {
            BeanUtils.copyPropertiesIgnore((Object)perTaskCardRecord, (Object)dbPerTaskCardRecord, (Boolean)true);
            BeanUtils.copyPropertiesIgnore((Object)dbPerTaskCardRecord, (Object)perTaskCardRecord, (Boolean)false);
        }
        perTaskCardRecord.setUpdateBy(currentUser.getUsername());
        perTaskCardRecord.setUpdateTime(new Date());
        return this.perTaskCardRecordDao.save(perTaskCardRecord);
    }

    public PerTaskCardRecord findById(Long id) {
        return this.perTaskCardRecordDao.findById(id);
    }

    public void searchForPage(PerTaskCardRecordPageSearchDto dto, AjaxPageResponse page) {
        this.arsUtil.setPoliceSearch((SearchDto)dto);
        this.perTaskCardRecordDao.searchForPage(dto, page);
    }

    public void importBatch(List<PerTaskCardRecord> list) {
        List dbList = this.perTaskCardRecordDao.findByBatchId(list);
        list.removeAll(dbList);
        if (list.size() > 0) {
            for (PerTaskCardRecord perTaskCardRecord : list) {
                try {
                    if (this.configUtils.isIntranet()) continue;
                    perTaskCardRecord.setUpdateTime(DateUtil.dateAdd((int)6, (Date)perTaskCardRecord.getUpdateTime(), (int)1));
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            this.perTaskCardRecordDao.saveBatch(list);
        }
    }

    public List<PerTaskCardRecord> searchForDataSynchronization(DataSynchronizationSearchDto dto) {
        return this.perTaskCardRecordDao.searchForDataSynchronization(dto);
    }

    public List<PerTaskCardRecord> findDSOutList(String startDate) {
        return this.perTaskCardRecordDao.findDSOutList(startDate);
    }

    public List<PerTaskCardRecord> findByBatchId(List<PerTaskCardRecord> list) {
        return this.perTaskCardRecordDao.findByBatchId(list);
    }

    public void updateSelective(PerTaskCardRecord perTaskCardRecord) {
        User currentUser = this.arsUtil.getCurrentUser();
        perTaskCardRecord.setUpdateTime(new Date());
        perTaskCardRecord.setUpdateBy(currentUser.getUsername());
        this.perTaskCardRecordDao.updateSelective(perTaskCardRecord);
    }
}

