/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.ars.service.task.impl;

import com.bcxin.ars.dao.task.AppNoticeDao;
import com.bcxin.ars.dao.task.TaskDao;
import com.bcxin.ars.dao.task.TaskPersonDao;
import com.bcxin.ars.dto.AppNoticeSearchDto;
import com.bcxin.ars.dto.task.TaskAppNoticeDto;
import com.bcxin.ars.dto.task.TaskDetailSearchDto;
import com.bcxin.ars.dto.task.TaskDto;
import com.bcxin.ars.model.task.AppNotice;
import com.bcxin.ars.model.task.Task;
import com.bcxin.ars.model.task.TaskPerson;
import com.bcxin.ars.service.task.AppNoticeService;
import com.bcxin.ars.util.DateUtil;
import java.util.Date;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class AppNoticeServiceImpl
implements AppNoticeService {
    @Autowired
    private AppNoticeDao appNoticeDao;
    @Autowired
    private TaskDao taskDao;
    @Autowired
    private TaskPersonDao taskPersonDao;

    public AppNoticeSearchDto findAppNoticeList(AppNoticeSearchDto appNoticeSearchDto) {
        AppNoticeSearchDto resultDto = new AppNoticeSearchDto();
        List list = this.appNoticeDao.findAppNoticeList(appNoticeSearchDto);
        if (list != null && list.size() > 0) {
            TaskDetailSearchDto taskDetailDto = new TaskDetailSearchDto();
            for (AppNotice item : list) {
                if (item.getTaskID() == null) continue;
                taskDetailDto.setPersonid(appNoticeSearchDto.getPersonId());
                taskDetailDto.setTaskid(item.getTaskID());
                TaskDto taskDto = this.taskDao.findTaskDetail_V109(taskDetailDto);
                if (taskDto == null) continue;
                taskDto.setPersons(this.taskPersonDao.findTaskPersonsByTaskId(taskDto.getTaskid()));
                TaskAppNoticeDto taskAppNoticeDto = new TaskAppNoticeDto();
                taskAppNoticeDto.setCurrentTaskStatus(taskDto.getCurrentTaskStatus());
                taskAppNoticeDto.setTaskId(taskDto.getTaskid());
                item.setTask(taskAppNoticeDto);
            }
        }
        resultDto.setTotalCount(this.appNoticeDao.countAppNotice(appNoticeSearchDto));
        resultDto.setData(list);
        return resultDto;
    }

    public void updateReadStatus(Long id) {
        this.appNoticeDao.updateReadStatus(id);
    }

    public void save(AppNotice appNotice) {
        this.appNoticeDao.save(appNotice);
    }

    public void saveByTaskPerson(Task task, TaskPerson taskPerson) {
        AppNotice appNotice = new AppNotice();
        appNotice.setCreateTime(new Date());
        appNotice.setActive(Boolean.valueOf(true));
        appNotice.setNoticeContent("\u4efb\u52a1\u540d\u79f0\uff1a{taskName}\\n\u53d1\u5e03\u65e5\u671f\uff1a{taskDate}\\n\u4efb\u52a1\u5185\u5bb9\uff1a{taskContent}".replace("{taskName}", task.getName()).replace("{taskDate}", DateUtil.getCurrentDate((String)"yyyy-MM-dd HH:mm:ss")).replace("{taskContent}", task.getDetail()));
        appNotice.setNoticeTitle("\u60a8\u6709\u65b0\u4efb\u52a1\u5230\u8fbe\uff0c\u8bf7\u70b9\u51fb\u8fdb\u884c\u67e5\u770b");
        appNotice.setNoticeTypeID(Long.valueOf(3L));
        appNotice.setPersonId(taskPerson.getPerson().getId());
        appNotice.setReadStatus("0");
        appNotice.setTaskID(taskPerson.getTaskId());
        appNotice.setUpdateTime(new Date());
        this.appNoticeDao.save(appNotice);
    }
}

