/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.ars.service.sys.impl;

import com.abcxin.smart.validator.annotation.DataSyncAnnotation;
import com.bcxin.ars.dao.sys.BankAccountDao;
import com.bcxin.ars.dto.DataSynchronizationSearchDto;
import com.bcxin.ars.dto.SearchDto;
import com.bcxin.ars.dto.page.BankAccountPageSearchDto;
import com.bcxin.ars.enums.ImportType;
import com.bcxin.ars.model.User;
import com.bcxin.ars.model.sys.BankAccount;
import com.bcxin.ars.service.sys.BankAccountService;
import com.bcxin.ars.service.util.ArsUtil;
import com.bcxin.ars.service.util.ConfigUtils;
import com.bcxin.ars.service.util.IdWorker;
import com.bcxin.ars.util.BeanUtils;
import com.bcxin.ars.util.DateUtil;
import com.com.bcxin.ars.com.abcxin.smart.core.web.validate.AjaxPageResponse;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
@DataSyncAnnotation(getClazz=BankAccount.class, getImportType=ImportType.BATCH, getMethodName="importBatch")
public class BankAccountServiceImpl
implements BankAccountService {
    Logger logger = LoggerFactory.getLogger(BankAccountServiceImpl.class);
    @Autowired
    private BankAccountDao bankAccountDao;
    @Autowired
    private ConfigUtils configUtils;
    @Autowired
    private ArsUtil arsUtil;
    @Autowired
    private IdWorker idWorker;

    public int delete(BankAccount bankAccount) {
        User currentUser = this.arsUtil.getCurrentUser();
        bankAccount.setUpdateTime(new Date());
        bankAccount.setUpdateBy(currentUser.getUsername());
        return this.bankAccountDao.delete(bankAccount);
    }

    public int save(BankAccount bankAccount) {
        BankAccount dbBankAccount = this.bankAccountDao.findByIdNum(bankAccount.getIdNum());
        if (dbBankAccount == null) {
            bankAccount.setCreateTime(new Date());
            bankAccount.setId(Long.valueOf(this.idWorker.nextId()));
        } else {
            BeanUtils.copyPropertiesIgnore((Object)bankAccount, (Object)dbBankAccount, (Boolean)true);
            BeanUtils.copyPropertiesIgnore((Object)dbBankAccount, (Object)bankAccount, (Boolean)false);
        }
        bankAccount.setActive(Boolean.valueOf(true));
        bankAccount.setUpdateTime(new Date());
        bankAccount.setUpdateflag(Boolean.valueOf(true));
        return this.bankAccountDao.save(bankAccount);
    }

    public BankAccount findById(Long id) {
        return this.bankAccountDao.findById(id);
    }

    public void searchForPage(BankAccountPageSearchDto dto, AjaxPageResponse page) {
        this.arsUtil.setPoliceSearch((SearchDto)dto);
        this.bankAccountDao.searchForPage(dto, page);
    }

    public void importBatch(List<BankAccount> list) {
        List dbList = this.bankAccountDao.findByBatchId(list);
        list.removeAll(dbList);
        if (list.size() > 0) {
            for (BankAccount bankAccount : list) {
                bankAccount.setUpdateflag(Boolean.valueOf(false));
                try {
                    if (this.configUtils.isIntranet()) continue;
                    bankAccount.setUpdateTime(DateUtil.dateAdd((int)6, (Date)bankAccount.getUpdateTime(), (int)1));
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            this.bankAccountDao.saveBatch(list);
        }
    }

    public List<BankAccount> searchForDataSynchronization(DataSynchronizationSearchDto dto) {
        return this.bankAccountDao.searchForDataSynchronization(dto);
    }

    public List<BankAccount> findDSOutList(String startDate) {
        return this.bankAccountDao.findDSOutList(startDate);
    }

    public List<BankAccount> findByBatchId(List<BankAccount> list) {
        return this.bankAccountDao.findByBatchId(list);
    }

    public BankAccount findByIdNum(String idNum) {
        return this.bankAccountDao.findByIdNum(idNum);
    }

    public void updateSelective(BankAccount bankAccount) {
        User currentUser = this.arsUtil.getCurrentUser();
        bankAccount.setUpdateTime(new Date());
        bankAccount.setUpdateBy(currentUser.getUsername());
        this.bankAccountDao.updateSelective(bankAccount);
    }
}

