/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.ars.service.subsidy.impl;

import com.bcxin.ars.dao.subsidy.SubsidyOfflineBatchDao;
import com.bcxin.ars.dto.DataSynchronizationSearchDto;
import com.bcxin.ars.model.User;
import com.bcxin.ars.model.subsidy.SubsidyOfflineBatch;
import com.bcxin.ars.service.subsidy.SubsidyOfflineBatchService;
import com.bcxin.ars.service.util.ArsUtil;
import com.bcxin.ars.service.util.ConfigUtils;
import com.bcxin.ars.util.BeanUtils;
import com.bcxin.ars.util.DateUtil;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class SubsidyOfflineBatchServiceImpl
implements SubsidyOfflineBatchService {
    Logger logger = LoggerFactory.getLogger(SubsidyOfflineBatchServiceImpl.class);
    @Autowired
    private SubsidyOfflineBatchDao subsidyOfflineBatchDao;
    @Autowired
    private ConfigUtils configUtils;
    @Autowired
    private ArsUtil arsUtil;

    public int delete(SubsidyOfflineBatch subsidyOfflineBatch) {
        User currentUser = this.arsUtil.getCurrentUser();
        subsidyOfflineBatch.setUpdateTime(new Date());
        subsidyOfflineBatch.setUpdateBy(currentUser.getUsername());
        return this.subsidyOfflineBatchDao.delete(subsidyOfflineBatch);
    }

    public int save(SubsidyOfflineBatch subsidyOfflineBatch) {
        User currentUser = this.arsUtil.getCurrentUser();
        if (subsidyOfflineBatch.getId() == null) {
            subsidyOfflineBatch.setCreateTime(new Date());
        } else {
            SubsidyOfflineBatch dbSubsidyOfflineBatch = this.subsidyOfflineBatchDao.findById(subsidyOfflineBatch.getId());
            BeanUtils.copyPropertiesIgnore((Object)subsidyOfflineBatch, (Object)dbSubsidyOfflineBatch, (Boolean)true);
            BeanUtils.copyPropertiesIgnore((Object)dbSubsidyOfflineBatch, (Object)subsidyOfflineBatch, (Boolean)false);
        }
        subsidyOfflineBatch.setActive(Boolean.valueOf(true));
        subsidyOfflineBatch.setUpdateBy(currentUser.getUsername());
        subsidyOfflineBatch.setUpdateTime(new Date());
        subsidyOfflineBatch.setUpdateflag(Boolean.valueOf(true));
        subsidyOfflineBatch.setAreaCode(currentUser.getPolice().getAreacode());
        return this.subsidyOfflineBatchDao.save(subsidyOfflineBatch);
    }

    public SubsidyOfflineBatch findById(Long id) {
        return this.subsidyOfflineBatchDao.findById(id);
    }

    public void importBatch(List<SubsidyOfflineBatch> list) {
        List dbList = this.subsidyOfflineBatchDao.findByBatchId(list);
        list.removeAll(dbList);
        if (list.size() > 0) {
            for (SubsidyOfflineBatch subsidyOfflineBatch : list) {
                subsidyOfflineBatch.setUpdateflag(Boolean.valueOf(false));
                try {
                    if (this.configUtils.isIntranet()) continue;
                    subsidyOfflineBatch.setUpdateTime(DateUtil.dateAdd((int)6, (Date)subsidyOfflineBatch.getUpdateTime(), (int)1));
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            this.subsidyOfflineBatchDao.saveBatch(list);
        }
    }

    public List<SubsidyOfflineBatch> searchForDataSynchronization(DataSynchronizationSearchDto dto) {
        return this.subsidyOfflineBatchDao.searchForDataSynchronization(dto);
    }

    public List<SubsidyOfflineBatch> findDSOutList(String startDate) {
        return this.subsidyOfflineBatchDao.findDSOutList(startDate);
    }

    public List<SubsidyOfflineBatch> findByBatchId(List<SubsidyOfflineBatch> list) {
        return this.subsidyOfflineBatchDao.findByBatchId(list);
    }

    public void updateSelective(SubsidyOfflineBatch subsidyOfflineBatch) {
        User currentUser = this.arsUtil.getCurrentUser();
        subsidyOfflineBatch.setUpdateTime(new Date());
        subsidyOfflineBatch.setUpdateBy(currentUser.getUsername());
        this.subsidyOfflineBatchDao.updateSelective(subsidyOfflineBatch);
    }
}

