/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.ars.service.subsidy.impl;

import cn.hutool.core.collection.CollectionUtil;
import com.abcxin.smart.validator.annotation.DataSyncAnnotation;
import com.abcxin.smart.validator.annotation.DataSyncOutAnnotation;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.bcxin.ars.dao.subsidy.GradeSubsidyRosterDao;
import com.bcxin.ars.dao.subsidy.GradeSubsidyRosterDaoAop;
import com.bcxin.ars.dto.AjaxResult;
import com.bcxin.ars.dto.DataSynchronizationSearchDto;
import com.bcxin.ars.dto.subsidy.GradeSubsidyRosterDto;
import com.bcxin.ars.dto.subsidy.GradeSubsidyRosterSearchDto;
import com.bcxin.ars.enums.ImportType;
import com.bcxin.ars.model.User;
import com.bcxin.ars.model.subsidy.GradeSubsidyRoster;
import com.bcxin.ars.service.subsidy.GradeSubsidyRosterService;
import com.bcxin.ars.service.util.ArsUtil;
import com.bcxin.ars.service.util.BKTInterfaceUtil;
import com.bcxin.ars.service.util.ConfigUtils;
import com.bcxin.ars.util.Constants;
import com.bcxin.ars.util.DateUtil;
import com.bcxin.ars.util.JwtUtil;
import com.bcxin.ars.util.StringUtil;
import com.com.bcxin.ars.com.abcxin.smart.core.web.validate.AjaxPageResponse;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
@DataSyncAnnotation(getClazz=GradeSubsidyRoster.class, getImportType=ImportType.BATCH, getMethodName="importBatch")
@DataSyncOutAnnotation(getClazz=GradeSubsidyRoster.class, getImportType=ImportType.BATCH)
public class GradeSubsidyRosterServiceImpl
implements GradeSubsidyRosterService {
    Logger logger = LoggerFactory.getLogger(GradeSubsidyRosterServiceImpl.class);
    @Autowired
    private GradeSubsidyRosterDao gradeSubsidyRosterDao;
    @Autowired
    private GradeSubsidyRosterDaoAop gradeSubsidyRosterDaoAop;
    @Autowired
    private ArsUtil arsUtil;
    @Autowired
    private ConfigUtils configUtils;
    @Autowired
    private BKTInterfaceUtil bktInterfaceUtil;

    public GradeSubsidyRoster findById(Long id) {
        return this.gradeSubsidyRosterDao.findById(id);
    }

    public void search(GradeSubsidyRosterSearchDto searchDto, AjaxPageResponse<GradeSubsidyRoster> page) {
        this.gradeSubsidyRosterDao.search(searchDto, page);
    }

    public void searchForApply(GradeSubsidyRosterSearchDto searchDto, AjaxPageResponse<GradeSubsidyRosterDto> page) {
        this.gradeSubsidyRosterDao.searchForApply(searchDto, page);
    }

    public void save(GradeSubsidyRoster gradeSubsidyRoster) {
        User currentUser = this.arsUtil.getCurrentUser();
        if (gradeSubsidyRoster.getId() == null) {
            gradeSubsidyRoster.setCreateTime(new Date());
        }
        gradeSubsidyRoster.setActive(Boolean.valueOf(true));
        gradeSubsidyRoster.setUpdateBy(currentUser.getUsername());
        gradeSubsidyRoster.setUpdateTime(new Date());
        this.gradeSubsidyRosterDaoAop.save(gradeSubsidyRoster);
    }

    public void importBatch(List<GradeSubsidyRoster> list) {
        List dbList = this.gradeSubsidyRosterDao.findByBatchId(list);
        list.removeAll(dbList);
        if (list.size() > 0) {
            for (GradeSubsidyRoster gradeSubsidyRoster : list) {
                gradeSubsidyRoster.setUpdateflag(Boolean.valueOf(false));
                try {
                    if (this.configUtils.isIntranet()) continue;
                    gradeSubsidyRoster.setUpdateTime(DateUtil.dateAdd((int)6, (Date)gradeSubsidyRoster.getUpdateTime(), (int)1));
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            this.gradeSubsidyRosterDaoAop.saveBatch(list);
        }
    }

    public List<GradeSubsidyRoster> searchForDataSynchronization(DataSynchronizationSearchDto dto) {
        return this.gradeSubsidyRosterDao.searchForDataSynchronization(dto);
    }

    public List<GradeSubsidyRoster> findDSOutList(String startDate) {
        return this.gradeSubsidyRosterDao.findDSOutList(startDate);
    }

    public List<GradeSubsidyRoster> findByBatchId(List<GradeSubsidyRoster> list) {
        return this.gradeSubsidyRosterDao.findByBatchId(list);
    }

    public void compareStatusToBKT(List<GradeSubsidyRoster> rosterList) {
        JSONArray personList = new JSONArray();
        JSONObject perObj = null;
        for (GradeSubsidyRoster roster : rosterList) {
            if (!Constants.SUBSIDYCERTYPE_DJZ.equals(roster.getSubsidyCerType())) continue;
            perObj = new JSONObject();
            perObj.put("gradeApplyId", (Object)(roster.getGradeId() + ""));
            perObj.put("compareStatus", (Object)roster.getSubsidyStatus());
            perObj.put("compareFailReason", (Object)roster.getReason());
            perObj.put("compareType", (Object)"2");
            personList.add((Object)perObj);
        }
        if (personList.size() > 0) {
            HashMap<String, Object> paramMap = new HashMap<String, Object>();
            paramMap.put("personList", JSONArray.toJSONString((Object)personList));
            AjaxResult result = this.bktInterfaceUtil.callInterface("train/bbd/grade/person/compareStatus", paramMap);
            if (!result.isSuccessful()) {
                this.logger.error("\u3010\u7b49\u7ea7\u8bc1\u62a5\u540d\u8865\u8d34\u6bd4\u5bf9\u7ed3\u679c\u3011" + result.getMsg());
            }
        }
    }

    public Map statistics(GradeSubsidyRosterSearchDto searchDto) {
        return this.gradeSubsidyRosterDao.statistics(searchDto);
    }

    public AjaxResult listPersonnelSubsidyApplicationStatus(String gradeSubsidyRoster) {
        AjaxResult ajaxResult = new AjaxResult();
        String subject = JwtUtil.parseJWT((String)gradeSubsidyRoster).getSubject();
        List gradeSubsidyRosters = JSON.parseArray((String)subject, GradeSubsidyRoster.class);
        if (CollectionUtil.isEmpty((Collection)gradeSubsidyRosters)) {
            ajaxResult.setMsg("\u5931\u8d25, \u67e5\u8be2\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a");
            ajaxResult.setSuccessful(false);
            return ajaxResult;
        }
        ArrayList returnList = Lists.newArrayList();
        for (GradeSubsidyRoster subsidyRoster : gradeSubsidyRosters) {
            GradeSubsidyRoster rosterData = this.gradeSubsidyRosterDao.findSubsidyStatusAndSubsidyMoney(subsidyRoster);
            GradeSubsidyRoster returnData = new GradeSubsidyRoster();
            if (rosterData != null) {
                returnData.setSubsidyStatus(StringUtil.isEmpty((String)rosterData.getSubsidyStatus()) ? "" : rosterData.getSubsidyStatus());
                returnData.setSubsidyMoney(StringUtil.isEmpty((String)rosterData.getSubsidyMoney()) ? "" : rosterData.getSubsidyMoney());
            }
            returnData.setCensorStatusError(null);
            returnData.setIdNum(subsidyRoster.getIdNum());
            returnList.add(returnData);
        }
        ajaxResult.setData((Object)JwtUtil.createJWT((String)JSON.toJSONString((Object)returnList)));
        ajaxResult.setMsg("\u6210\u529f");
        ajaxResult.setSuccessful(true);
        return ajaxResult;
    }
}

