/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.ars.service.singleLogin.impl;

import com.alibaba.fastjson.JSON;
import com.bcxin.ars.dto.AjaxResult;
import com.bcxin.ars.dto.singleLogin.SingleUserDTO;
import com.bcxin.ars.model.User;
import com.bcxin.ars.service.impl.SingleUserLoginBaseServiceImpl;
import com.bcxin.ars.service.singleLogin.SingleLoginService;
import com.bcxin.ars.service.util.ConfigUtils;
import com.bcxin.ars.util.StringUtil;
import com.bjtoon.uia.sdk.client.DefaultUiaClient;
import com.bjtoon.uia.sdk.domain.AccessTokenVo;
import com.bjtoon.uia.sdk.domain.UserInfoVo;
import com.bjtoon.uia.sdk.exception.UiaException;
import com.bjtoon.uia.sdk.request.UiaOauthAccessTokenRequest;
import com.bjtoon.uia.sdk.request.UiaOauthUserInfoRequest;
import com.bjtoon.uia.sdk.request.UiaRequest;
import com.bjtoon.uia.sdk.response.UiaOauthAccessTokenResponse;
import com.bjtoon.uia.sdk.response.UiaOauthUserInfoResponse;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="singleLoginServiceBJImpl")
@Transactional
public class SingleLoginServiceBJImpl
extends SingleUserLoginBaseServiceImpl
implements SingleLoginService {
    private static Logger logger = LoggerFactory.getLogger(SingleLoginServiceBJImpl.class);
    @Autowired
    private ConfigUtils configUtils;

    @Override
    public User getUserInfo(SingleUserDTO userInfo) {
        User user = null;
        String tokenMsg = userInfo.getAccessToken();
        DefaultUiaClient uiaClient = new DefaultUiaClient(this.configUtils.bj_zrr_singleLogin_url);
        try {
            if (StringUtil.isEmpty((String)tokenMsg)) {
                tokenMsg = this.getAccessToken(userInfo.getCode());
            }
            if (!"getAccessTokenError".equals(tokenMsg)) {
                logger.error("bj_zrr_client_secret:" + this.configUtils.bj_zrr_client_secret);
                UiaOauthUserInfoRequest uiaOauthUserInfoRequest = new UiaOauthUserInfoRequest("/api/info/getUserInfo", tokenMsg, this.configUtils.bj_zrr_client_secret);
                UiaOauthUserInfoResponse userInfoResponse = (UiaOauthUserInfoResponse)uiaClient.execute((UiaRequest)uiaOauthUserInfoRequest, true);
                if (null != userInfoResponse && userInfoResponse.isSuccess()) {
                    UserInfoVo userInfoVo = userInfoResponse.getUserInfoVo();
                    user = new User();
                    user.setToken(tokenMsg);
                    user.setUniqueId(userInfoVo.getUniqueId());
                    user.setIdNumber(userInfoVo.getCertNo());
                    user.setPhone(userInfoVo.getMobile());
                    user.setPassword(userInfoVo.getMobile().substring(userInfoVo.getMobile().length() - 6, userInfoVo.getMobile().length()));
                    user.setRealname(userInfoVo.getCertName());
                    user.setUsername(userInfoVo.getMobile());
                } else if (null != userInfoResponse) {
                    logger.error(JSON.toJSONString((Object)userInfoResponse));
                }
            }
        }
        catch (UiaException e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw e;
        }
        return user;
    }

    public String getAccessToken(String code) {
        String tokenMsg = "";
        DefaultUiaClient uiaClient = new DefaultUiaClient(this.configUtils.bj_zrr_singleLogin_url);
        try {
            UiaOauthAccessTokenRequest request = new UiaOauthAccessTokenRequest("/api/oauth/getAccessToken", this.configUtils.bj_zrr_client_id, this.configUtils.bj_zrr_client_secret, code, "authorization_code", "user_info");
            UiaOauthAccessTokenResponse tokenResponse = (UiaOauthAccessTokenResponse)uiaClient.execute((UiaRequest)request);
            if (tokenResponse.isSuccess()) {
                AccessTokenVo accessTokenVo = tokenResponse.getAccessTokenVo();
                tokenMsg = accessTokenVo.getAccess_token();
            } else {
                tokenMsg = "getAccessTokenError";
                logger.error(JSON.toJSONString((Object)tokenResponse));
            }
        }
        catch (UiaException e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw e;
        }
        return tokenMsg;
    }

    public AjaxResult handle(SingleUserDTO dto, HttpServletRequest request) {
        return this.login(dto, request);
    }
}

