/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.ars.service.sb.impl;

import com.abcxin.smart.validator.annotation.DataSyncAnnotation;
import com.bcxin.ars.dao.SecurityCompanyDao;
import com.bcxin.ars.dao.SecurityPersonDao;
import com.bcxin.ars.dao.UserDao;
import com.bcxin.ars.dao.sb.ManagementInfoDao;
import com.bcxin.ars.dto.DataSynchronizationSearchDto;
import com.bcxin.ars.dto.SearchDto;
import com.bcxin.ars.dto.page.ManagementInfoPageSearchDto;
import com.bcxin.ars.dto.sb.ManagementInfoSearchDto;
import com.bcxin.ars.model.SecurityCompany;
import com.bcxin.ars.model.User;
import com.bcxin.ars.model.sb.ManagementInfo;
import com.bcxin.ars.service.sb.ManagementInfoService;
import com.bcxin.ars.service.util.ArsUtil;
import com.bcxin.ars.util.EntityForWebServiceUtil;
import com.bcxin.ars.util.KeyAndDefauleVal;
import com.bcxin.ars.webservice.Bafwgsglry;
import com.bcxin.ars.webservice.ClientUtil;
import com.com.bcxin.ars.com.abcxin.smart.core.web.validate.AjaxPageResponse;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
@DataSyncAnnotation(getClazz=ManagementInfo.class)
public class ManagementInfoServiceImpl
implements ManagementInfoService {
    private static Logger logger = LoggerFactory.getLogger(ManagementInfoServiceImpl.class);
    @Autowired
    private ManagementInfoDao managementInfoDao;
    @Autowired
    private SecurityCompanyDao securityCompanyDao;
    @Autowired
    private SecurityPersonDao personDao;
    @Autowired
    private ArsUtil arsUtil;
    @Autowired
    private ClientUtil clientUtil;
    @Autowired
    private UserDao userDao;

    public ManagementInfo findById(long id) {
        return this.managementInfoDao.findById(id);
    }

    public void saveOrUpdate(ManagementInfo managementInfo) {
        User currentUser = this.arsUtil.getCurrentUser();
        if (managementInfo.getId() == null) {
            managementInfo.setActive(Boolean.valueOf(true));
            managementInfo.setCreateTime(new Date());
            managementInfo.setUpdateTime(new Date());
            managementInfo.setUpdateBy(currentUser.getUsername());
            managementInfo.setUserid(currentUser.getId());
            this.managementInfoDao.save(managementInfo);
        } else {
            ManagementInfo dbManagementInfo = this.managementInfoDao.findById(managementInfo.getId().longValue());
            dbManagementInfo.setUpdateTime(new Date());
            dbManagementInfo.setUpdateBy(currentUser.getUsername());
            dbManagementInfo.setUpdateTime(new Date());
            dbManagementInfo.setEducation(managementInfo.getEducation());
            dbManagementInfo.setJobLevel(managementInfo.getJobLevel());
            dbManagementInfo.setJobName(managementInfo.getJobName());
            dbManagementInfo.setManagerId(managementInfo.getManagerId());
            dbManagementInfo.setManagerLicenseType(managementInfo.getManagerLicenseType());
            dbManagementInfo.setPhone(managementInfo.getPhone());
            dbManagementInfo.setShareRatio(managementInfo.getShareRatio());
            dbManagementInfo.setName(managementInfo.getName());
            dbManagementInfo.setAbroadaddress(managementInfo.getAbroadaddress());
            dbManagementInfo.setAddress(managementInfo.getAddress());
            dbManagementInfo.setSex(managementInfo.getSex());
            dbManagementInfo.setManageNation(managementInfo.getManageNation());
            dbManagementInfo.setIsVeteran(managementInfo.getIsVeteran());
            dbManagementInfo.setDepartName(managementInfo.getDepartName());
            this.managementInfoDao.update(dbManagementInfo);
        }
    }

    public ManagementInfoSearchDto search(ManagementInfoSearchDto dto) {
        ManagementInfoSearchDto resultDto = new ManagementInfoSearchDto();
        List list = this.managementInfoDao.search(dto);
        resultDto.setData(list);
        if (dto.isPaging()) {
            resultDto.setTotalCount(this.managementInfoDao.searchCount(dto));
        }
        return resultDto;
    }

    public void delete(ManagementInfo managementInfo) {
        User currentUser = this.arsUtil.getCurrentUser();
        managementInfo.setUpdateBy(currentUser.getUsername());
        managementInfo.setUpdateTime(new Date());
        this.managementInfoDao.delete(managementInfo);
    }

    public List<ManagementInfo> searchForDataSynchronization(DataSynchronizationSearchDto searchDto) {
        return this.managementInfoDao.searchForDataSynchronization(searchDto);
    }

    public void saveOrUpdateForDS(ManagementInfo managementInfo) {
        if (managementInfo.getActive() == null) {
            managementInfo.setActive(Boolean.valueOf(true));
        }
        if (!managementInfo.getActive().booleanValue()) {
            this.managementInfoDao.delete(managementInfo);
            new Thread(() -> {
                try {
                    User user = this.userDao.findById(managementInfo.getId());
                    this.buildWebServiceEntity(managementInfo, user);
                }
                catch (Exception e) {
                    logger.error(e.getMessage(), (Throwable)e);
                }
            }).start();
        } else {
            ManagementInfo dbManagementInfo = this.managementInfoDao.findById(managementInfo.getId().longValue());
            if (dbManagementInfo == null) {
                this.managementInfoDao.saveForDS(managementInfo);
            } else if (managementInfo.getUpdateTime().getTime() > dbManagementInfo.getUpdateTime().getTime()) {
                this.managementInfoDao.update(managementInfo);
            }
        }
    }

    public void saveOrUpdateForSaas(ManagementInfo managementInfo) {
        User currentUser = this.arsUtil.getCurrentUser();
        ManagementInfo dbManagementInfo = this.managementInfoDao.findById(managementInfo.getId().longValue());
        if (null == dbManagementInfo) {
            managementInfo.setActive(Boolean.valueOf(true));
            managementInfo.setCreateTime(new Date());
            managementInfo.setUpdateTime(new Date());
            managementInfo.setUpdateBy(currentUser.getUsername());
            managementInfo.setUserid(currentUser.getId());
            this.managementInfoDao.save(managementInfo);
        } else {
            dbManagementInfo.setUpdateTime(new Date());
            dbManagementInfo.setUpdateBy(currentUser.getUsername());
            dbManagementInfo.setEducation(managementInfo.getEducation());
            dbManagementInfo.setJobLevel(managementInfo.getJobLevel());
            dbManagementInfo.setJobName(managementInfo.getJobName());
            dbManagementInfo.setManagerId(managementInfo.getManagerId());
            dbManagementInfo.setManagerLicenseType(managementInfo.getManagerLicenseType());
            dbManagementInfo.setPhone(managementInfo.getPhone());
            dbManagementInfo.setShareRatio(managementInfo.getShareRatio());
            dbManagementInfo.setName(managementInfo.getName());
            dbManagementInfo.setAbroadaddress(managementInfo.getAbroadaddress());
            dbManagementInfo.setAddress(managementInfo.getAddress());
            dbManagementInfo.setSex(managementInfo.getSex());
            dbManagementInfo.setManageNation(managementInfo.getManageNation());
            dbManagementInfo.setIsVeteran(managementInfo.getIsVeteran());
            dbManagementInfo.setDepartName(managementInfo.getDepartName());
            this.managementInfoDao.update(dbManagementInfo);
        }
    }

    private void buildWebServiceEntity(ManagementInfo managementInfo, User user) throws Exception {
        Bafwgsglry bafwgsglry = new Bafwgsglry();
        HashMap<String, KeyAndDefauleVal> map = new HashMap<String, KeyAndDefauleVal>();
        SecurityCompany securityCompany = this.securityCompanyDao.findByUserid(user.getId());
        bafwgsglry.setBagsbm(securityCompany.getCompanyCode());
        map.put("bagsbm", new KeyAndDefauleVal("bagsbm", (Object)bafwgsglry.getBagsbm()));
        map.put("sfzh", new KeyAndDefauleVal("managerId", (Object)managementInfo.getManagerId()));
        map.put("xm", new KeyAndDefauleVal("name", null));
        map.put("xb", new KeyAndDefauleVal("sex", (Object)(managementInfo.getSex() == "\u7537" ? 1 : 0)));
        map.put("mz", new KeyAndDefauleVal("manageNation", null));
        map.put("zw", new KeyAndDefauleVal("jobName", null));
        map.put("baydj", new KeyAndDefauleVal("jobLevel", null));
        map.put("lxdh", new KeyAndDefauleVal("phone", null));
        map.put("gatlx", new KeyAndDefauleVal("managerLicenseType", (Object)("0" + managementInfo.getManagerLicenseType())));
        map.put("gj", new KeyAndDefauleVal("manageNation", (Object)""));
        map.put("bz1", new KeyAndDefauleVal("manageNation", (Object)""));
        map.put("bz2", new KeyAndDefauleVal("manageNation", (Object)""));
        map.put("bz3", new KeyAndDefauleVal("manageNation", (Object)""));
        try {
            EntityForWebServiceUtil.copy(map, (Object)managementInfo, (Object)bafwgsglry);
            this.clientUtil.send("xxba_bafwgsglry", (Object)bafwgsglry);
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
    }

    public void searchForPage(ManagementInfoPageSearchDto dto, AjaxPageResponse page) {
        this.arsUtil.setPoliceSearch((SearchDto)dto);
        this.managementInfoDao.searchForPage(dto, page);
    }
}

