/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.ars.service.sb.impl;

import com.bcxin.ars.dao.msg.SysAttachmentDao;
import com.bcxin.ars.dao.sb.HandleGuideDao;
import com.bcxin.ars.dto.SearchDto;
import com.bcxin.ars.dto.sb.HandleGuideSearchDto;
import com.bcxin.ars.exception.ArsException;
import com.bcxin.ars.model.PageResult;
import com.bcxin.ars.model.User;
import com.bcxin.ars.model.msg.SysAttachment;
import com.bcxin.ars.model.sb.HandleGuide;
import com.bcxin.ars.service.sb.HandleGuideService;
import com.bcxin.ars.service.util.ArsUtil;
import com.bcxin.ars.util.StringUtil;
import com.com.bcxin.ars.com.abcxin.smart.core.web.validate.AjaxPageResponse;
import java.util.Date;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class HandleGuideServiceImpl
implements HandleGuideService {
    @Autowired
    private ArsUtil arsUtil;
    @Autowired
    private HandleGuideDao handleGuideDao;
    @Autowired
    private SysAttachmentDao sysAttachmentDao;

    public Long save(HandleGuide handleGuide) {
        return this.handleGuideDao.save(handleGuide);
    }

    public HandleGuide findById(Long id) {
        HandleGuide handleGuide = this.handleGuideDao.findById(id);
        handleGuide.setSysAttachment(this.sysAttachmentDao.findByBusiness(id.toString(), "003"));
        return handleGuide;
    }

    public HandleGuide findByBusinessType(String businessType, String type) {
        return this.handleGuideDao.findByBusinessType(businessType, type);
    }

    public void update(HandleGuide handleGuide) {
        this.handleGuideDao.update(handleGuide);
    }

    public PageResult search(HandleGuideSearchDto searchDto) {
        List list = this.handleGuideDao.search(searchDto);
        Long count = this.handleGuideDao.searchCount(searchDto);
        return new PageResult(Integer.valueOf(count.intValue()), (Object)list);
    }

    public void saveOrUpdate(HandleGuide handleGuide) {
        if (handleGuide.getId() == null) {
            throw new ArsException("\u529e\u7406\u6307\u5357\u4fe1\u606f\u9519\u8bef\uff0c\u8bf7\u5237\u65b0\u91cd\u8bd5\uff01");
        }
        User currentUser = this.arsUtil.getCurrentUser();
        HandleGuide dbHandleGuide = this.handleGuideDao.findById(handleGuide.getId());
        if (StringUtil.isNotEmpty((String)handleGuide.getContent())) {
            dbHandleGuide.setContent(handleGuide.getContent());
        }
        this.handleGuideDao.update(dbHandleGuide);
        SysAttachment sysAttachment = new SysAttachment();
        sysAttachment.setBusinessid(dbHandleGuide.getId());
        sysAttachment.setBusinesstype("003");
        this.sysAttachmentDao.delete(sysAttachment);
        if (StringUtil.isNotEmpty((String)handleGuide.getSysAttachmentId())) {
            SysAttachment dbSysAttachment = this.sysAttachmentDao.findById(Long.valueOf(Long.parseLong(handleGuide.getSysAttachmentId())));
            dbSysAttachment.setBusinessid(dbHandleGuide.getId());
            dbSysAttachment.setBusinesstype("003");
            dbSysAttachment.setUpdateBy(currentUser.getUsername());
            dbSysAttachment.setUpdateTime(new Date());
            this.sysAttachmentDao.update(dbSysAttachment);
        }
    }

    public void searchForPage(HandleGuideSearchDto searchDto, AjaxPageResponse<HandleGuide> page) {
        this.arsUtil.setPoliceSearch((SearchDto)searchDto);
        this.handleGuideDao.searchForPage(searchDto, page);
    }
}

