/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.ars.service.sb.impl;

import com.bcxin.ars.dao.sb.ApproveAttachmentDao;
import com.bcxin.ars.dto.DataSynchronizationSearchDto;
import com.bcxin.ars.dto.SearchDto;
import com.bcxin.ars.dto.page.ApproveAttachmentPageSearchDto;
import com.bcxin.ars.model.User;
import com.bcxin.ars.model.sb.ApproveAttachment;
import com.bcxin.ars.service.sb.ApproveAttachmentService;
import com.bcxin.ars.service.util.ArsUtil;
import com.bcxin.ars.service.util.ConfigUtils;
import com.bcxin.ars.util.BeanUtils;
import com.bcxin.ars.util.DateUtil;
import com.com.bcxin.ars.com.abcxin.smart.core.web.validate.AjaxPageResponse;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ApproveAttachmentServiceImpl
implements ApproveAttachmentService {
    Logger logger = LoggerFactory.getLogger(ApproveAttachmentServiceImpl.class);
    @Autowired
    private ApproveAttachmentDao approveAttachmentDao;
    @Autowired
    private ConfigUtils configUtils;
    @Autowired
    private ArsUtil arsUtil;

    public int delete(ApproveAttachment approveAttachment) {
        User currentUser = this.arsUtil.getCurrentUser();
        approveAttachment.setUpdateTime(new Date());
        approveAttachment.setUpdateBy(currentUser.getUsername());
        return this.approveAttachmentDao.delete(approveAttachment);
    }

    public int save(ApproveAttachment approveAttachment) {
        User currentUser = this.arsUtil.getCurrentUser();
        if (approveAttachment.getId() == null) {
            approveAttachment.setCreateTime(new Date());
        } else {
            ApproveAttachment dbApproveAttachment = this.approveAttachmentDao.findById(approveAttachment.getId());
            BeanUtils.copyPropertiesIgnore((Object)approveAttachment, (Object)dbApproveAttachment, (Boolean)true);
            BeanUtils.copyPropertiesIgnore((Object)dbApproveAttachment, (Object)approveAttachment, (Boolean)false);
        }
        approveAttachment.setActive(Boolean.valueOf(true));
        approveAttachment.setUpdateBy(currentUser.getUsername());
        approveAttachment.setUpdateTime(new Date());
        approveAttachment.setUpdateflag(Boolean.valueOf(true));
        approveAttachment.setUserId(currentUser.getId());
        approveAttachment.setUploader(currentUser.getRealname());
        return this.approveAttachmentDao.save(approveAttachment);
    }

    public ApproveAttachment findById(Long id) {
        return this.approveAttachmentDao.findById(id);
    }

    public void searchForPage(ApproveAttachmentPageSearchDto dto, AjaxPageResponse page) {
        this.arsUtil.setPoliceSearch((SearchDto)dto);
        this.approveAttachmentDao.searchForPage(dto, page);
    }

    public void importBatch(List<ApproveAttachment> list) {
        List dbList = this.approveAttachmentDao.findByBatchId(list);
        list.removeAll(dbList);
        if (list.size() > 0) {
            for (ApproveAttachment approveAttachment : list) {
                approveAttachment.setUpdateflag(Boolean.valueOf(false));
                try {
                    if (this.configUtils.isIntranet()) continue;
                    approveAttachment.setUpdateTime(DateUtil.dateAdd((int)6, (Date)approveAttachment.getUpdateTime(), (int)1));
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            this.approveAttachmentDao.saveBatch(list);
        }
    }

    public List<ApproveAttachment> searchForDataSynchronization(DataSynchronizationSearchDto dto) {
        return this.approveAttachmentDao.searchForDataSynchronization(dto);
    }

    public List<ApproveAttachment> findDSOutList(String startDate) {
        return this.approveAttachmentDao.findDSOutList(startDate);
    }

    public List<ApproveAttachment> findByBatchId(List<ApproveAttachment> list) {
        return this.approveAttachmentDao.findByBatchId(list);
    }

    public void updateSelective(ApproveAttachment approveAttachment) {
        User currentUser = this.arsUtil.getCurrentUser();
        approveAttachment.setUpdateTime(new Date());
        approveAttachment.setUpdateBy(currentUser.getUsername());
        this.approveAttachmentDao.updateSelective(approveAttachment);
    }
}

