/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.ars.service.impl;

import com.abcxin.smart.validator.annotation.DataSyncAnnotation;
import com.abcxin.smart.validator.annotation.DataSyncOutAnnotation;
import com.alibaba.fastjson.JSONArray;
import com.bcxin.ars.dao.ConfigDao;
import com.bcxin.ars.dao.DataAuthDao;
import com.bcxin.ars.dao.OperationDao;
import com.bcxin.ars.dao.PermissionDao;
import com.bcxin.ars.dao.PoliceDao;
import com.bcxin.ars.dao.PoliceRoleDao;
import com.bcxin.ars.dao.sys.ModulePermissionDao;
import com.bcxin.ars.dto.DataSynchronizationSearchDto;
import com.bcxin.ars.dto.PoliceRoleSearchDto;
import com.bcxin.ars.dto.page.PoliceRoleDto;
import com.bcxin.ars.dto.page.RolePageSearchDto;
import com.bcxin.ars.exception.ArsException;
import com.bcxin.ars.model.Config;
import com.bcxin.ars.model.DataAuth;
import com.bcxin.ars.model.Operation;
import com.bcxin.ars.model.Permission;
import com.bcxin.ars.model.Police;
import com.bcxin.ars.model.PoliceRole;
import com.bcxin.ars.model.User;
import com.bcxin.ars.model.sys.ModulePermission;
import com.bcxin.ars.service.PoliceRoleService;
import com.bcxin.ars.service.util.ArsUtil;
import com.bcxin.ars.service.util.IdWorker;
import com.bcxin.ars.util.BeanUtils;
import com.bcxin.ars.util.CipherDESUtil;
import com.bcxin.ars.util.Constants;
import com.bcxin.ars.util.DateUtil;
import com.bcxin.ars.util.StringUtil;
import com.com.bcxin.ars.com.abcxin.smart.core.web.validate.AjaxPageResponse;
import com.google.common.io.Files;
import java.io.File;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
@DataSyncAnnotation(getClazz=PoliceRole.class)
@DataSyncOutAnnotation(getClazz=PoliceRole.class)
public class PoliceRoleServiceImpl
implements PoliceRoleService {
    private Logger logger = LoggerFactory.getLogger(PoliceRoleServiceImpl.class);
    @Autowired
    private PoliceRoleDao policeRoleDao;
    @Autowired
    private ArsUtil arsUtil;
    @Autowired
    private PermissionDao permissionDao;
    @Autowired
    private OperationDao operationDao;
    @Autowired
    private DataAuthDao dataAuthDao;
    @Autowired
    private PoliceDao policeDao;
    @Autowired
    private ConfigDao configDao;
    @Autowired
    private ModulePermissionDao modulePermissionDao;
    @Autowired
    private IdWorker idWorker;
    @Value(value="${personcertificate-download-folder}")
    private String tempftpFolder;

    public PoliceRole findById(long id) {
        return this.policeRoleDao.findById(id);
    }

    public void saveOrUpdate(PoliceRole policeRole, Long[] operationIds, String orgIds) {
        User currentUser = this.arsUtil.getCurrentUser();
        PoliceRole checkRole = this.findByOrgIdAndRoleName(policeRole.getOrgid(), policeRole.getRolename());
        if (policeRole.getId() == null) {
            if (checkRole != null) {
                throw new ArsException("\u8be5\u673a\u6784\u4e0b\uff0c\u5df2\u5b58\u5728\u6b64\u89d2\u8272\u540d\u79f0!");
            }
            policeRole.setActive(Boolean.valueOf(true));
            policeRole.setCreateTime(new Date());
            policeRole.setUpdateTime(new Date());
            policeRole.setCreaterorg(currentUser.getOrgName());
            policeRole.setUpdateBy(currentUser.getUsername());
            policeRole.setUpdateflag(Boolean.valueOf(true));
            this.policeRoleDao.save(policeRole);
        } else {
            if (checkRole != null && checkRole.getId().intValue() != policeRole.getId().intValue()) {
                throw new ArsException("\u8be5\u673a\u6784\u4e0b\uff0c\u5df2\u5b58\u5728\u6b64\u89d2\u8272\u540d\u79f0!");
            }
            PoliceRole dbPoliceRole = this.policeRoleDao.findById(policeRole.getId().longValue());
            dbPoliceRole.setUpdateBy(currentUser.getUsername());
            dbPoliceRole.setUpdateTime(new Date());
            BeanUtils.copyPropertiesIgnore((Object)policeRole, (Object)dbPoliceRole, (Boolean)true);
            dbPoliceRole.setUpdateflag(Boolean.valueOf(true));
            this.policeRoleDao.update(dbPoliceRole);
            this.permissionDao.deleteByRole(policeRole.getId(), "2");
            this.dataAuthDao.deleteByRole(policeRole.getId());
        }
        if (operationIds != null && operationIds.length > 0) {
            ArrayList<Permission> permissionList = new ArrayList<Permission>();
            List operationList = this.operationDao.findByIdArray(operationIds);
            Long[] longArray = operationIds;
            int n = longArray.length;
            for (int i = 0; i < n; ++i) {
                Long operationId = longArray[i];
                Permission permission = new Permission();
                permission.setNativeCode(this.arsUtil.getCurrentNatvie());
                permission.setRoleid(policeRole.getId());
                Operation operation = null;
                for (Operation temp : operationList) {
                    if (temp.getId().longValue() != operationId.longValue()) continue;
                    operation = temp;
                }
                if (operation == null) continue;
                permission.setOperation(operation);
                permission.setModule(operation.getModule());
                permission.setRoletype("2");
                permissionList.add(permission);
            }
            this.permissionDao.insertBatch(permissionList);
        }
        if (StringUtil.isNotEmpty((String)orgIds)) {
            ArrayList<DataAuth> dataAuthList = new ArrayList<DataAuth>();
            for (String orgid : orgIds.split(",")) {
                if (!StringUtil.isNotEmpty((String)orgid)) continue;
                DataAuth auth = new DataAuth();
                auth.setActive(Boolean.valueOf(true));
                auth.setCreateTime(new Date());
                auth.setUpdateTime(new Date());
                auth.setUpdateBy(currentUser.getUsername());
                auth.setRoleid(policeRole.getId());
                auth.setOrgid(Long.valueOf(Long.parseLong(orgid)));
                dataAuthList.add(auth);
            }
            this.dataAuthDao.insertBatch(dataAuthList);
        }
    }

    public String findApprovalRole(PoliceRoleSearchDto dto) {
        Config approvalrole;
        User user = this.arsUtil.getCurrentUser();
        if (user == null || user.getPlatform() != 1) {
            return null;
        }
        String key = "sp";
        String areaCode = "";
        Police police = null;
        if (StringUtil.isEmpty((String)dto.getOrgIds()) && user.getOrgid() != null) {
            dto.setOrgIds(user.getOrgid() + "");
            police = this.policeDao.findById(user.getOrgid());
        } else {
            police = this.policeDao.findById(Long.valueOf(Long.parseLong(dto.getOrgIdList()[dto.getOrgIdList().length - 1])));
        }
        if (police != null) {
            areaCode = police.getAreacode();
            areaCode = areaCode.endsWith("0000") ? areaCode.substring(0, 2) + "0000" : areaCode.substring(0, 4) + "00";
        }
        if ((approvalrole = this.configDao.findByKey(key = key + areaCode + police.getOrgtype())) != null) {
            return approvalrole.getValue();
        }
        return null;
    }

    public void deleteRoleByOrgId(Long orgId) {
        this.policeRoleDao.deleteRoleByOrgId(orgId);
    }

    private PoliceRole findByOrgIdAndRoleName(Long orgid, String rolename) {
        return this.policeRoleDao.findByOrgIdAndRoleName(orgid, rolename);
    }

    public PoliceRoleSearchDto search(PoliceRoleSearchDto dto) {
        Police police;
        User user = this.arsUtil.getCurrentUser();
        if (user == null || user.getPlatform() != 1) {
            return null;
        }
        if (dto.getOrgid() == null && user.getOrgid() != null) {
            dto.setOrgid(user.getOrgid());
            police = this.policeDao.findById(user.getOrgid());
            if ((dto.getQueryType() == null || dto.getQueryType().equals("")) && police.getOrgtype() != null) {
                if (police.getOrgtype().equals("4")) {
                    dto.setOrgtype("4");
                } else if (police.getOrgtype().equals("1")) {
                    dto.setOrgtype("1");
                } else if (police.getOrgtype().equals("2")) {
                    dto.setOrgtype("2");
                } else {
                    dto.setOrgtype("3");
                }
            }
        } else {
            police = this.policeDao.findById(dto.getOrgid());
            if ((dto.getQueryType() == null || dto.getQueryType().equals("")) && police.getOrgtype() != null) {
                if (police.getOrgtype().equals("4")) {
                    dto.setOrgtype("4");
                } else if (police.getOrgtype().equals("1")) {
                    dto.setOrgtype("1");
                } else if (police.getOrgtype().equals("2")) {
                    dto.setOrgtype("2");
                } else {
                    dto.setOrgtype("3");
                }
            }
        }
        List list = this.policeRoleDao.search(dto);
        Long count = this.policeRoleDao.searchCount(dto);
        dto.setData(list);
        dto.setTotalCount(count);
        return dto;
    }

    public void delete(PoliceRole policeRole) {
        User currentUser = this.arsUtil.getCurrentUser();
        PoliceRoleSearchDto dto = new PoliceRoleSearchDto();
        dto.setRoleid(policeRole.getId());
        dto.setRoletype("2");
        List roles = this.policeRoleDao.findByRoleId(dto);
        if (roles != null && roles.size() > 0) {
            throw new ArsException("\u8be5\u89d2\u8272\u5df2\u6709\u7528\u6237\uff0c\u4e0d\u5141\u8bb8\u5220\u9664\uff01");
        }
        policeRole.setUpdateBy(currentUser.getUsername());
        policeRole.setUpdateTime(new Date());
        policeRole.setUpdateflag(Boolean.valueOf(true));
        this.policeRoleDao.delete(policeRole);
    }

    public List<PoliceRole> findByUserId(Long userid) {
        return this.policeRoleDao.findByUserId(userid);
    }

    public List<PoliceRole> findByRoleId(Long roleid) {
        PoliceRoleSearchDto dto = new PoliceRoleSearchDto();
        dto.setRoleid(roleid);
        dto.setRoletype("2");
        return this.policeRoleDao.findByRoleId(dto);
    }

    public List<PoliceRole> findAll() {
        return this.policeRoleDao.findAll();
    }

    public void saveOrUpdateForDS(PoliceRole policeRole) {
        PoliceRole dbPoliceRole = this.policeRoleDao.findById(policeRole.getId().longValue());
        if (dbPoliceRole != null && policeRole.getUpdateTime().getTime() > dbPoliceRole.getUpdateTime().getTime()) {
            if (!policeRole.getActive().booleanValue()) {
                this.policeRoleDao.delete(policeRole);
            } else {
                this.policeRoleDao.update(policeRole);
            }
        }
    }

    public PoliceRoleSearchDto searchForUser(PoliceRoleSearchDto dto) {
        User user = this.arsUtil.getCurrentUser();
        if (user == null || user.getPlatform() != 1) {
            return null;
        }
        List list = this.policeRoleDao.searchForUser(dto);
        dto.setData(list);
        return dto;
    }

    private void writeTxtFile(String readStr, String type) {
        try {
            String basePath = this.tempftpFolder;
            String filePath = basePath + DateUtil.getCurrentDate() + File.separator;
            String fileName = type;
            String fileType = ".data";
            File file = new File(filePath);
            if (!file.exists()) {
                file.mkdirs();
                System.out.println("\u6587\u4ef6\u5939\u5df2\u521b\u5efa");
            }
            String fullFilePath = filePath + fileName + "_" + DateUtil.getCurrentDateTime((String)"yyyyMMddHHmmss") + fileType;
            File newFile = new File(fullFilePath);
            Files.write((byte[])readStr.getBytes(), (File)newFile);
        }
        catch (Exception e) {
            System.out.println("\u5bfc\u51fa\u5931\u8d25\uff01");
        }
    }

    public void autoExportPoliceRole() {
        List policeRoleList = this.policeRoleDao.searchForExport();
        if (policeRoleList != null && policeRoleList.size() > 0) {
            try {
                for (PoliceRole p : policeRoleList) {
                    p.setUpdateflag(Boolean.valueOf(false));
                    String policeRoleStr = JSONArray.toJSONString((Object)p);
                    System.out.println(policeRoleStr);
                    String content = CipherDESUtil.parseByte2HexStr((byte[])CipherDESUtil.encrypt((byte[])policeRoleStr.getBytes(), (String)Constants.APPROVAL_KEY));
                    this.writeTxtFile(content, "policerole");
                    List permissionList = this.permissionDao.findByRoleid(p.getId().toString());
                    if (permissionList != null && permissionList.size() > 0) {
                        String permissionListStr = JSONArray.toJSONString((Object)permissionList);
                        String permissionListcontent = CipherDESUtil.parseByte2HexStr((byte[])CipherDESUtil.encrypt((byte[])permissionListStr.getBytes(), (String)Constants.APPROVAL_KEY));
                        this.writeTxtFile(permissionListcontent, "permission");
                    }
                    this.policeRoleDao.updateFlag(p);
                }
            }
            catch (Exception e) {
                System.out.println("\u5bfc\u51fa\u5931\u8d25\uff01");
            }
        }
    }

    @Deprecated
    public void saveOrUpdateForImport(PoliceRole policeRole) {
        block7: {
            PoliceRole dbPoliceRole;
            block6: {
                policeRole.setUpdateflag(Boolean.valueOf(false));
                dbPoliceRole = this.policeRoleDao.findById(policeRole.getId().longValue());
                if (dbPoliceRole != null) break block6;
                policeRole.setUpdateTime(new Date());
                this.policeRoleDao.saveForDS(policeRole);
                List permissionlist = policeRole.getPermissionlist();
                this.permissionDao.deleteByRole(policeRole.getId(), "2");
                if (permissionlist != null && permissionlist.size() > 0) {
                    for (Permission permission : permissionlist) {
                        this.permissionDao.save(permission);
                    }
                }
                List dataAuthlist = policeRole.getDataAuthlist();
                this.dataAuthDao.deleteByRole(policeRole.getId());
                for (DataAuth dataAuth : dataAuthlist) {
                    this.dataAuthDao.save(dataAuth);
                }
                break block7;
            }
            if (policeRole.getUpdateTime().getTime() <= dbPoliceRole.getUpdateTime().getTime()) break block7;
            policeRole.setUpdateTime(new Date());
            this.policeRoleDao.update(policeRole);
            List permissionlist = policeRole.getPermissionlist();
            this.permissionDao.deleteByRole(policeRole.getId(), "2");
            if (permissionlist != null && permissionlist.size() > 0) {
                for (Permission permission : permissionlist) {
                    this.permissionDao.save(permission);
                }
            }
            List dataAuthlist = policeRole.getDataAuthlist();
            this.dataAuthDao.deleteByRole(policeRole.getId());
            Iterator iterator = dataAuthlist.iterator();
            while (iterator.hasNext()) {
                DataAuth dataAuth = (DataAuth)iterator.next();
                this.dataAuthDao.save(dataAuth);
            }
        }
    }

    public List<PoliceRole> searchForDataSynchronization(DataSynchronizationSearchDto searchDto) {
        return this.policeRoleDao.searchForDataSynchronization(searchDto);
    }

    public List<PoliceRole> findDSOutList(String startDate) {
        return this.policeRoleDao.searchFromInToOutForExport(startDate);
    }

    public void importBatch(List<PoliceRole> list) {
        List dbList = this.policeRoleDao.findByBatchId(list);
        list.removeAll(dbList);
        if (list.size() > 0) {
            for (PoliceRole detail : list) {
                detail.setUpdateflag(Boolean.valueOf(false));
                try {
                    detail.setUpdateTime(DateUtil.dateAdd((int)6, (Date)detail.getUpdateTime(), (int)1));
                }
                catch (Exception e) {
                    this.logger.error(e.getMessage(), (Throwable)e);
                }
                List permissionlist = detail.getPermissionlist();
                this.permissionDao.deleteByRole(detail.getId(), "2");
                if (permissionlist != null && permissionlist.size() > 0) {
                    this.permissionDao.saveBatch(permissionlist);
                }
                List dataAuthlist = detail.getDataAuthlist();
                this.dataAuthDao.deleteByRole(detail.getId());
                if (dataAuthlist == null || dataAuthlist.size() <= 0) continue;
                this.dataAuthDao.insertBatch(dataAuthlist);
            }
            this.policeRoleDao.saveBatch(list);
        }
    }

    public void searchForPage(RolePageSearchDto dto, AjaxPageResponse<PoliceRoleDto> page) {
        this.policeRoleDao.searchForPage(dto, page);
    }

    public void save(PoliceRole policeRole, String[] menuIds, String[] orgIds) {
        User currentUser = this.arsUtil.getCurrentUser();
        PoliceRole checkRole = this.findByOrgIdAndRoleName(policeRole.getOrgid(), policeRole.getRolename());
        if (policeRole.getId() == null) {
            if (checkRole != null) {
                throw new ArsException("\u8be5\u673a\u6784\u4e0b\uff0c\u5df2\u5b58\u5728\u6b64\u89d2\u8272\u540d\u79f0!");
            }
            policeRole.setId(Long.valueOf(this.idWorker.nextId()));
            policeRole.setActive(Boolean.valueOf(true));
            policeRole.setCreateTime(new Date());
            policeRole.setUpdateTime(new Date());
            policeRole.setCreaterorg(currentUser.getOrgName());
            policeRole.setUpdateBy(currentUser.getUsername());
            policeRole.setUpdateflag(Boolean.valueOf(true));
            this.policeRoleDao.save(policeRole);
        } else {
            if (checkRole != null && checkRole.getId().intValue() != policeRole.getId().intValue()) {
                throw new ArsException("\u8be5\u673a\u6784\u4e0b\uff0c\u5df2\u5b58\u5728\u6b64\u89d2\u8272\u540d\u79f0!");
            }
            PoliceRole dbPoliceRole = this.policeRoleDao.findById(policeRole.getId().longValue());
            dbPoliceRole.setUpdateBy(currentUser.getUsername());
            dbPoliceRole.setUpdateTime(new Date());
            BeanUtils.copyPropertiesIgnore((Object)policeRole, (Object)dbPoliceRole, (Boolean)true);
            dbPoliceRole.setUpdateflag(Boolean.valueOf(true));
            this.policeRoleDao.update(dbPoliceRole);
            this.modulePermissionDao.deleteByRoleId(policeRole.getId());
            this.dataAuthDao.deleteByRole(policeRole.getId());
        }
        if (menuIds != null && menuIds.length > 0) {
            List dbList = this.modulePermissionDao.findByRoleId(policeRole.getId());
            Map<Object, Object> dbMap = new HashMap();
            if (dbList.size() > 0) {
                dbMap = dbList.stream().collect(Collectors.toMap(ModulePermission::getModuleMenuId, Function.identity()));
            }
            ArrayList<ModulePermission> permissionList = new ArrayList<ModulePermission>();
            ModulePermission permission = null;
            for (String menuIdStr : menuIds) {
                Long menuId = Long.parseLong(menuIdStr);
                if (menuId <= 1L) continue;
                if (dbMap.get(menuId) != null) {
                    permission = (ModulePermission)dbMap.get(menuId);
                } else {
                    permission = new ModulePermission();
                    permission.setId(Long.valueOf(this.idWorker.nextId()));
                    permission.setActive(Boolean.valueOf(true));
                    permission.setCreateTime(new Date());
                    permission.setModuleMenuId(menuId);
                    permission.setRoleId(policeRole.getId());
                }
                permission.setActive(Boolean.valueOf(true));
                permission.setUpdateTime(new Date());
                permission.setUpdateflag(Boolean.valueOf(true));
                permission.setUpdateBy(currentUser.getUsername());
                permissionList.add(permission);
            }
            this.modulePermissionDao.saveBatch(permissionList);
        }
        if (orgIds != null && orgIds.length > 0) {
            ArrayList<DataAuth> dataAuthList = new ArrayList<DataAuth>();
            DataAuth auth = null;
            for (String orgIdStr : orgIds) {
                Long orgId = Long.parseLong(orgIdStr);
                auth = new DataAuth();
                auth.setId(Long.valueOf(this.idWorker.nextId()));
                auth.setActive(Boolean.valueOf(true));
                auth.setCreateTime(new Date());
                auth.setUpdateTime(new Date());
                auth.setUpdateBy(currentUser.getUsername());
                auth.setRoleid(policeRole.getId());
                auth.setOrgid(orgId);
                dataAuthList.add(auth);
            }
            this.dataAuthDao.insertBatch(dataAuthList);
        }
    }
}

