/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.ars.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.bcxin.ars.dao.ConfigDao;
import com.bcxin.ars.dao.InvoiceDao;
import com.bcxin.ars.dao.log.LogMessageDao;
import com.bcxin.ars.dto.AjaxResult;
import com.bcxin.ars.model.Config;
import com.bcxin.ars.model.Invoice;
import com.bcxin.ars.model.User;
import com.bcxin.ars.model.log.LogMessage;
import com.bcxin.ars.service.InvoiceService;
import com.bcxin.ars.service.impl.BaseService;
import com.bcxin.ars.service.util.IdGeneratorUtil;
import com.bcxin.ars.util.BeanUtils;
import com.bcxin.ars.util.Constants;
import com.bcxin.ars.util.HttpClientUtils;
import com.bcxin.ars.util.StringUtil;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service
public class InvoiceServiceImpl
extends BaseService
implements InvoiceService {
    private Logger logger = LoggerFactory.getLogger(InvoiceService.class);
    @Autowired
    private InvoiceDao invoiceDao;
    @Autowired
    private LogMessageDao logMessageDao;
    @Autowired
    private ConfigDao configDao;
    @Autowired
    private IdGeneratorUtil idGeneratorUtil;
    public static String IS_SUCCESS = "0";

    public void save(Invoice invoice) {
        this.invoiceDao.save(invoice);
    }

    public List<Invoice> getInvoiceList() {
        List lis = this.invoiceDao.getInvoiceList();
        return lis;
    }

    public Invoice getMsg(Long userid) {
        Invoice lis = this.invoiceDao.getMsg(userid);
        return lis;
    }

    public Invoice getMsgByUserName(String userName) {
        return this.invoiceDao.getMsgByUserName(userName);
    }

    public void update(Invoice invoice) {
        invoice.setUpdateTime(new Date());
        this.invoiceDao.update(invoice);
        this.sentToBTK(invoice);
    }

    private void sentToBTK(Invoice invoice) {
        Config config = this.configDao.findByKey("police");
        if (config != null && config.getValue() != null && !"1".equals(config.getValue())) {
            LogMessage logMessage = new LogMessage();
            HashMap<String, String> dataMap = new HashMap<String, String>();
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("bbdSynId", invoice.getId().toString());
            map.put("invoiceName", invoice.getCompanyname());
            map.put("taxPayerNo", invoice.getTaxnumber());
            map.put("bankName", invoice.getBank());
            map.put("bankCode", invoice.getBankaccount());
            map.put("registphone", invoice.getTel());
            map.put("registAddress", invoice.getRegister());
            map.put("mailAddress", invoice.getSendaddress());
            map.put("personCertificate", invoice.getTaxprove());
            map.put("businessLicense", invoice.getBusinesslicense());
            map.put("tax", invoice.getCertificate());
            dataMap.put("data", JSON.toJSONString(map));
            logMessage.setLogger_title("\u767e\u8bfe\u5802\u8d26\u5355\u540c\u6b65");
            logMessage.setCreateTime(new Date());
            try {
                String url;
                String btkRtn;
                Config configURL = this.configDao.findByKey("bkt_data_url");
                if (configURL != null && configURL.getValue() != null && (btkRtn = HttpClientUtils.doPost((String)(url = configURL.getValue() + "/train/order/invoice/update"), dataMap, (String)"utf-8")) != null) {
                    JSONObject jsonObject = JSONObject.parseObject((String)btkRtn);
                    String retType = jsonObject.get((Object)"retType").toString();
                    String data = jsonObject.get((Object)"data").toString();
                    if (!StringUtils.isEmpty((Object)retType) && Constants.BTK_IS_SUCCESS.equals(retType)) {
                        this.logger.info("\u767e\u8bfe\u5802\u8d26\u5355\u540c\u6b65\u6210\u529f");
                    } else {
                        this.logger.info("\u767e\u8bfe\u5802\u8d26\u5355\u540c\u6b65\u5931\u8d25");
                    }
                    if (!StringUtils.isEmpty((Object)data)) {
                        logMessage.setLogger_context(data);
                        this.logMessageDao.save(logMessage);
                    }
                }
            }
            catch (Exception e) {
                logMessage.setLogger_context(e.toString());
                this.logMessageDao.save(logMessage);
                this.logger.error(e.getMessage(), (Throwable)e);
            }
        }
    }

    public Invoice findById(Long id) {
        return this.invoiceDao.findById(id);
    }

    public AjaxResult saveOrUpdate(Invoice invoice, User user) {
        Invoice dbInvoice;
        AjaxResult ajaxResult = new AjaxResult();
        if (StringUtil.isNotEmpty((String)invoice.getCertificate())) {
            invoice.setCertificate(this.getPhotoPath(invoice.getCertificate()));
        }
        if (StringUtil.isNotEmpty((String)invoice.getBusinesslicense())) {
            invoice.setBusinesslicense(this.getPhotoPath(invoice.getBusinesslicense()));
        }
        if (StringUtil.isNotEmpty((String)invoice.getLicence())) {
            invoice.setLicence(this.getPhotoPath(invoice.getLicence()));
        }
        boolean IsNull = true;
        if (invoice.getId() != null && (dbInvoice = this.invoiceDao.findById(invoice.getId())) != null) {
            IsNull = false;
            dbInvoice.setUpdateTime(new Date());
            dbInvoice.setUpdateBy(user.getUsername());
            BeanUtils.copyPropertiesIgnore((Object)invoice, (Object)dbInvoice, (Boolean)true);
            this.invoiceDao.update(dbInvoice);
        }
        if (invoice.getId() == null || IsNull) {
            invoice.setCreateTime(new Date());
            invoice.setUpdateTime(new Date());
            invoice.setUserid(user.getId());
            invoice.setUpdateBy(user.getUsername());
            if (invoice.getId() == null) {
                invoice.setId(Long.valueOf(this.idGeneratorUtil.createID()));
            }
            this.invoiceDao.saveById(invoice);
        }
        return ajaxResult;
    }
}

