/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.ars.service.impl;

import com.bcxin.ars.dao.CyAssociationDao;
import com.bcxin.ars.dto.DataSynchronizationSearchDto;
import com.bcxin.ars.dto.SearchDto;
import com.bcxin.ars.dto.page.CyAssociationPageSearchDto;
import com.bcxin.ars.model.CyAssociation;
import com.bcxin.ars.model.User;
import com.bcxin.ars.service.CyAssociationService;
import com.bcxin.ars.service.util.ArsUtil;
import com.bcxin.ars.service.util.ConfigUtils;
import com.bcxin.ars.util.BeanUtils;
import com.bcxin.ars.util.BuildWebServiceEntity;
import com.bcxin.ars.util.DateUtil;
import com.bcxin.ars.webservice.Baxhxx;
import com.bcxin.ars.webservice.ClientUtil;
import com.com.bcxin.ars.com.abcxin.smart.core.web.validate.AjaxPageResponse;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class CyAssociationServiceImpl
implements CyAssociationService {
    Logger logger = LoggerFactory.getLogger(CyAssociationServiceImpl.class);
    @Autowired
    private CyAssociationDao cyAssociationDao;
    @Autowired
    private ConfigUtils configUtils;
    @Autowired
    private ArsUtil arsUtil;
    @Autowired
    private ClientUtil clientUtil;

    public int delete(CyAssociation cyAssociation) {
        User currentUser = this.arsUtil.getCurrentUser();
        cyAssociation.setUpdateTime(new Date());
        cyAssociation.setUpdateBy(currentUser.getUsername());
        return this.cyAssociationDao.delete(cyAssociation);
    }

    public int save(CyAssociation cyAssociation) {
        User currentUser = this.arsUtil.getCurrentUser();
        if (cyAssociation.getId() == null) {
            cyAssociation.setCreateTime(new Date());
            new Thread(() -> {
                try {
                    String[] srccol = new String[]{"name", "hzName", "phone", "address"};
                    String[] desccol = new String[]{"baxhmc", "hzxm", "hzdh", "xhxz"};
                    String[] key = new String[]{};
                    String[] value = new String[]{};
                    Object desc = BuildWebServiceEntity.buildWebServiceEntity((String[])srccol, (String[])desccol, (Object)cyAssociation, (Object)new Baxhxx(), (String[])key, (String[])value);
                    Baxhxx baxhxx = (Baxhxx)desc;
                    this.clientUtil.send("xxba_baxhxx", (Object)baxhxx);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }).start();
        } else {
            CyAssociation dbCyAssociation = this.cyAssociationDao.findById(cyAssociation.getId());
            BeanUtils.copyPropertiesIgnore((Object)cyAssociation, (Object)dbCyAssociation, (Boolean)true);
            BeanUtils.copyPropertiesIgnore((Object)dbCyAssociation, (Object)cyAssociation, (Boolean)false);
        }
        cyAssociation.setUserId(currentUser.getId());
        cyAssociation.setActive(Boolean.valueOf(true));
        cyAssociation.setUpdateBy(currentUser.getUsername());
        cyAssociation.setUpdateTime(new Date());
        cyAssociation.setUpdateflag(Boolean.valueOf(true));
        cyAssociation.setAreaCode(currentUser.getPolice().getAreacode());
        return this.cyAssociationDao.save(cyAssociation);
    }

    public CyAssociation findById(Long id) {
        return this.cyAssociationDao.findById(id);
    }

    public void searchForPage(CyAssociationPageSearchDto dto, AjaxPageResponse page) {
        this.arsUtil.setPoliceSearch((SearchDto)dto);
        this.cyAssociationDao.searchForPage(dto, page);
    }

    public void importBatch(List<CyAssociation> list) {
        List dbList = this.cyAssociationDao.findByBatchId(list);
        list.removeAll(dbList);
        if (list.size() > 0) {
            for (CyAssociation cyAssociation : list) {
                cyAssociation.setUpdateflag(Boolean.valueOf(false));
                try {
                    if (this.configUtils.isIntranet()) continue;
                    cyAssociation.setUpdateTime(DateUtil.dateAdd((int)6, (Date)cyAssociation.getUpdateTime(), (int)1));
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            this.cyAssociationDao.saveBatch(list);
        }
    }

    public List<CyAssociation> searchForDataSynchronization(DataSynchronizationSearchDto dto) {
        return this.cyAssociationDao.searchForDataSynchronization(dto);
    }

    public List<CyAssociation> findDSOutList(String startDate) {
        return this.cyAssociationDao.findDSOutList(startDate);
    }

    public List<CyAssociation> findByBatchId(List<CyAssociation> list) {
        return this.cyAssociationDao.findByBatchId(list);
    }

    public void updateSelective(CyAssociation cyAssociation) {
        User currentUser = this.arsUtil.getCurrentUser();
        cyAssociation.setUpdateTime(new Date());
        cyAssociation.setUpdateBy(currentUser.getUsername());
        this.cyAssociationDao.updateSelective(cyAssociation);
    }
}

