/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.ars.service.datasync.impl;

import com.alibaba.fastjson.JSON;
import com.bcxin.ars.dao.datasync.DataSyncLogDao;
import com.bcxin.ars.dto.DataSynchronizationSearchDto;
import com.bcxin.ars.dto.SearchDto;
import com.bcxin.ars.dto.datasync.DataSyncDto;
import com.bcxin.ars.dto.page.DataSyncLogPageSearchDto;
import com.bcxin.ars.exception.ArsException;
import com.bcxin.ars.model.User;
import com.bcxin.ars.model.datasync.DataSyncLog;
import com.bcxin.ars.service.datasync.DataSyncLogService;
import com.bcxin.ars.service.util.ArsUtil;
import com.bcxin.ars.service.util.ConfigUtils;
import com.bcxin.ars.util.BeanUtils;
import com.bcxin.ars.util.DateUtil;
import com.bcxin.ars.util.FileUtil;
import com.com.bcxin.ars.com.abcxin.smart.core.web.validate.AjaxPageResponse;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class DataSyncLogServiceImpl
implements DataSyncLogService {
    Logger logger = LoggerFactory.getLogger(DataSyncLogServiceImpl.class);
    @Autowired
    private DataSyncLogDao dataSyncLogDao;
    @Autowired
    private ConfigUtils configUtils;
    @Autowired
    private ArsUtil arsUtil;

    public int delete(DataSyncLog dataSyncLog) {
        User currentUser = this.arsUtil.getCurrentUser();
        dataSyncLog.setUpdateTime(new Date());
        dataSyncLog.setUpdateBy(currentUser.getUsername());
        return this.dataSyncLogDao.delete(dataSyncLog);
    }

    public int save(DataSyncLog dataSyncLog) {
        if (dataSyncLog.getId() == null) {
            dataSyncLog.setCreateTime(new Date());
        } else {
            DataSyncLog dbDataSyncLog = this.dataSyncLogDao.findById(dataSyncLog.getId());
            BeanUtils.copyPropertiesIgnore((Object)dataSyncLog, (Object)dbDataSyncLog, (Boolean)true);
            BeanUtils.copyPropertiesIgnore((Object)dbDataSyncLog, (Object)dataSyncLog, (Boolean)false);
        }
        dataSyncLog.setActive(Boolean.valueOf(true));
        dataSyncLog.setUpdateTime(new Date());
        dataSyncLog.setUpdateflag(Boolean.valueOf(true));
        return this.dataSyncLogDao.save(dataSyncLog);
    }

    public void callback(DataSyncLog dataSyncLog) {
        DataSyncLog dbDataSyncLog = this.dataSyncLogDao.findByMsgId(dataSyncLog.getMsgId());
        if (dbDataSyncLog != null) {
            dbDataSyncLog.setActive(Boolean.valueOf(true));
            dbDataSyncLog.setUpdateTime(new Date());
            dbDataSyncLog.setUpdateflag(Boolean.valueOf(true));
            this.dataSyncLogDao.save(dbDataSyncLog);
        }
    }

    public void receive(DataSyncDto dataSyncDto) throws Exception {
        DataSyncLog dataSyncLog = (DataSyncLog)JSON.parseObject((String)dataSyncDto.getData(), DataSyncLog.class);
        try {
            FileUtil.downloadFile((String)dataSyncDto.getFilePaths(), (String)dataSyncLog.getFilePath().replace(dataSyncLog.getBasePath(), this.configUtils.baseFolder));
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new ArsException("\u6587\u4ef6\u4e0d\u5b58\u5728\uff1a" + dataSyncDto.getFilePaths());
        }
        dataSyncLog.setDataSyncState("1");
        dataSyncLog.setErrorInfo(null);
        dataSyncLog.setUpdateTime(new Date());
        this.dataSyncLogDao.save(dataSyncLog);
    }

    public DataSyncLog findById(Long id) {
        return this.dataSyncLogDao.findById(id);
    }

    public void searchForPage(DataSyncLogPageSearchDto dto, AjaxPageResponse page) {
        this.arsUtil.setPoliceSearch((SearchDto)dto);
        this.dataSyncLogDao.searchForPage(dto, page);
    }

    public void importBatch(List<DataSyncLog> list) {
        List dbList = this.dataSyncLogDao.findByBatchId(list);
        list.removeAll(dbList);
        if (list.size() > 0) {
            for (DataSyncLog dataSyncLog : list) {
                dataSyncLog.setUpdateflag(Boolean.valueOf(false));
                try {
                    if (this.configUtils.isIntranet()) continue;
                    dataSyncLog.setUpdateTime(DateUtil.dateAdd((int)6, (Date)dataSyncLog.getUpdateTime(), (int)1));
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            this.dataSyncLogDao.saveBatch(list);
        }
    }

    public List<DataSyncLog> searchForDataSynchronization(DataSynchronizationSearchDto dto) {
        return this.dataSyncLogDao.searchForDataSynchronization(dto);
    }

    public List<DataSyncLog> findDSOutList(String startDate) {
        return this.dataSyncLogDao.findDSOutList(startDate);
    }

    public List<DataSyncLog> findByBatchId(List<DataSyncLog> list) {
        return this.dataSyncLogDao.findByBatchId(list);
    }

    public void updateSelective(DataSyncLog dataSyncLog) {
        dataSyncLog.setUpdateTime(new Date());
        this.dataSyncLogDao.updateSelective(dataSyncLog);
    }
}

