/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.ars.service.conference.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.bcxin.ars.dao.UserDao;
import com.bcxin.ars.dao.conference.CloudConferenceDao;
import com.bcxin.ars.dao.conference.ConferenceAccountDao;
import com.bcxin.ars.dao.conference.ConferenceMemberDao;
import com.bcxin.ars.dao.sys.MessageLogDao;
import com.bcxin.ars.dto.AjaxResult;
import com.bcxin.ars.dto.SearchDto;
import com.bcxin.ars.dto.conference.ComAccountZTree;
import com.bcxin.ars.dto.conference.ConferenceDetail;
import com.bcxin.ars.dto.conference.ConferenceInfo;
import com.bcxin.ars.dto.conference.ConferenceMemberDto;
import com.bcxin.ars.dto.conference.ConferenceSearchDto;
import com.bcxin.ars.dto.conference.HuaWeiConference;
import com.bcxin.ars.dto.conference.PageConferenceInfo;
import com.bcxin.ars.dto.conference.PageRecordFile;
import com.bcxin.ars.dto.conference.PasswordEntry;
import com.bcxin.ars.dto.conference.RecordDto;
import com.bcxin.ars.dto.conference.RecordFileInfo;
import com.bcxin.ars.exception.ArsException;
import com.bcxin.ars.model.User;
import com.bcxin.ars.model.conference.CloudConference;
import com.bcxin.ars.model.conference.ConferenceAccount;
import com.bcxin.ars.model.conference.ConferenceMember;
import com.bcxin.ars.service.conference.CloudConferenceService;
import com.bcxin.ars.service.util.ArsUtil;
import com.bcxin.ars.service.util.HuaweiMeetUtil;
import com.bcxin.ars.util.DateUtil;
import com.bcxin.ars.util.MessageUtil;
import com.bcxin.ars.util.StringUtil;
import com.com.bcxin.ars.com.abcxin.smart.core.web.validate.AjaxPageResponse;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.collections.map.HashedMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class CloudConferenceServiceImpl
implements CloudConferenceService {
    public static final Logger logger = LoggerFactory.getLogger(CloudConferenceServiceImpl.class);
    @Autowired
    private UserDao userDao;
    @Autowired
    private CloudConferenceDao cloudConferenceDao;
    @Autowired
    private ConferenceAccountDao conferenceAccountDao;
    @Autowired
    private ConferenceMemberDao conferenceMemberDao;
    @Autowired
    private MessageLogDao messageLogDao;
    @Autowired
    private HuaweiMeetUtil huaweiMeetUtil;
    @Autowired
    private ArsUtil arsUtil;

    public void searchForPage(ConferenceSearchDto searchDto, AjaxPageResponse page) {
        User currentUser = this.arsUtil.getCurrentUser();
        this.arsUtil.setPoliceSearch((SearchDto)searchDto);
        searchDto.setUserId(currentUser.getId());
        this.cloudConferenceDao.searchForPage(searchDto, page);
    }

    public void queryRecordList(RecordDto recordDto, AjaxPageResponse page) throws Exception {
        HashedMap paramMap = new HashedMap();
        User user = this.arsUtil.getCurrentUser();
        ConferenceAccount conferenceAccount = this.conferenceAccountDao.selectByUserId(user.getId());
        if (conferenceAccount == null) {
            return;
        }
        paramMap.put("userUUID", conferenceAccount.getHuaweiUserId());
        paramMap.put("searchKey", recordDto.getSearchKey());
        paramMap.put("offset", String.valueOf((page.getPageNumber() - 1) * page.getPageSize()));
        paramMap.put("limit", String.valueOf(page.getPageSize()));
        paramMap.put("queryAll", "true");
        try {
            if (recordDto.getStartDate() == null) {
                recordDto.setStartDate(DateUtil.dateAdd((int)2, (Date)new Date(), (int)-1));
            }
            if (recordDto.getEndDate() == null) {
                recordDto.setEndDate(new Date());
            }
        }
        catch (Exception e) {
            logger.error("\u8fdb\u5165\u5f55\u64ad\u6587\u4ef6\u5217\u8868\u5f00\u59cb\u65e5\u671f\u548c\u7ed3\u675f\u65e5\u671f\u8f6c\u6362\u6210\u65f6\u95f4\u6233\u9519\u8bef");
            throw new ArsException("\u9884\u7ea6\u5f00\u59cb\u65f6\u95f4\u5fc5\u987b\u5927\u4e8e\u5f53\u524d\u65f6\u95f4\uff01");
        }
        recordDto.setEndDate(DateUtil.convertStringToDate((String)(DateUtil.convertDateToString((Date)recordDto.getEndDate(), (String)"yyyy-MM-dd") + " 23:59:59")));
        paramMap.put("startDate", String.valueOf(recordDto.getStartDate().getTime()));
        paramMap.put("endDate", String.valueOf(recordDto.getEndDate().getTime()));
        paramMap.put("sortType", "DSC_StartTIME");
        AjaxResult ajaxResult = this.huaweiMeetUtil.callInterfaceV2Record("GET", "/v1/mmc/management/record/files", (Map<String, String>)paramMap, conferenceAccount);
        if (ajaxResult.isSuccessful()) {
            PageRecordFile pageRecordFile = (PageRecordFile)ajaxResult.getData();
            page.setData(pageRecordFile.getData());
            page.setTotal(pageRecordFile.getCount().longValue());
            for (RecordFileInfo recordFileInfo : pageRecordFile.getData()) {
                if (recordFileInfo.getDecodeEndTime() != null) {
                    recordFileInfo.setDecodeEndTimeFinish(new Date(recordFileInfo.getDecodeEndTime()));
                }
                if (recordFileInfo.getStartTime() == null) continue;
                recordFileInfo.setStartTime(DateUtil.utcToLocal((String)(recordFileInfo.getStartTime() + ":00"), (String)"yyyy-MM-dd HH:mm"));
            }
        } else {
            throw new ArsException("\u5f55\u64ad\u5217\u8868\u67e5\u8be2\u5931\u8d25");
        }
    }

    public AjaxResult batchDeleteRecord(String[] confUUIDs) {
        String confUUIDSString = Arrays.toString(confUUIDs);
        confUUIDSString = confUUIDSString.substring(1, confUUIDSString.length() - 1);
        HashedMap paramMap = new HashedMap();
        paramMap.put("confUUIDs", confUUIDSString);
        AjaxResult result = this.huaweiMeetUtil.callInterfaceV1ReDe("DELETE", "/v1/mmc/management/record/files", (Map<String, String>)paramMap);
        return result;
    }

    public CloudConference save(CloudConference conference) {
        if (conference.getSubscribe().booleanValue()) {
            if (System.currentTimeMillis() > DateUtil.parseDate((String)(conference.getStartTime() + ":00"))) {
                throw new ArsException("\u9884\u7ea6\u5f00\u59cb\u65f6\u95f4\u5fc5\u987b\u5927\u4e8e\u5f53\u524d\u65f6\u95f4\uff01");
            }
            if (conference.getDuration() < 14 || conference.getDuration() > 1440) {
                throw new ArsException("\u4f1a\u8bae\u65f6\u957f\u5fc5\u987b\u572815\u5206\u949f\u52301440\u5206\u949f\u4e4b\u95f4\uff01");
            }
        }
        User currentUser = this.arsUtil.getCurrentUser();
        conference.setCreateTime(new Date());
        conference.setUpdateBy(currentUser.getUsername());
        conference.setUserid(currentUser.getId());
        conference.setActive(Boolean.valueOf(true));
        conference.setUpdateTime(new Date());
        conference.setUserid(currentUser.getId());
        this.setConferenceMembers(conference);
        AjaxResult result = this.saveHuaweiConference(conference);
        if (result.isSuccessful()) {
            ConferenceInfo conferenceInfo = (ConferenceInfo)result.getData();
            conference.setMeetId(conferenceInfo.getConferenceID());
            conference.setConfUUID(conferenceInfo.getConfUUID());
            conference.setAccessNumber(conferenceInfo.getAccessNumber());
            if ("Schedule".equals(conferenceInfo.getConferenceState())) {
                conference.setState("2");
            } else {
                conference.setState("1");
            }
            conference.setStartTime(DateUtil.utcToLocal((String)(conferenceInfo.getStartTime() + ":00"), (String)"yyyy-MM-dd HH:mm"));
            conference.setEndTime(DateUtil.utcToLocal((String)(conferenceInfo.getEndTime() + ":00"), (String)"yyyy-MM-dd HH:mm"));
            List passwords = conferenceInfo.getPasswordEntry();
            if (passwords != null && passwords.size() > 0) {
                for (PasswordEntry password : passwords) {
                    if (password.getConferenceRole().equals("chair")) {
                        conference.setChairPwd(password.getPassword());
                    }
                    if (!password.getConferenceRole().equals("general")) continue;
                    conference.setGeneralPwd(password.getPassword());
                }
            }
        } else {
            throw new ArsException("\u4f1a\u8bae\u521b\u5efa\u5931\u8d25");
        }
        conference.setChairman("1");
        this.cloudConferenceDao.insert(conference);
        this.savePoliceMembers(conference);
        this.noticeUser(conference);
        return conference;
    }

    public CloudConference findById(Long id) {
        return this.cloudConferenceDao.findById(id);
    }

    public void endConference(CloudConference conference) {
        if (StringUtil.isNotEmpty((String)conference.getConfUUID())) {
            AjaxResult result = this.huaweiMeetUtil.callInterface("GET", "/historyConferences/{confuuid}".replace("{confuuid}", conference.getConfUUID()), null, (Map<String, Object>)new HashedMap(), true);
            ConferenceDetail detail = (ConferenceDetail)JSON.parseObject((String)JSON.toJSONString((Object)result.getData()), ConferenceDetail.class);
            if (detail != null) {
                try {
                    conference.setEndTime(DateUtil.utcToLocal((String)(detail.getConferenceData().getEndTime() + ":00"), (String)"yyyy-MM-dd HH:mm"));
                    conference.setState("3");
                    conference.setUpdateTime(new Date());
                    this.cloudConferenceDao.updateState(conference);
                }
                catch (Exception e) {
                    logger.error(e.getMessage(), (Throwable)e);
                }
            }
        } else {
            RecordDto recordDto = new RecordDto();
            try {
                List list;
                recordDto.setStartDate(DateUtil.dateAdd((int)2, (Date)new Date(), (int)-1));
                recordDto.setEndDate(new Date());
                recordDto.setEndDate(DateUtil.convertStringToDate((String)(DateUtil.convertDateToString((Date)recordDto.getEndDate(), (String)"yyyy-MM-dd") + " 23:59:59")));
                HashedMap paramMap = new HashedMap();
                paramMap.put("startDate", String.valueOf(recordDto.getStartDate().getTime()));
                paramMap.put("endDate", String.valueOf(recordDto.getEndDate().getTime()));
                paramMap.put("searchKey", conference.getMeetId());
                paramMap.put("queryAll", "true");
                AjaxResult result = this.huaweiMeetUtil.callInterfaceV1History("GET", "/v1/mmc/management/conferences/history", (Map<String, String>)paramMap);
                if (result.getData() != null && (list = (List)result.getData()) != null && list.size() > 0) {
                    list.forEach(conferenceInfo -> {
                        if (conferenceInfo.getConferenceID().equals(conference.getMeetId())) {
                            try {
                                conference.setEndTime(DateUtil.utcToLocal((String)(conferenceInfo.getEndTime() + ":00"), (String)"yyyy-MM-dd HH:mm"));
                                conference.setState("3");
                                conference.setUpdateTime(new Date());
                                this.cloudConferenceDao.updateState(conference);
                            }
                            catch (Exception e) {
                                logger.error(e.getMessage(), (Throwable)e);
                            }
                        }
                    });
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void end(String meetId) {
        CloudConference conference = this.cloudConferenceDao.findByMeetId(meetId);
        if (conference != null) {
            try {
                Thread.sleep(2000L);
            }
            catch (InterruptedException e) {
                logger.error(e.getMessage(), (Throwable)e);
                Thread.currentThread().interrupt();
            }
            this.endConference(conference);
        }
    }

    public void getConfUUID(String meetId) {
        try {
            Thread.sleep(2000L);
        }
        catch (InterruptedException e) {
            logger.error(e.getMessage(), (Throwable)e);
            Thread.currentThread().interrupt();
        }
        CloudConference conference = this.cloudConferenceDao.findByMeetId(meetId);
        if (conference != null && StringUtil.isEmpty((String)conference.getConfUUID())) {
            HuaWeiConference huaWeiConference;
            PageConferenceInfo detail;
            List huaWeiConferenceList;
            Object conferenceMap = new HashedMap();
            HashedMap paramMap = new HashedMap();
            AjaxResult result = this.huaweiMeetUtil.callInterface("GET", "/conferences", null, (Map<String, Object>)paramMap, true);
            if (result.isSuccessful() && (huaWeiConferenceList = (detail = (PageConferenceInfo)JSONObject.parseObject((String)JSON.toJSONString((Object)result.getData()), PageConferenceInfo.class)).getData()) != null && huaWeiConferenceList.size() > 0) {
                huaWeiConferenceList.stream();
                conferenceMap = huaWeiConferenceList.stream().collect(Collectors.toMap(HuaWeiConference::getConferenceID, Function.identity()));
            }
            if ((huaWeiConference = (HuaWeiConference)conferenceMap.get(conference.getMeetId())) != null) {
                conference.setEndTime(huaWeiConference.getEndTime());
                if (StringUtil.isEmpty((String)conference.getConfUUID())) {
                    conference.setConfUUID(huaWeiConference.getConfUUID());
                }
                if ("Schedule".equals(huaWeiConference.getConferenceState())) {
                    conference.setState("2");
                } else if ("Created".equals(huaWeiConference.getConferenceState())) {
                    conference.setState("1");
                } else {
                    conference.setState("3");
                }
                conference.setUpdateTime(new Date());
                this.cloudConferenceDao.updateState(conference);
            }
        }
    }

    public void saveAccountMembers(CloudConference conference) {
        CloudConference dbConference = this.cloudConferenceDao.findById(conference.getId());
        dbConference.setPoliceMembers(conference.getPoliceMembers());
        dbConference.setComMembers(conference.getComMembers());
        this.setConferenceMembers(dbConference);
        AjaxResult result = this.addHuaweiAttendees(dbConference);
        if (!result.isSuccessful()) {
            throw new ArsException("\u9080\u8bf7\u4e0e\u4f1a\u8005\u5931\u8d25:" + result.getMsg());
        }
        this.savePoliceMembers(dbConference);
        new Thread(() -> this.noticeUser(dbConference)).start();
    }

    private void setConferenceMembers(CloudConference conference) {
        ArrayList<ConferenceMemberDto> list = new ArrayList<ConferenceMemberDto>();
        ArrayList<ConferenceMember> policeMemberList = new ArrayList<ConferenceMember>();
        ConferenceMemberDto member = null;
        ConferenceMember policeMember = null;
        if (StringUtil.isNotEmpty((String)conference.getPoliceMembers())) {
            String[] policeMembers = conference.getPoliceMembers().split(",");
            for (String userId : policeMembers) {
                if (userId.equals(conference.getUserid().toString())) continue;
                ConferenceAccount conferenceAccount = this.conferenceAccountDao.selectByUserId(Long.valueOf(Long.parseLong(userId)));
                User user = this.userDao.findById(Long.valueOf(Long.parseLong(userId)));
                member = new ConferenceMemberDto();
                member.setAccountId(conferenceAccount.getAccount());
                member.setName(user.getRealname());
                member.setPhone(conferenceAccount.getHuaweiSipName());
                member.setRole("0");
                member.setSms(user.getPhone());
                member.setUserUUID(conferenceAccount.getHuaweiUserId());
                policeMember = new ConferenceMember();
                policeMember.setConferenceId(conference.getId());
                policeMember.setAccountId(conferenceAccount.getId());
                policeMember.setConferenceRole("0");
                policeMember.setName(user.getRealname());
                policeMember.setMute(Boolean.valueOf(false));
                policeMember.setActive(Boolean.valueOf(true));
                policeMember.setCreateTime(new Date());
                policeMember.setUpdateTime(new Date());
                policeMember.setUserid(user.getId());
                list.add(member);
                policeMemberList.add(policeMember);
            }
        }
        if (StringUtil.isNotEmpty((String)conference.getComMembers())) {
            List trees = JSONArray.parseArray((String)conference.getComMembers(), ComAccountZTree.class);
            for (ComAccountZTree accountZTree : trees) {
                member = new ConferenceMemberDto();
                member.setName(accountZTree.getLabel());
                member.setPhone(accountZTree.getHuaweiSipName());
                member.setRole("0");
                member.setSms(accountZTree.getMobilePhone());
                list.add(member);
            }
        }
        conference.setAttendees(list);
        conference.setPoliceAccounts(policeMemberList);
    }

    private void noticeUser(CloudConference conference) {
        String[] generalParams = new String[]{conference.getTheme(), conference.getStartTime(), conference.getMeetId(), conference.getGeneralPwd(), conference.getMeetId()};
        String[] chairParams = new String[]{conference.getTheme(), conference.getStartTime(), conference.getMeetId(), conference.getGeneralPwd(), conference.getChairPwd(), conference.getMeetId()};
        for (ConferenceMemberDto member : conference.getAttendees()) {
            if ("0".equals(member.getRole())) {
                MessageUtil.sendMessageHuaWei((String)member.getSms(), (String)"B81", (MessageLogDao)this.messageLogDao, (String[])generalParams, (String)"B81");
                continue;
            }
            if (!"1".equals(member.getRole())) continue;
            MessageUtil.sendMessageHuaWei((String)member.getSms(), (String)"B82", (MessageLogDao)this.messageLogDao, (String[])chairParams, (String)"B82");
        }
    }

    private void savePoliceMembers(CloudConference conference) {
        if (conference.getPoliceAccounts() != null && conference.getPoliceAccounts().size() > 0) {
            for (ConferenceMember member : conference.getPoliceAccounts()) {
                member.setConferenceId(conference.getId());
                this.conferenceMemberDao.insert(member);
            }
        }
    }

    private AjaxResult saveHuaweiConference(CloudConference conference) {
        ArrayList<ConferenceMember> policeAccounts;
        ArrayList<ConferenceMemberDto> attendees = conference.getAttendees();
        if (attendees == null) {
            attendees = new ArrayList<ConferenceMemberDto>();
        }
        if ((policeAccounts = conference.getPoliceAccounts()) == null) {
            policeAccounts = new ArrayList<ConferenceMember>();
        }
        User currentUser = this.arsUtil.getCurrentUser();
        ConferenceAccount account = this.arsUtil.getConferenceAccount();
        HashedMap paramMap = new HashedMap();
        paramMap.put("subject", conference.getTheme());
        paramMap.put("isAutoRecord", conference.getAutoRecord());
        paramMap.put("recordAuthType", "0");
        if ("1".equals(conference.getAutoRecord())) {
            paramMap.put("recordType", "2");
        }
        if ("2".equals(conference.getConferenceModel())) {
            paramMap.put("vmrFlag", "1");
            paramMap.put("vmrID", conference.getVmrID());
        } else {
            paramMap.put("vmrFlag", "0");
            conference.setVmrID(null);
        }
        paramMap.put("timeZoneID", "56");
        JSONObject confConfigInfo = new JSONObject();
        confConfigInfo.put("isSendNotify", (Object)"False");
        confConfigInfo.put("isSendSms", (Object)"False");
        paramMap.put("confConfigInfo", confConfigInfo);
        if (!conference.getSubscribe().booleanValue()) {
            paramMap.put("startTime", "");
        } else {
            paramMap.put("startTime", DateUtil.localToUTC((String)(conference.getStartTime() + ":00"), (String)"yyyy-MM-dd HH:mm"));
        }
        if (conference.getSubscribe().booleanValue()) {
            paramMap.put("length", conference.getDuration());
        }
        String mediaType = "Video";
        if (conference.getType().equals("0")) {
            mediaType = "Voice";
        } else if (conference.getType().equals("1") && conference.getHd().booleanValue()) {
            mediaType = "HDVideo";
        }
        paramMap.put("mediaTypes", mediaType);
        paramMap.put("encryptMode", 0);
        paramMap.put("recordAuxStream", 0);
        ConferenceMemberDto member = new ConferenceMemberDto();
        member.setPhone(account.getHuaweiSipName());
        member.setSms(currentUser.getPhone());
        member.setName(currentUser.getRealname());
        member.setAccountId(account.getAccount());
        member.setUserUUID(account.getHuaweiUserId());
        member.setRole("1");
        attendees.add(member);
        ConferenceMember policeMember = new ConferenceMember();
        policeMember.setConferenceId(conference.getId());
        policeMember.setAccountId(account.getId());
        policeMember.setConferenceRole("1");
        policeMember.setName(currentUser.getRealname());
        policeMember.setMute(Boolean.valueOf(false));
        policeMember.setActive(Boolean.valueOf(true));
        policeMember.setCreateTime(new Date());
        policeMember.setUpdateTime(new Date());
        policeMember.setUserid(currentUser.getId());
        policeAccounts.add(policeMember);
        paramMap.put("attendees", JSONArray.toJSON(attendees));
        if ("2".equals(conference.getConferenceModel())) {
            return this.huaweiMeetUtil.callInterfaceCloudV1("POST", "/v1/mmc/management/conferences", null, (Map<String, Object>)paramMap);
        }
        return this.huaweiMeetUtil.callInterfaceV1("POST", "/v1/mmc/management/conferences", null, (Map<String, Object>)paramMap, false);
    }

    private AjaxResult addHuaweiAttendees(CloudConference conference) {
        String ctrlTokenUrl = "/conferences/{conferenceid}/token".replace("{conferenceid}", conference.getMeetId());
        HashMap<String, String> headMap = new HashMap<String, String>();
        headMap.put("password", conference.getChairPwd());
        headMap.put("loginType", "1");
        AjaxResult result = this.huaweiMeetUtil.callInterface("GET", ctrlTokenUrl, headMap, new HashMap<String, Object>(), true);
        if (result.isSuccessful()) {
            JSONObject json = JSON.parseObject((String)JSON.toJSONString((Object)result.getData()));
            String token = json.get((Object)"token").toString();
            String authorization = Base64.getEncoder().encodeToString(token.getBytes());
            headMap = new HashMap();
            headMap.put("Conference-Authorization", "Basic " + authorization);
            String url = "/conferences/{conferenceid}/participants".replace("{conferenceid}", conference.getMeetId());
            HashedMap paramMap = new HashedMap();
            paramMap.put("attendees", JSONArray.toJSON((Object)conference.getAttendees()));
            return this.huaweiMeetUtil.callInterface("POST", url, headMap, (Map<String, Object>)paramMap, true);
        }
        return result;
    }

    public CloudConference saveCloudecReleaseChairman(CloudConference conference) {
        CloudConference dbconference = this.cloudConferenceDao.findById(conference.getId());
        if ("1".equals(conference.getChairman()) && "1".equals(dbconference.getChairman())) {
            throw new ArsException("\u4e3b\u5e2d\u5df2\u7ecf\u88ab\u7533\u8bf7\uff0c\u4e0d\u80fd\u518d\u8fdb\u884c\u7533\u8bf7\uff01");
        }
        conference.setChairman(conference.getChairman());
        conference.setUpdateTime(new Date());
        this.cloudConferenceDao.updateChairmanState(conference);
        User currentUser = this.arsUtil.getCurrentUser();
        ConferenceMember conferenceMember = new ConferenceMember();
        conferenceMember.setUpdateTime(new Date());
        conferenceMember.setUserid(currentUser.getId());
        conferenceMember.setConferenceId(conference.getId());
        conferenceMember.setConferenceRole(conference.getChairman());
        this.conferenceMemberDao.updateChairmanState(conferenceMember);
        return conference;
    }
}

