/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.ars.service.appeal.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.bcxin.ars.dao.sb.PersonAdaptDao;
import com.bcxin.ars.dto.AjaxResult;
import com.bcxin.ars.exception.ArsException;
import com.bcxin.ars.model.appeal.Appeal;
import com.bcxin.ars.model.sb.PersonAdapt;
import com.bcxin.ars.service.appeal.AppealHandle;
import com.bcxin.ars.service.util.BKTInterfaceUtil;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class AdaptAppealHandle
implements AppealHandle {
    @Autowired
    private PersonAdaptDao personAdaptDao;
    @Autowired
    private BKTInterfaceUtil bktInterfaceUtil;

    public void handle(Appeal appeal) {
        PersonAdapt personAdapt = this.personAdaptDao.findById(appeal.getBusinessid());
        if ("003".equals(appeal.getAppealState())) {
            personAdapt.setApprovalState("0");
            personAdapt.setCensorStatus("1");
            personAdapt.setApprovalReason(null);
            personAdapt.setUpdateTime(new Date());
        } else if ("004".equals(appeal.getAppealState())) {
            personAdapt.setApprovalState("2");
            personAdapt.setCensorStatus("2");
            personAdapt.setApprovalReason(appeal.getAppealReson());
            personAdapt.setUpdateTime(new Date());
        }
        this.personAdaptDao.update(personAdapt);
    }

    public void handle(List<Appeal> list) {
        if (list != null && list.size() > 0) {
            JSONArray paramArr = new JSONArray();
            JSONObject param = null;
            ArrayList<PersonAdapt> gradeList = new ArrayList<PersonAdapt>();
            for (Appeal appeal : list) {
                PersonAdapt personAdapt = this.personAdaptDao.findById(appeal.getBusinessid());
                if ("003".equals(appeal.getAppealState())) {
                    personAdapt.setApprovalState("0");
                    personAdapt.setCensorStatus("1");
                    personAdapt.setApprovalReason(null);
                    personAdapt.setUpdateTime(new Date());
                } else if ("004".equals(appeal.getAppealState())) {
                    personAdapt.setApprovalState("2");
                    personAdapt.setCensorStatus("2");
                    personAdapt.setApprovalReason(appeal.getAppealReson());
                    personAdapt.setUpdateTime(new Date());
                }
                param = new JSONObject();
                param.put("adaptApplyId", (Object)(personAdapt.getId() + ""));
                param.put("backgroundStatus", (Object)personAdapt.getCensorStatus());
                param.put("approvalState", (Object)personAdapt.getApprovalState());
                param.put("backgroundFailReason", (Object)personAdapt.getApprovalReason());
                param.put("backgroundType", (Object)"2");
                paramArr.add((Object)param);
                gradeList.add(personAdapt);
            }
            HashMap<String, Object> paramMap = new HashMap<String, Object>();
            paramMap.put("personList", JSON.toJSONString((Object)paramArr));
            AjaxResult result = this.bktInterfaceUtil.callInterface("train/bbd/adapt/person/backgroundStatus", paramMap);
            if (!result.isSuccessful()) {
                throw new ArsException("\u3010\u5c97\u4f4d\u9002\u5e94\u6027\u62a5\u540d\u7533\u8bc9\u7ed3\u679c\u3011" + result.getMsg());
            }
            this.personAdaptDao.saveBatch(gradeList);
        }
    }
}

