package com.bcxin.ars.service.task;

import com.bcxin.ars.dto.page.ComTempTaskPageSearchDto;
import com.bcxin.ars.dto.task.ComTempTaskDto;
import com.bcxin.ars.model.task.ComTempTask;
import com.bcxin.ars.dto.DataSynchronizationSearchDto;
import com.bcxin.ars.model.task.ComTempTaskPer;
import com.com.bcxin.ars.com.abcxin.smart.core.web.validate.AjaxPageResponse;

import java.util.List;


/**
 * 临保任务Service接口
 * 
 * @author lin
 * @date 2021-02-01
 */
public interface ComTempTaskService{
    /****
     * 删除
     * @param comTempTask
     * @return
     */
    int delete(ComTempTask comTempTask);

    /****
     * 保存
     * @param comTempTask
     * @return
     */
    int save(ComTempTask comTempTask);

    /****
     * 选择性修改
     * @param comTempTask
     * @return
     */
    void updateSelective(ComTempTask comTempTask);

    /****
     * 主键查询
     * @param id
     * @return
     */
    ComTempTask findById(Long id);

    /**
     * 分页查询
     * @param searchDto
     * @param page
     * @return
     */
    void searchForPage(ComTempTaskPageSearchDto searchDto, AjaxPageResponse<ComTempTaskDto> page);

    /**
     * 外导内查询
     * @param searchDto
     * @return
     */
    List<ComTempTask> searchForDataSynchronization(DataSynchronizationSearchDto searchDto);

    /**
     * 内导外查询
     * @param startDate
     * @return
     */
    List<ComTempTask> findDSOutList(String startDate);

    /**
     * 批量保存
     * @param list
     */
    void importBatch(List<ComTempTask> list);

    /**
     * 批量查询
     * @param list
     * @return
     */
    List<ComTempTask> findByBatchId(List<ComTempTask> list);

    /**
     * 保存任务人员
     * @param comTempTask
     */
    void saveTaskPer(ComTempTaskDto comTempTask);

    /**
     * 移除任务人员
     * @param comTempTaskPer
     */
    void removePer(ComTempTaskPer comTempTaskPer);
}
