package com.bcxin.ars.service.task;
import com.bcxin.ars.dto.DataSynchronizationSearchDto;
import com.bcxin.ars.dto.task.BbdTaskSchedul;
import com.bcxin.ars.model.task.ComTaskSchedul;
import com.com.bcxin.ars.com.abcxin.smart.core.web.validate.AjaxPageResponse;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 * 任务排班制明细Service接口
 *
 * @author linqinglin
 * @Date 2020-03-24 16:43:05
 */
public interface ComTaskSchedulService {

   /****
     * 删除
     * @param comTaskSchedul
     * @return
     */
    int delete(ComTaskSchedul comTaskSchedul);

    /****
     * 保存
     * @param comTaskSchedul
     * @return
     */
    int save(ComTaskSchedul comTaskSchedul);

    /****
     * 主键查询
     * @param id
     * @return
     */
    ComTaskSchedul findById(Long id);

    /**
     * 外导内查询
     * @param searchDto
     * @return
     */
    List<ComTaskSchedul> searchForDataSynchronization(DataSynchronizationSearchDto searchDto);

    /**
     * 内导外查询
     * @param startDate
     * @return
     */
    List<ComTaskSchedul> findDSOutList(String startDate);

    /**
     * 批量保存
     * @param list
     */
    void importBatch(List<ComTaskSchedul> list);

    /**
     * 批量查询
     * @param list
     * @return
     */
    List<ComTaskSchedul> findByBatchId(List<ComTaskSchedul> list);

    void saveBatch(List<BbdTaskSchedul> taskSchedul,Long comTaskId,String startDate,String endDate);
}
