package com.bcxin.ars.service.task;

import com.bcxin.ars.dto.DataSynchronizationSearchDto;
import com.bcxin.ars.dto.page.task.ComContractSearchDto;
import com.bcxin.ars.dto.task.ComContractDto;
import com.bcxin.ars.model.task.ComContract;
import com.com.bcxin.ars.com.abcxin.smart.core.web.validate.AjaxPageResponse;

import java.util.List;

/**
 * 合同service接口
 * @author linqinglin
 * @date 2019/10/12 0012 17:45
 */
public interface ComContractService {

    /**
     * 根据id查询
     * @param id
     * @return
     */
    ComContract findById(Long id);

    /**
     * 分页查询
     * @param dto
     * @param page
     */
    void search(ComContractSearchDto dto, AjaxPageResponse<ComContract> page);

    /**
     * 保存
     * @param comContract
     */
    void save(ComContract comContract);

    /**
     * 批量导入
     * @param list
     */
    void importBatch(List<ComContract> list);

    /**
     * 外导内数据查询
     * @param dto
     * @return
     */
    List<ComContract> searchForDataSynchronization(DataSynchronizationSearchDto dto);

    /**
     * 根据人员id获取劳动合同
     * @param perId
     * @return
     */
    List<ComContract> findByPerId(Long perId);
    ComContractDto findDetailById(Long id);
    /***
     * 将合同信息图片转换成本地地址
     */
    void converImg();
}
