package com.bcxin.ars.service.sb;

import com.bcxin.ars.dto.DataSynchronizationSearchDto;
import com.bcxin.ars.dto.sb.SubsidiarySearchDto;
import com.bcxin.ars.model.PageResult;
import com.bcxin.ars.model.sb.Subsidiary;
import com.bcxin.ars.model.sys.Approval;
import com.com.bcxin.ars.com.abcxin.smart.core.web.validate.AjaxPageResponse;

import java.util.List;
import java.util.Map;

public interface SubsidiaryService {

	Subsidiary findById(long id);
	/**
	 *
	 * @Decription:批量查询
	 * @author：zhongjianhui
	 * @method  findByBatchId
	 * @date：2018/8/16 13:30
	 * @params： * @param approvalList
	 * @return java.util.List<com.bcxin.ars.model.sb.Subsidiary>
	 */
	List<Subsidiary> findByBatchId(List<Approval> approvalList);
	
	void saveOrUpdate(Subsidiary subsidiary);

	void saveOrUpdateForDS(Subsidiary subsidiary);
	/***
	 * 查询培训单位信息
	 * @param dto
	 * @return
	 */
	SubsidiarySearchDto search(SubsidiarySearchDto dto);

	Subsidiary findByUser(Long userid);

    List<Subsidiary> searchForDataSynchronization(DataSynchronizationSearchDto searchDto);

	List<Subsidiary> findAll();

	PageResult searchSubsidiaryList_table(Map<Object, Object> p);

	void saveOrUpdateForApproval(Subsidiary subsidiary);

    void updateCensorStatus(Subsidiary subsidiary);

    void saveOrUpdateForApprovalImport(Subsidiary subsidiary);
	/**
	 *
	 * @Decription:批量插入
	 * @author：zhongjianhui
	 * @method  saveOrUpdateForApprovalBatchImport
	 * @date：2018/8/16 13:37
	 * @params： * @param subsidiary
	 * @return void
	 */;
	void saveOrUpdateForApprovalBatchImport(List<Subsidiary> subsidiary);

    void searchForPage(SubsidiarySearchDto dto, AjaxPageResponse<Subsidiary> page);
}
