package com.bcxin.ars.service.sb;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.bcxin.ars.dto.AjaxResult;
import com.bcxin.ars.dto.DataSynchronizationSearchDto;
import com.bcxin.ars.dto.SecurityPersonSearchRerurnDTO;
import com.bcxin.ars.dto.ZTree;
import com.bcxin.ars.dto.page.PerconUnRegDto;
import com.bcxin.ars.dto.page.PersonPageSearchDto;
import com.bcxin.ars.dto.report.PersonCertificateReportData;
import com.bcxin.ars.dto.report.ReportDataSearchDto;
import com.bcxin.ars.dto.sb.*;
import com.bcxin.ars.exception.ValidateException;
import com.bcxin.ars.model.PageResult;
import com.bcxin.ars.model.User;
import com.bcxin.ars.model.sb.BackgroundApproval;
import com.bcxin.ars.model.sb.Personcertificate;
import com.bcxin.ars.model.sb.VPersoncertificate;
import com.bcxin.ars.model.sys.Approval;
import com.com.bcxin.ars.com.abcxin.smart.core.web.validate.AjaxPageResponse;

import java.io.File;
import java.util.List;
import java.util.Map;

/**
 * Created by 苏 on 2017/5/19.
 */
public interface PersoncertificateService {


	/**
	 * 保安员资格证考试报名数据统计列表 param p by llc 2018-08-24
	 */
	PageResult statisCertificateList(Map<Object, Object> p);

	/**
	 * 保安员资格证考试报名数据统计数量
	 * 
	 * @param p
	 * @return by llc 2018-08-23
	 */

	Map<String, Object> statisCertificate(Map<Object, Object> p);

	Personcertificate findById(long id);

	Personcertificate findDetailById(long id);

	/**
	 *
	 * @Decription:批量查找
	 * @author：zhongjianhui
	 * @method findById @date：2018/8/16 17:50 @params： * @param
	 *         personcertificateList
	 * @return java.util.List<com.bcxin.ars.model.sb.Personcertificate>
	 */
	List<Personcertificate> findByApprovalBatchId(List<Approval> approvalList);

	/**
	 *
	 * @Decription:批量更新
	 * @author：zhongjianhui
	 * @method findById @date：2018/8/16 17:50 @params： * @param
	 *         personcertificateList
	 * @return java.util.List<com.bcxin.ars.model.sb.Personcertificate>
	 */
	void updateBatch(List<Personcertificate> personcertificates);

	/**
	 * 保存保安员证报名（saas）
	 * @param personcertificate
	 */
	void saveOrUpdateForSaas(Personcertificate personcertificate);

	void saveOrUpdate(Personcertificate personcertificate);

	void updateTestSocre(Personcertificate personcertificate);

	void saveOrUpdateForDS(Personcertificate personcertificate);

	PersoncertificateSearchDto search(PersoncertificateSearchDto dto);

	void delete(Personcertificate personcertificate);

	Personcertificate findByUser(Long userid);

	List<Personcertificate> searchForDataSynchronization(DataSynchronizationSearchDto searchDto);

	ExamSearchDto findUnScheduledPersonList(ExamSearchDto searchDto);

	void updateExamState(ExamDetailDto examDetail);
	/**
	 *
	 * @Decription:确认所选择的人员哪些不可制证
	 * @author：zhongjianhui
	 * @method  checkConfirmOrder
	 * @date：2018/12/13 13:44
	 * @params： * @param personIds
	 * @return java.util.List<java.util.Map>
	 */
	List<Map> checkConfirmOrder(Long[] personIds);
	/**
	 *
	 * @Decription:批量修改制证状态
	 * @author：zhongjianhui
	 * @method  batchSaveConfirmOrder
	 * @date：2018/12/13 13:49
	 * @params： * @param personIds
	 * @param username
	 * @return void
	 */
	void batchSaveConfirmOrder(Long[] personIds,String username);
	/**
	 *
	 * @Decription:批量更新成绩
	 * @author：zhongjianhui
	 * @method updateScoreByBetchID @date：2018/8/21 15:49 @params： * @param
	 *         personcertificateList
	 * @return com.alibaba.fastjson.JSONArray
	 */
	JSONArray updateScoreByBetchID(List<Personcertificate> personcertificateList);

	/**
	 * 更新报名确认
	 *
	 * @param id
	 *            主键
	 * @return
	 */
	void updateBMStateForApprovalByid(Long id, String signConfirm);

	/**
	 * 根据身份证返回制证状态
	 *
	 * @param cardnumber
	 * @return
	 */
	Personcertificate getCardStateByCardnumber(String cardnumber);

	/**
	 * 通过idList查询保安员资格证考试信息
	 *
	 * @param paramList
	 * @return by llc 2018-06-19
	 */
	List<Personcertificate> getPersoncertificateListByParamList(List<Map<String, String>> paramList);

	/**
	 * 根据身份证,科目编号返回制证状态
	 *
	 * @param personcertificate
	 * @return
	 */
	Personcertificate getCardState(Personcertificate personcertificate);

	/**
	 * 根据主键更新保安员证考试的缴费状态
	 *
	 * @param personcertificate
	 *            by llc 2018-06-25
	 */
	void updatefeeStateById(Personcertificate personcertificate);

	List<Personcertificate> findAll();

	/**
	 * 增加与saas对接的通知 wjb 2018年10月18日09:18:18
	 * 保安员考试报名审核通过后，系统通知线下录指纹（短信通知）
	 * @param personcertificate
	 * @param dbPersoncertificate
	 */
	void sendMsg(Personcertificate personcertificate, Personcertificate dbPersoncertificate);

	/**
	 * 保安员证消息通知
	 * 
	 * @param personcertificate
	 * @param newsTitle
	 * @param title
	 * @param content
	 */
	void sendMsg(Personcertificate personcertificate, String newsTitle, String title, String content);
	/**
	 * 保安员证消息通知
	 *
	 * @param personcertificate
	 * @param newsTitle
	 * @param title
	 * @param content
	 */
	void sendMsgHuaWei(Personcertificate personcertificate, String newsTitle, String title, String content,String smsCode,String[] parems);


	void temporarySave(Personcertificate personcertificate);

	/**
	 * 查找未收入指纹的人员
	 *
	 * @return
	 */
	List<Personcertificate> findNofinger();

	PersonCertificateReportData dataStatisticsReport(ReportDataSearchDto searchDto);

	PageResult searchPrintList(Map<Object, Object> p);

	void exportSecurityCertificate(List<Personcertificate> data, File file);

	PersoncertificateSearchDto searchExport(PersoncertificateSearchDto dto);

	/**
	 *
	 * @Decription:保安员证法人在线支付生成订单
	 * @author：zhongjianhui
	 * @method payForPersonCertificate @date：2018/8/24 14:37 @params： * @param
	 *         personCertificateId  * @param orgPriceDTOList  * @param organID
	 * @return com.alibaba.fastjson.JSONObject
	 */
	JSONObject payForPersonCertificate(List<Personcertificate> personcertificateList, List<OrgPriceDTO> orgPriceDTOList,
			String organIDs, String userName, Long payId);

	/**
	 * 更新缴费标志
	 *
	 * @param personcertificate
	 */
	void updatePayConfirm(Personcertificate personcertificate);

	PageResult queryTable(PersoncertificateSearchDto searchDto);

	void insertBatchTemp(List<Personcertificate> personlist);

	void deleteTempData();

	List<Personcertificate> findUpdateListFromTemp();

	void updatefingercardState(Personcertificate dbpersoncertificate);

	List<Personcertificate> findByNumberIdArr(PersoncertificateSearchDto dto);

	/**
	 * 通过id集合查询保安员证考试报名
	 *
	 * @param dto
	 *            by llc 2018-06-22
	 */
	List<Personcertificate> findByDtoIdArr(PersoncertificateSearchDto dto);

	List<ZTree> getPersonPayTree();

	void saveOrUpdateForApprovalImport(Personcertificate personcertificate);

	void saveOrUpdateForApproval(Personcertificate personcertificate);

	void saveOrUpdateForImport(Personcertificate personcertificate);

	void updateCensorStatus(Personcertificate personcertificate);

	void updateExport(Personcertificate personcertificate);

	void sendMsg(Personcertificate personcertificate, Approval approval);

	/**
	 * 根据Id查找
	 *
	 * @param id
	 * @return
	 */
	Personcertificate getCardStateByIds(String id);

	/**
	 * 根据Id更新指纹录入状态
	 *
	 * @param personcertificate
	 */
	void updatefingercardStateById(Personcertificate personcertificate);

	/**
	 * 根据Id更新报名状态
	 *
	 * @param id
	 * @param s
	 */
	void updateBMStateByid(Long id, String s);
	/**
	 * 生成补贴名单
	 * @param list
	 */
    void generateSubsidyRoster(List<Personcertificate> list);

    /**
	 * 根据Id更新报名状态
	 *
	 * @param id
	 *            身份证号
	 * @return
	 */
	void updateBMStateByid(Long id);

	/**
	 * 根据Id更新制证状态
	 *
	 * @param personcertificate
	 */
	void updatecardStateByIds(Personcertificate personcertificate);

	/**
	 * 处理保安员证业务逻辑 by llc 2018-08-08
	 *
	 * @param list
	 */
	List<Map<String, String>> saveSecurityCertificate(List<Map<String, String>> list, User user);

	/**
	 * 获取需要新增的考试人员名单分页功能
	 *
	 * @param searchDto
	 * @return
	 */
	PageResult query(ExamSearchDto searchDto);

	/**
	 *
	 * @Decription:线上缴费，批量更新缴费状态、培训机构ID、培训机构名称
	 * @author：zhangye
	 * @method updateBktfeeStateByBatchID @date：2018/8/29 14:33 @params：
	 *         * @param personcertificateList
	 * @return JSONArray
	 */
	JSONArray updateBktfeeStateByBatchID(List<SecurityPersonSearchRerurnDTO> personcertificateList);

	/**
	 * 流程结束
	 * @param personcertificate
	 */
	void updateProState(Personcertificate personcertificate);

	/**
	 * 根据身份证号批量结束流程
	 * @param dto
	 * @param examID
	 */
	void updateProstateByNumberIdArr(PersoncertificateSearchDto dto, String examID);

	//定时背景筛查
	void autoUpdateCensorStatus();

    /****
     * 查询要背景筛查人员
     * @return
     */
    List<Personcertificate> findNoCensorStatus();
    /****
     * 背景筛查
     * @param personcertificate
     */
    void updateCensorStatusForAuto(Personcertificate personcertificate);

    void updateCensorStatusForAuto(Personcertificate personcertificate, List<BackgroundApproval> list);

    /**
     * 根据保安员id查询保安员证申报信息
     * @param personId
     * @return
     */
    Personcertificate findBySecurityPersonId(Long personId);

	/**
	 *获取同步到外网的数据列表
	 * @param startDate 开始日期
	 */
	List<Personcertificate> findDSOutList(String startDate);

	/**
	 * 批量插入同步数据
	 * @param list
	 */
	void importBatch(List<Personcertificate> list);

    void autoUpdateCensorForImportOldData();

	SAASPersonCerDto getDetailForSAAS(Long personId);

    void searchForSAASPage(SAASPersonCertificateSearchDto searchDto, AjaxPageResponse<SAASPersonCertificateDto> page);

    int checkApplyForSAAS(Long personId);

	/**
	 * 根据id取消缴费状态
	 * @param personIds
	 */
	JSONObject cancelFeeState(Long[] personIds);

	List<Personcertificate> findByIdArr(Long[] personIds);

    JSONObject batchRepulse(Long[] longIds, String returnreason);

    void searchForPage(PersoncertificateSearchDto dto, AjaxPageResponse<PersoncertificateDto> page);

	/**
	 * 资格证报名信息查询
	 * @param dto
	 * @param page
	 */
	void searchPage(SearchPersonCertificateDto dto, AjaxPageResponse<VPersoncertificate> page);

	/**
	 * 通过id查询人口地址
	 * @param idArray
	 * @return
	 */
	List<Personcertificate> findAddressByIdArr(Long[] idArray);
	/**
	 * 通过id查询人口地址
	 * @param id
	 * @return
	 */
    Personcertificate findAddressById(Long id);

	/**
	 * 通过身份证号码查询保安员资格证书信息
	 * @return
	 */
	List<SecurityCertificateInfoDto> findCertificate();

	/**
	 * 批量修改资格证报名
	 * @param list
	 */
    void batchUpdate(List<Personcertificate> list);

    void searchUnRegisterForPage(PersonPageSearchDto dto, AjaxPageResponse<PerconUnRegDto> page);

	List<SecurityCertificateInfoDto> findCerInfoByIdNums(String[] idNums);

	void updateTrainMaterials(List<Personcertificate> personcertificates);

	void updateSelective(Personcertificate personcertificate);

	void inputFingerprint(Personcertificate personcertificate);

	List<Personcertificate> findUnGenerateSubsidyRoster();

	/**
	 * 资格证报名信息接口
	 *
	 * @param personCertificates 报名信息
	 * @return 报名结果
	 * @throws ValidateException ex
	 */
	AjaxResult personCertificateApply(String personCertificates) throws ValidateException;

	/**
	 * 撤销报名
	 *
	 * @param personCertificateId id
	 * @return 撤销结果
	 */
	AjaxResult cancelPersonCertificateApply(String personCertificateId);

	/**
	 * 批量注册资格证
	 *
	 * @param securityCertificates 资格证信息
	 * @return {身份证,true/false}
	 */
	AjaxResult signUpSecurityCertificate(String securityCertificates);

	/**
	 * 补贴人员明细
	 *
	 * @param
	 * @return
	 */
	void searchSubsidyPage(SearchPersonCertificateDto dto, AjaxPageResponse<VPersoncertificate> page);
}
