package com.bcxin.ars.service.sb;

import com.bcxin.ars.dto.DataSynchronizationSearchDto;
import com.bcxin.ars.dto.page.InvestorPageSearchDto;
import com.bcxin.ars.dto.sb.InvestorSearchDto;
import com.bcxin.ars.model.sb.Investor;
import com.com.bcxin.ars.com.abcxin.smart.core.web.validate.AjaxPageResponse;

import java.util.List;

public interface InvestorService {

	Investor findById(long id);
	
	void saveOrUpdate(Investor investor);
	
	InvestorSearchDto search(InvestorSearchDto dto);

	void delete(Investor investor);

	List<Investor> searchForDataSynchronization(DataSynchronizationSearchDto searchDto);

	void saveOrUpdateForDS(Investor investor);

	List<Investor> findByUserId(Long userId);

	/**
	 * 分页查询
	 * @param searchDto
	 * @param page
	 * @return
	 */
	void searchForPage(InvestorPageSearchDto searchDto, AjaxPageResponse<Investor> page);
}
