package com.bcxin.ars.service.sb;

import com.bcxin.ars.dto.DataSynchronizationSearchDto;
import com.bcxin.ars.dto.page.CerLearnAuthRecordPageSearchDto;
import com.bcxin.ars.model.sb.CerLearnAuthRecord;
import com.com.bcxin.ars.com.abcxin.smart.core.web.validate.AjaxPageResponse;

import java.util.List;


/**
 * 资格证/等级证学习认证记录Service接口
 * 
 * @author lin
 * @date 2020-09-08
 */
public interface CerLearnAuthRecordService {
    /****
     * 删除
     * @param cerLearnAuthRecord
     * @return
     */
    int delete(CerLearnAuthRecord cerLearnAuthRecord);

    /****
     * 保存
     * @param cerLearnAuthRecord
     * @return
     */
    int save(CerLearnAuthRecord cerLearnAuthRecord);

    /****
     * 选择性修改
     * @param cerLearnAuthRecord
     * @return
     */
    void updateSelective(CerLearnAuthRecord cerLearnAuthRecord);

    /****
     * 主键查询
     * @param id
     * @return
     */
    CerLearnAuthRecord findById(Long id);

    /**
     * 分页查询
     * @param searchDto
     * @param page
     * @return
     */
    void searchForPage(CerLearnAuthRecordPageSearchDto searchDto, AjaxPageResponse<CerLearnAuthRecord> page);

    /**
     * 外导内查询
     * @param searchDto
     * @return
     */
    List<CerLearnAuthRecord> searchForDataSynchronization(DataSynchronizationSearchDto searchDto);

    /**
     * 内导外查询
     * @param startDate
     * @return
     */
    List<CerLearnAuthRecord> findDSOutList(String startDate);

    /**
     * 批量保存
     * @param list
     */
    void importBatch(List<CerLearnAuthRecord> list);

    /**
     * 批量查询
     * @param list
     * @return
     */
    List<CerLearnAuthRecord> findByBatchId(List<CerLearnAuthRecord> list);


}
