package com.bcxin.ars.service.conference;

import com.bcxin.ars.dto.AjaxResult;
import com.bcxin.ars.dto.conference.ConferenceSearchDto;
import com.bcxin.ars.dto.conference.PageRecordFile;
import com.bcxin.ars.dto.conference.RecordDto;
import com.bcxin.ars.dto.conference.RecordFileInfo;
import com.bcxin.ars.model.conference.CloudConference;
import com.com.bcxin.ars.com.abcxin.smart.core.web.validate.AjaxPageResponse;

import java.util.List;

/***
 * 会议信息服务层
 * @author subh
 */
public interface CloudConferenceService {


    /**
     * 分页查询
     * @param searchDto
     * @param page
     */
    void searchForPage(ConferenceSearchDto searchDto, AjaxPageResponse page);

    /***
     * 保存
     * @param conference  会议信息
     * @return
     */
    CloudConference save(CloudConference conference);

    CloudConference findById(Long id);

    /***
     * 结束会议
     * @param meetId
     */
    void end(String meetId);
    /***
     * 更新confuuid
     * @param meetId
     */
    void getConfUUID(String meetId);
    void saveAccountMembers(CloudConference conference);

    /***
     * 保存释放主度
     * @param conference  会议信息
     * @return
     */
    CloudConference saveCloudecReleaseChairman(CloudConference conference);

    /***
     * 从华为云获取记录并结束会议
     * @param conference
     */
    void endConference(CloudConference conference);

    /**
     * 从华为云查询录播文件列表
     * @param recordDto
     * @return
     */
    void queryRecordList(RecordDto recordDto, AjaxPageResponse page) throws Exception;

    /**
     * 批量删除录播文件
     * @param confUUIDs
     * @return
     */
    AjaxResult batchDeleteRecord(String[] confUUIDs);

}
