package com.bcxin.ars.service.certificate;
import com.bcxin.ars.dto.DataSynchronizationSearchDto;
import com.bcxin.ars.model.certificate.PerCerSnapshot;
import com.bcxin.ars.dto.page.PerCerSnapshotPageSearchDto;
import com.com.bcxin.ars.com.abcxin.smart.core.web.validate.AjaxPageResponse;

import java.util.List;

/**
 * 保安员资格证打印快照Service接口
 *
 * @author linqinglin
 * @Date 2020-04-16 16:39:19
 */
public interface PerCerSnapshotService {

   /****
     * 删除
     * @param perCerSnapshot
     * @return
     */
    int delete(PerCerSnapshot perCerSnapshot);

    /****
     * 保存
     * @param perCerSnapshot
     * @return
     */
    int save(PerCerSnapshot perCerSnapshot);

    /****
     * 选择性修改
     * @param perCerSnapshot
     * @return
     */
    void updateSelective(PerCerSnapshot perCerSnapshot);

    /****
     * 主键查询
     * @param id
     * @return
     */
    PerCerSnapshot findById(Long id);

    /**
     * 分页查询
     * @param searchDto
     * @param page
     * @return
     */
    void searchForPage(PerCerSnapshotPageSearchDto searchDto, AjaxPageResponse<PerCerSnapshot> page);

    /**
     * 外导内查询
     * @param searchDto
     * @return
     */
    List<PerCerSnapshot> searchForDataSynchronization(DataSynchronizationSearchDto searchDto);

    /**
     * 内导外查询
     * @param startDate
     * @return
     */
    List<PerCerSnapshot> findDSOutList(String startDate);

    /**
     * 批量保存
     * @param list
     */
    void importBatch(List<PerCerSnapshot> list);

    /**
     * 批量查询
     * @param list
     * @return
     */
    List<PerCerSnapshot> findByBatchId(List<PerCerSnapshot> list);
}
