package com.bcxin.ars.service.certificate;
import com.bcxin.ars.dto.DataSynchronizationSearchDto;
import com.bcxin.ars.model.certificate.GradeCompleteCer;
import com.bcxin.ars.dto.page.GradeCompleteCerPageSearchDto;
import com.com.bcxin.ars.com.abcxin.smart.core.web.validate.AjaxPageResponse;
import java.util.List;

/**
 * 保安员等级证报名结业证书Service接口
 *
 * @author linqinglin
 * @Date 2020-02-04 10:50:12
 */
public interface GradeCompleteCerService {

   /****
     * 删除
     * @param gradeCompleteCer
     * @return
     */
    int delete(GradeCompleteCer gradeCompleteCer);

    /****
     * 保存
     * @param gradeCompleteCer
     * @return
     */
    int save(GradeCompleteCer gradeCompleteCer);

    /****
     * 主键查询
     * @param id
     * @return
     */
    GradeCompleteCer findById(Long id);

    /**
     * 分页查询
     * @param searchDto
     * @param page
     * @return
     */
    void searchForPage(GradeCompleteCerPageSearchDto searchDto, AjaxPageResponse<GradeCompleteCer> page);

    /**
     * 外导内查询
     * @param searchDto
     * @return
     */
    List<GradeCompleteCer> searchForDataSynchronization(DataSynchronizationSearchDto searchDto);

    /**
    * 外网数据同步到内网
    * @param list
    */
    void saveOrUpdateForDS(List<GradeCompleteCer> list);

    /**
     * 内导外查询
     * @param startDate
     * @return
     */
    List<GradeCompleteCer> findDSOutList(String startDate);

    /**
     * 批量保存
     * @param list
     */
    void importBatch(List<GradeCompleteCer> list);

    /**
     * 批量查询
     * @param list
     * @return
     */
    List<GradeCompleteCer> findByBatchId(List<GradeCompleteCer> list);

    /**
     * 选择性更新
     * @param gradeCompleteCer
     */
    void updateSelective(GradeCompleteCer gradeCompleteCer);

    /**
     * 根据报名id查询结业证书信息
     * @param personGradeId
     * @return
     */
    GradeCompleteCer findByPersonGradeId(Long personGradeId);

    /**
     * 根据报名id查询结业证书信息包含二维码
     * @param personGradeId
     * @return
     * @throws Exception
     */
    @Deprecated
    GradeCompleteCer findByPersonGradeIdWithQRCode(Long personGradeId) throws Exception;

   /**
    * 生成结业证书二维码
    * @param cerId
    * @return
    * @throws Exception
    */
    String createRQCode(String cerId) throws Exception;

 /**
  * 获取结业证书前端H5访问地址
  * @param cerId
  * @return
  * @throws Exception
  */
    String getBbdH5Url(String cerId) throws Exception;

    GradeCompleteCer findByIdNum(String idNum, String gradeLevel);
}
