package com.bcxin.ars.service;

import com.bcxin.ars.dto.AjaxResult;
import com.bcxin.ars.dto.DataSynchronizationSearchDto;
import com.bcxin.ars.dto.SecurityGuardSearchDto;
import com.bcxin.ars.enums.DataSyncType;
import com.bcxin.ars.model.BusinessCommon;
import com.bcxin.ars.model.PageResult;
import com.bcxin.ars.model.SecurityGuard;
import com.bcxin.ars.model.User;
import com.bcxin.ars.model.sb.Sponsorlicense;
import com.com.bcxin.ars.com.abcxin.smart.core.web.validate.AjaxPageResponse;

import java.util.List;
import java.util.Map;

public interface SecurityGuardService {

    /**
     * @return SecurityGuard
     * @Decription:通过id查询保安师信息
     * @author：wangjianchi
     * @method findById
     * @date：2019/03/20 13:29
     * @params： * @param id
     */
    SecurityGuard findById(long id);

    SecurityGuard findByIdNumber(String idNumber);

    /**
     * @return void
     * @Decription:新增修改保安师信息
     * @author：wangjianchi
     * @method saveOrUpdate
     * @date:2019/3/22 10:11
     * @params: * @param securityGuard
     */
    AjaxResult saveOrUpdate(SecurityGuard securityGuard);

    /**
     * 批量导入保安师到数据库
     *
     * @param list
     * @param loginUser
     * @return
     */
    List<Map<String, String>>   saveSecurityGuard(List<Map<String, String>> list, User loginUser);

    /**
     * 校验保安师
     * @param sponsor
     * @return
     */
    String validateSecurityGuard(BusinessCommon businessCommon);

    /**
     * @Decription:批量保存修改
     * @param list
     * @return
     */
    void importBatch(List<SecurityGuard> list);

    /**
     * @Decription:搜索同步到内网的数据
     * @param dto
     * @return
     */
    List<SecurityGuard> searchForDataSynchronization(DataSynchronizationSearchDto dto);

    /**
     * @Decription:外到内更新修改标志
     * @param list
     * @return
     */
    void updateFlagForOutToIn(List<SecurityGuard> list);

    /**
     *获取同步到外网的数据列表
     * @param startDate 开始日期
     */
    List<SecurityGuard> findDSOutList(String startDate);

    /**
     * @Decription:分页查询保安师库数据
     * @author:wangjianchi
     * @method query
     * @date:2019/3/19 14:31
     * @params: * @param SecurityGuardSearchDto
     */
    void search(SecurityGuardSearchDto dto, AjaxPageResponse<SecurityGuard> page);

    /**
     * 许可通过后请将服务保安公司信息，与服务时间（申请时间）同步至保安师库相关字段
     * @param businessCommon
     */
    void updateSecurityCompany(BusinessCommon businessCommon);
}
