package com.bcxin.ars.service;

import java.util.List;

import com.bcxin.ars.dto.AjaxResult;
import com.bcxin.ars.dto.DataSynchronizationSearchDto;
import com.bcxin.ars.dto.sb.OrderSearchDto;
import com.bcxin.ars.model.Order;
import com.bcxin.ars.model.User;

/**
 * 订单服务类
 * @author Ethan
 */
public interface OrderService {
	
	void save(Order order);

	void saveOrUpdate(Order order);
	
	public Order findById(Long id);

	void createOrder(Order order, Long[] personIds);

	void createOrderForBx(Order order, Long[] personIds,User user);

	void createOrderForBxMF(Order order, Long[] personIds,User user);
	
	void createTransactionByOrderId(Long orderId);

	Order findByOrderNo(String orderNo);

	void update(Order order);

	List<Order> findByUserid(Long userid);

	OrderSearchDto findByTrainorgid(OrderSearchDto dto);
	
	public void sendOrderInfoToFENXIAO(Order order);

	void orderCancel(Long orderId);

	List<Order> searchForDataSynchronization(DataSynchronizationSearchDto searchDto);

	void saveOrUpdateForDS(Order order);

	Order findByRandomOrderNo(String orderNo);

	AjaxResult checkExistOrderByPersonIds(Long[] personIds,String traintype);

	void personTrainInit();
}