package com.bcxin.ars.service;

import com.bcxin.ars.dto.DataSynchronizationSearchDto;
import com.bcxin.ars.dto.page.AnnualSurveyReportPageSearchDto;
import com.bcxin.ars.model.AnnualSurveyReport;
import com.com.bcxin.ars.com.abcxin.smart.core.web.validate.AjaxPageResponse;

import javax.servlet.http.HttpServletRequest;
import java.io.FileNotFoundException;
import java.util.List;


/**
 * 北京保安从业单位和从业人员情况年度调查Service接口
 * 
 * @author lin
 * @date 2020-11-20
 */
public interface AnnualSurveyReportService{
    /****
     * 删除
     * @param annualSurveyReport
     * @return
     */
    int delete(AnnualSurveyReport annualSurveyReport);

    /****
     * 保存
     * @param annualSurveyReport
     * @return
     */
    int save(AnnualSurveyReport annualSurveyReport);

    /****
     * 选择性修改
     * @param annualSurveyReport
     * @return
     */
    void updateSelective(AnnualSurveyReport annualSurveyReport);

    /****
     * 主键查询
     * @param id
     * @return
     */
    AnnualSurveyReport findById(Long id);

    /**
     * 分页查询
     * @param searchDto
     * @param page
     * @return
     */
    void searchForPage(AnnualSurveyReportPageSearchDto searchDto, AjaxPageResponse<AnnualSurveyReport> page);

    /**
     * 外导内查询
     * @param searchDto
     * @return
     */
    List<AnnualSurveyReport> searchForDataSynchronization(DataSynchronizationSearchDto searchDto);

    /**
     * 内导外查询
     * @param startDate
     * @return
     */
    List<AnnualSurveyReport> findDSOutList(String startDate);

    /**
     * 批量保存
     * @param list
     */
    void importBatch(List<AnnualSurveyReport> list);

    /**
     * 批量查询
     * @param list
     * @return
     */
    List<AnnualSurveyReport> findByBatchId(List<AnnualSurveyReport> list);


    AnnualSurveyReport findByUserId(Long userId);

    AnnualSurveyReport findByUserIdAndFillYear(Long userId,String fillYear);

    String exportTotal(HttpServletRequest request) throws FileNotFoundException, Exception;
}
