package com.bcxin.ars.webservice;

import com.abcxin.smart.validator.annotation.MinisterialAttr;
import com.abcxin.smart.validator.annotation.MinisterialEntity;
import com.bcxin.ars.enums.MinisterialDataFormat;
import lombok.Data;

/**
 * 照片信息上报
 * @author Ethan
 */
@Data
@MinisterialEntity(tableName = "security_person", extraWhere = "and idPhoto like 'getResource.do?path=%'")
public class Zpxxb extends XxbaBaseDto {

	/**
	 * 证件号码(公民身份号码/保安服务公司编码/自招单位编码/保安培训机构编码)
	 */
	@MinisterialAttr(column = "id_number")
	private String sfzh;

	/**
	 * 照片名称
	 */
	@MinisterialAttr(column = "id_number", DATA_FORMAT = MinisterialDataFormat.PHOTONAME)
	private String zpxx;

	/**
	 * 照片内容
	 */
	@MinisterialAttr(column = "IdPhoto", DATA_FORMAT = MinisterialDataFormat.PHOTO_TO_BASE64)
	private String zpnr;

	/**
	 * 照片分类
	 */
	@MinisterialAttr(column = "\"01\"", isSubQuery = true)
	private String zpfl;

	/**
	 * 照片中文名称
	 */
	private String bz1;

	/**
	 * 备注2
	 */
	private String bz2;

	/**
	 * 备注3
	 */
	private String bz3;

}
