package com.bcxin.ars.webservice;

import com.abcxin.smart.validator.annotation.MinisterialAttr;
import com.abcxin.smart.validator.annotation.MinisterialEntity;
import com.bcxin.ars.enums.MinisterialDataFormat;
import lombok.Data;

/**
 * 保安员信息实体类
 *
 * @author Wangjianchi
 */
@Data
@MinisterialEntity(tableName = "security_person")
public class Bayxxb extends XxbaBaseDto {
    /**
     * 公民身份号码
     */
    @MinisterialAttr(column = "id_number")
    private String sfzh;
    /**
     * 姓名
     */
    @MinisterialAttr(column = "realname")
    private String xm;
    /**
     * 性别
     */
    @MinisterialAttr(column = "id_number",DATA_FORMAT = MinisterialDataFormat.GENDER)
    private String xb;
    /**
     * 出生日期
     */
    @MinisterialAttr(column = "id_number",DATA_FORMAT = MinisterialDataFormat.BIRTH)
    private String csrq;
    /**
     * 民族
     */
    @MinisterialAttr(column = "nation",defaultValue = "01",DATA_FORMAT = MinisterialDataFormat.NATION)
    private String mz;
    /**
     * 文化程度 默认 90其他
     */
    @MinisterialAttr(column = "edu",defaultValue = "90",DATA_FORMAT = MinisterialDataFormat.EDU)
    private String whcd;
    /**
     * 政治面貌
     */
    @MinisterialAttr(column = "politics")
    private String zzmm;
    /**
     * 户籍地省市县（区）
     */
    @MinisterialAttr(column = "native")
    private String hj;
    /**
     * 户籍地详址
     */
    @MinisterialAttr(column = "id_card_address")
    private String xxdz;
    /**
     * 婚姻状况
     */
    @MinisterialAttr(column = "marriage",defaultValue = "90")
    private String hyzk;
    /**
     * 兵役状况
     */
    @MinisterialAttr(column = "enrolled",defaultValue = "0",DATA_FORMAT = MinisterialDataFormat.ENROLLED)
    private String byzk;
    /**
     * 身高
     */
    @MinisterialAttr(column = "stature")
    private String sg;
    /**
     * 保安员证编码
     */
    @MinisterialAttr(column = "zgcredential")
    private String bayzbm;
    /**
     * 发证机关编码
     */
    @MinisterialAttr(column = "zgtraincompanyno")
    private String fzjgbm;
    /**
     * 发证机关名称
     */
    @MinisterialAttr(column = "zgtraincompanyname")
    private String fzjgmc;
    /**
     * 发证日期
     */
    @MinisterialAttr(column = "zgtraintime",DATE_FORMAT = "%Y%m%d")
    private String fzrq;
    /**
     * 吊销决定机关编码
     */
    private String dxjdjgbm;
    /**
     * 吊销决定机关名称
     */
    private String dxjdjg;
    /**
     * 十指指纹捺印卡号
     */
    private String zwxx;
    /**
     * 照片信息
     */
    @MinisterialAttr(column = "photo",DATA_FORMAT = MinisterialDataFormat.PHOTONAME)
    private String zpxx;
    /**
     * 培训单位编码
     */
    @MinisterialAttr(column = "zgtraincompanyno")
    private String pxdwbm;
    /**
     * 保安员职业等级
     */
    @MinisterialAttr(column = "profession_level")
    private String baydj;
    /**
     * 数据录入机关编码
     */
    private String lrjgbm;
    /**
     * 数据录入机关名称
     */
    private String lrjgmc;
    /**
     * 数据录入地（省、市、区）
     */
    private String lrd;
    /**
     * 备注1
     */
    private String bz1;
    /**
     * 备注2
     */
    private String bz2;
    /**
     * 备注3
     */
    private String bz3;
    /**
     * 是否在职
     */
    @MinisterialAttr(column = "incumbencyStatus",DATA_FORMAT = MinisterialDataFormat.BOOLEAN_CHANGE)
    private String sflz;
    /**
     * 是否有保安员证
     */
    @MinisterialAttr(column = "zgcredential",DATA_FORMAT = MinisterialDataFormat.HAVE_ZGCER)
    private String sfybaz;

    @Override
    public String toString() {
        return "Bayxxb{" +
                "sfzh='" + sfzh + '\'' +
                ", xm='" + xm + '\'' +
                ", xb=" + xb +
                ", csrq=" + csrq +
                ", mz='" + mz + '\'' +
                ", whcd='" + whcd + '\'' +
                ", zzmm='" + zzmm + '\'' +
                ", hj='" + hj + '\'' +
                ", xxdz='" + xxdz + '\'' +
                ", hyzk='" + hyzk + '\'' +
                ", byzk=" + byzk +
                ", sg=" + sg +
                ", bayzbm='" + bayzbm + '\'' +
                ", fzjgbm='" + fzjgbm + '\'' +
                ", fzjgmc='" + fzjgmc + '\'' +
                ", fzrq=" + fzrq +
                ", dxjdjgbm='" + dxjdjgbm + '\'' +
                ", dxjdjg='" + dxjdjg + '\'' +
                ", zwxx='" + zwxx + '\'' +
                ", zpxx='" + zpxx + '\'' +
                ", pxdwbm='" + pxdwbm + '\'' +
                ", baydj='" + baydj + '\'' +
                ", lrjgbm='" + lrjgbm + '\'' +
                ", lrjgmc='" + lrjgmc + '\'' +
                ", lrd='" + lrd + '\'' +
                ", bz1='" + bz1 + '\'' +
                ", bz2='" + bz2 + '\'' +
                ", bz3='" + bz3 + '\'' +
                ", sflz='" + sflz + '\'' +
                ", sfybaz='" + sfybaz + '\'' +
                '}';
    }
}
