package com.bcxin.ars.webservice;

import com.abcxin.smart.validator.annotation.MinisterialAttr;
import com.abcxin.smart.validator.annotation.MinisterialEntity;
import com.bcxin.ars.enums.MinisterialDataFormat;
import lombok.Data;

/**
 * 保安培训机构信息
 * @author Ethan
 */
@Data
@MinisterialEntity(tableName = "security_company",extraWhere = "AND institutionType='0103'")
public class Bapxdwxx extends XxbaBaseDto {

	/**
	 * 培训单位编码
	 */
	@MinisterialAttr(column = "companyCode")
	private String pxdwbm;

	/**
	 * 培训单位名称
	 */
	@MinisterialAttr(column = "`name`")
	private String pxdwmc;

	/**
	 * 注册地省市县（区
	 */
	@MinisterialAttr(column = "areacode")
	private String zcssx;

	/**
	 * 注册地址
	 */
	@MinisterialAttr(column = "location")
	private String zcdz;

	/**
	 * 主要负责人姓名
	 */
	@MinisterialAttr(column = "principal")
	private String lxrxm;

	/**
	 * 主要负责人联系电话
	 */
	@MinisterialAttr(column = "principal_phone")
	private String lxdh;

	/**
	 * 校长（院长）公民身份号码
	 */
	private String xzsfzh;

	/**
	 * 校长（院长）姓名
	 */
	private String xzxm;

	/**
	 * 校长（院长）联系电话
	 */
	private String xzdh;

	/**
	 * 注册资金
	 * @return
	 */
	@MinisterialAttr(column = "registered_money", DATA_FORMAT = MinisterialDataFormat.AMOUNT)
	private String zczj;


	/**
	 * 保安培训许可证编码
	 */
	private String pxxkz;

	/**
	 * 保安培训许可证发证机关编码
	 */
	private String fzjgbm;

	/**
	 * 保安培训许可证发证机关名称
	 */
	private String fajgmc;

	/**
	 * 保安培训许可证颁发日期
	 */
	private String xkzbfrq;

	/**
	 * 保安培训许可证吊销机关
	 */
	private String xkzdxjg;

	/**
	 * 保安培训许可证吊销日期
	 */
	private String xkzdxrq;

	/**
	 * 保安培训许可证吊销原因
	 */
	private String xkzdxyy;

	/**
	 * 保安培训机构类别
	 */
	private String pxdwlb;

	/**
	 * 备注1
	 */
	private String bz1;


	/**
	 * 备注2
	 */
	private String bz2;


	/**
	 * 备注3
	 */
	private String bz3;


}
